/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.awt.Component;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BackreferencedDataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateNode
extends Test {
    private static BackreferencedDataSet backreferences;
    protected static int DUPLICATE_NODE;
    Bag<LatLon, OsmPrimitive> nodes;

    public static BackreferencedDataSet getBackreferenceDataSet() {
        if (backreferences == null) {
            backreferences = new BackreferencedDataSet(Main.main.getEditLayer().data);
            backreferences.build();
        }
        return backreferences;
    }

    public static void clearBackreferences() {
        backreferences = null;
    }

    public DuplicateNode() {
        super(I18n.tr((String)"Duplicated nodes") + ".", I18n.tr((String)"This test checks that there are no nodes at the very same location."));
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.nodes = new Bag(1000);
    }

    @Override
    public void endTest() {
        for (List duplicated : this.nodes.values()) {
            TestError testError;
            if (duplicated.size() <= 1) continue;
            boolean sameTags = true;
            Map keys0 = ((OsmPrimitive)duplicated.get(0)).getKeys();
            keys0.remove("created_by");
            for (int i = 0; i < duplicated.size(); ++i) {
                Map keysI = ((OsmPrimitive)duplicated.get(i)).getKeys();
                keysI.remove("created_by");
                if (((Object)keys0).equals(keysI)) continue;
                sameTags = false;
            }
            if (!sameTags) {
                testError = new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Nodes at same position"), DUPLICATE_NODE, duplicated);
                this.errors.add(testError);
                continue;
            }
            testError = new TestError((Test)this, Severity.ERROR, I18n.tr((String)"Duplicated nodes"), DUPLICATE_NODE, duplicated);
            this.errors.add(testError);
        }
        super.endTest();
        this.nodes = null;
    }

    @Override
    public void visit(Node n) {
        if (n.isUsable()) {
            this.nodes.add(n.getCoor(), (OsmPrimitive)n);
        }
    }

    @Override
    public Command fixError(TestError testError) {
        LinkedList<? extends OsmPrimitive> sel = new LinkedList<OsmPrimitive>(testError.getPrimitives());
        LinkedList<Node> nodes = new LinkedList<Node>(OsmPrimitive.getFilteredList(sel, Node.class));
        Node target = MergeNodesAction.selectTargetNode(nodes);
        if (DuplicateNode.checkAndConfirmOutlyingDeletes(nodes)) {
            return MergeNodesAction.mergeNodes((OsmDataLayer)Main.main.getEditLayer(), (BackreferencedDataSet)DuplicateNode.getBackreferenceDataSet(), nodes, (Node)target);
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        return testError.getTester() instanceof DuplicateNode;
    }

    private static boolean checkAndConfirmOutlyingDeletes(LinkedList<Node> del) {
        Area a = Main.main.getCurrentDataSet().getDataSourceArea();
        if (a != null) {
            for (Node osm : del) {
                Node n;
                if (!(osm instanceof Node) || osm.isNew() || a.contains((Point2D)(n = osm).getCoor())) continue;
                return ConditionalOptionPaneUtil.showConfirmationDialog((String)"delete_outside_nodes", (Component)Main.parent, (Object)(I18n.tr((String)"You are about to delete nodes outside of the area you have downloaded.<br>This can cause problems because other objects (that you don't see) might use them.<br>Do you really want to delete?") + "</html>"), (String)I18n.tr((String)"Confirmation"), (int)0, (int)3, (int)0);
            }
        }
        return true;
    }

    static {
        DUPLICATE_NODE = 1;
    }
}

