/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

public class NodesWithSameName
extends Test {
    protected static int SAME_NAME = 801;
    private Map<String, List<Node>> namesToNodes;

    public NodesWithSameName() {
        super(I18n.tr((String)"Nodes with same name"), I18n.tr((String)"This test finds nodes that have the same name (might be duplicates)."));
    }

    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.namesToNodes = new HashMap<String, List<Node>>();
    }

    public void visit(Node n) {
        if (!n.isUsable()) {
            return;
        }
        String name = n.get("name");
        String sign = n.get("traffic_sign");
        if (name == null || sign != null && sign.equals("city_limit")) {
            return;
        }
        List<Node> nodes = this.namesToNodes.get(name);
        if (nodes == null) {
            nodes = new ArrayList<Node>();
            this.namesToNodes.put(name, nodes);
        }
        nodes.add(n);
    }

    public void endTest() {
        block0: for (List<Node> nodes : this.namesToNodes.values()) {
            if (nodes.size() <= 1) continue;
            HashSet<String> refs = new HashSet<String>();
            for (Node n : nodes) {
                String ref = n.get("ref");
                if (ref != null && refs.add(ref)) continue;
                this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Nodes with same name"), SAME_NAME, nodes));
                continue block0;
            }
        }
        super.endTest();
        this.namesToNodes = null;
    }
}

