/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.validator.ErrorTreePanel;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.ValidatorVisitor;
import org.openstreetmap.josm.plugins.validator.tests.DuplicateNode;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorDialog
extends ToggleDialog
implements ActionListener,
SelectionChangedListener {
    private OSMValidatorPlugin plugin;
    private static final long serialVersionUID = 2952292777351992696L;
    protected ErrorTreePanel tree;
    private SideButton fixButton;
    private SideButton ignoreButton;
    private SideButton selectButton;
    private JPopupMenu popupMenu;
    private TestError popupMenuError = null;
    private DefaultMutableTreeNode lastSelectedNode = null;

    public ValidatorDialog(OSMValidatorPlugin plugin) {
        super(I18n.tr((String)"Validation errors"), "validator", I18n.tr((String)"Open the validation window."), Shortcut.registerShortcut((String)"subwindow:validator", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Validation errors")}), (int)86, (int)4, (int)1), 150);
        this.plugin = plugin;
        this.popupMenu = new JPopupMenu();
        JMenuItem zoomTo = new JMenuItem(I18n.tr((String)"Zoom to problem"));
        zoomTo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ValidatorDialog.this.zoomToProblem();
            }
        });
        this.popupMenu.add(zoomTo);
        this.tree = new ErrorTreePanel();
        this.tree.addMouseListener(new ClickWatch());
        this.tree.addTreeSelectionListener(new SelectionWatch());
        this.add(new JScrollPane(this.tree), "Center");
        JPanel buttonPanel = new JPanel(new GridLayout(1, 3));
        this.selectButton = new SideButton(I18n.marktr((String)"Select"), "select", "Validator", I18n.tr((String)"Set the selected elements on the map to the selected items in the list above."), (ActionListener)this);
        this.selectButton.setEnabled(false);
        buttonPanel.add((Component)this.selectButton);
        buttonPanel.add((Component)new SideButton((Action)((Object)plugin.validateAction)), "refresh");
        this.fixButton = new SideButton(I18n.marktr((String)"Fix"), "fix", "Validator", I18n.tr((String)"Fix the selected errors."), (ActionListener)this);
        this.fixButton.setEnabled(false);
        buttonPanel.add((Component)this.fixButton);
        if (Main.pref.getBoolean("validator.ignore", true)) {
            this.ignoreButton = new SideButton(I18n.marktr((String)"Ignore"), "delete", "Validator", I18n.tr((String)"Ignore the selected errors next time."), (ActionListener)this);
            this.ignoreButton.setEnabled(false);
            buttonPanel.add((Component)this.ignoreButton);
        } else {
            this.ignoreButton = null;
        }
        this.add(buttonPanel, "South");
        DataSet.selListeners.add(this);
    }

    public void setVisible(boolean v) {
        if (this.tree != null) {
            this.tree.setVisible(v);
        }
        super.setVisible(v);
        Main.map.repaint();
    }

    private void fixErrors(ActionEvent e) {
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        if (selectionPaths == null) {
            return;
        }
        HashSet<DefaultMutableTreeNode> processedNodes = new HashSet<DefaultMutableTreeNode>();
        DuplicateNode.clearBackreferences();
        LinkedList<TestError> errorsToFix = new LinkedList<TestError>();
        TreePath[] treePathArray = selectionPaths;
        int n = selectionPaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node != null) {
                Enumeration<TreeNode> children = node.breadthFirstEnumeration();
                while (children.hasMoreElements()) {
                    DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)children.nextElement();
                    if (processedNodes.contains(childNode)) continue;
                    processedNodes.add(childNode);
                    Object nodeInfo = childNode.getUserObject();
                    if (!(nodeInfo instanceof TestError)) continue;
                    errorsToFix.add((TestError)nodeInfo);
                }
            }
            ++n2;
        }
        FixTask fixTask = new FixTask(errorsToFix);
        Main.worker.submit((Runnable)((Object)fixTask));
    }

    private void ignoreErrors(ActionEvent e) {
        int asked = -1;
        boolean changed = false;
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        if (selectionPaths == null) {
            return;
        }
        HashSet<DefaultMutableTreeNode> processedNodes = new HashSet<DefaultMutableTreeNode>();
        TreePath[] treePathArray = selectionPaths;
        int n = selectionPaths.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                DefaultMutableTreeNode node;
                block10: {
                    block11: {
                        TreePath path = treePathArray[n2];
                        node = (DefaultMutableTreeNode)path.getLastPathComponent();
                        if (node == null) break block9;
                        Object mainNodeInfo = node.getUserObject();
                        if (mainNodeInfo instanceof TestError) break block10;
                        HashSet<String> state = new HashSet<String>();
                        if (asked == -1) {
                            Object[] a = new String[]{I18n.tr((String)"Whole group"), I18n.tr((String)"Single elements"), I18n.tr((String)"Nothing")};
                            asked = JOptionPane.showOptionDialog(Main.parent, I18n.tr((String)"Ignore whole group or individual elements?"), I18n.tr((String)"Ignoring elements"), 1, 2, null, a, a[1]);
                        }
                        if (asked != 0) break block11;
                        Enumeration<TreeNode> children = node.breadthFirstEnumeration();
                        while (children.hasMoreElements()) {
                            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)children.nextElement();
                            if (processedNodes.contains(childNode)) continue;
                            processedNodes.add(childNode);
                            Object nodeInfo = childNode.getUserObject();
                            if (!(nodeInfo instanceof TestError)) continue;
                            TestError err = (TestError)nodeInfo;
                            err.setIgnored(true);
                            changed = true;
                            state.add(node.getDepth() == 1 ? err.getIgnoreSubGroup() : err.getIgnoreGroup());
                        }
                        for (String s : state) {
                            this.plugin.ignoredErrors.add(s);
                        }
                        break block9;
                    }
                    if (asked == 2) break block9;
                }
                Enumeration<TreeNode> children = node.breadthFirstEnumeration();
                while (children.hasMoreElements()) {
                    DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)children.nextElement();
                    if (processedNodes.contains(childNode)) continue;
                    processedNodes.add(childNode);
                    Object nodeInfo = childNode.getUserObject();
                    if (!(nodeInfo instanceof TestError)) continue;
                    TestError error = (TestError)nodeInfo;
                    String state = error.getIgnoreState();
                    if (state != null) {
                        this.plugin.ignoredErrors.add(state);
                    }
                    changed = true;
                    error.setIgnored(true);
                }
            }
            ++n2;
        }
        if (changed) {
            this.tree.resetErrors();
            this.plugin.saveIgnoredErrors();
            Main.map.repaint();
        }
    }

    private void showPopupMenu(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        this.popupMenuError = null;
        TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (selPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getPathComponent(selPath.getPathCount() - 1);
        if (!(node.getUserObject() instanceof TestError)) {
            return;
        }
        this.popupMenuError = (TestError)node.getUserObject();
        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    private void zoomToProblem() {
        if (this.popupMenuError == null) {
            return;
        }
        ValidatorBoundingXYVisitor bbox = new ValidatorBoundingXYVisitor();
        this.popupMenuError.visitHighlighted(bbox);
        if (bbox.getBounds() == null) {
            return;
        }
        bbox.enlargeBoundingBox();
        Main.map.mapView.recalculateCenterScale((BoundingXYVisitor)bbox);
    }

    private void setSelectedItems() {
        if (this.tree == null) {
            return;
        }
        HashSet<? extends OsmPrimitive> sel = new HashSet<OsmPrimitive>(40);
        TreePath[] selectedPaths = this.tree.getSelectionPaths();
        if (selectedPaths == null) {
            return;
        }
        TreePath[] treePathArray = selectedPaths;
        int n = selectedPaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Enumeration<TreeNode> children = node.breadthFirstEnumeration();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)children.nextElement();
                Object nodeInfo = childNode.getUserObject();
                if (!(nodeInfo instanceof TestError)) continue;
                TestError error = (TestError)nodeInfo;
                sel.addAll(error.getPrimitives());
            }
            ++n2;
        }
        Main.main.getCurrentDataSet().setSelected(sel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("Select")) {
            this.setSelectedItems();
        } else if (actionCommand.equals("Fix")) {
            this.fixErrors(e);
        } else if (actionCommand.equals("Ignore")) {
            this.ignoreErrors(e);
        }
    }

    private boolean setSelection(Collection<OsmPrimitive> sel, boolean addSelected) {
        TestError error;
        Object nodeInfo;
        DefaultMutableTreeNode childNode;
        Enumeration<TreeNode> children;
        boolean hasFixes = false;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (this.lastSelectedNode != null && !this.lastSelectedNode.equals(node)) {
            children = this.lastSelectedNode.breadthFirstEnumeration();
            while (children.hasMoreElements()) {
                childNode = (DefaultMutableTreeNode)children.nextElement();
                nodeInfo = childNode.getUserObject();
                if (!(nodeInfo instanceof TestError)) continue;
                error = (TestError)nodeInfo;
                error.setSelected(false);
            }
        }
        this.lastSelectedNode = node;
        if (node == null) {
            return hasFixes;
        }
        children = node.breadthFirstEnumeration();
        while (children.hasMoreElements()) {
            childNode = (DefaultMutableTreeNode)children.nextElement();
            nodeInfo = childNode.getUserObject();
            if (!(nodeInfo instanceof TestError)) continue;
            error = (TestError)nodeInfo;
            error.setSelected(true);
            boolean bl = hasFixes = hasFixes || error.isFixable();
            if (!addSelected) continue;
            sel.addAll(error.getPrimitives());
        }
        this.selectButton.setEnabled(true);
        if (this.ignoreButton != null) {
            this.ignoreButton.setEnabled(true);
        }
        return hasFixes;
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        if (!Main.pref.getBoolean("validator.selectionFilter", false)) {
            return;
        }
        if (newSelection == null || newSelection.size() == 0) {
            this.tree.setFilter(null);
        }
        HashSet<OsmPrimitive> filter = new HashSet<OsmPrimitive>(newSelection);
        this.tree.setFilter(filter);
    }

    public class ClickWatch
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            ValidatorDialog.this.fixButton.setEnabled(false);
            if (ValidatorDialog.this.ignoreButton != null) {
                ValidatorDialog.this.ignoreButton.setEnabled(false);
            }
            ValidatorDialog.this.selectButton.setEnabled(false);
            boolean isDblClick = e.getClickCount() > 1;
            HashSet sel = isDblClick ? new HashSet(40) : null;
            boolean hasFixes = ValidatorDialog.this.setSelection(sel, isDblClick);
            ValidatorDialog.this.fixButton.setEnabled(hasFixes);
            if (isDblClick) {
                Main.main.getCurrentDataSet().setSelected(sel);
            }
        }

        public void mousePressed(MouseEvent e) {
            ValidatorDialog.this.showPopupMenu(e);
        }

        public void mouseReleased(MouseEvent e) {
            ValidatorDialog.this.showPopupMenu(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FixTask
    extends PleaseWaitRunnable {
        private Collection<TestError> testErrors;
        private boolean canceled;
        private LinkedList<Command> fixCommands;

        public FixTask(Collection<TestError> testErrors) {
            super(I18n.tr((String)"Fixing errors ..."), false);
            this.testErrors = testErrors == null ? new ArrayList() : testErrors;
            this.fixCommands = new LinkedList();
        }

        protected void cancel() {
            this.canceled = true;
        }

        protected void finish() {
        }

        /*
         * Exception decompiling
         */
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[WHILELOOP]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public class SelectionWatch
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent e) {
            ValidatorDialog.this.fixButton.setEnabled(false);
            if (ValidatorDialog.this.ignoreButton != null) {
                ValidatorDialog.this.ignoreButton.setEnabled(false);
            }
            ValidatorDialog.this.selectButton.setEnabled(false);
            if (e.getSource() instanceof JScrollPane) {
                System.out.println(e.getSource());
                return;
            }
            boolean hasFixes = ValidatorDialog.this.setSelection(null, false);
            ValidatorDialog.this.fixButton.setEnabled(hasFixes);
            Main.map.repaint();
        }
    }

    public static class ValidatorBoundingXYVisitor
    extends BoundingXYVisitor
    implements ValidatorVisitor {
        public void visit(OsmPrimitive p) {
            if (p.isUsable()) {
                p.visit((Visitor)this);
            }
        }

        public void visit(WaySegment ws) {
            if (ws.lowerIndex < 0 || ws.lowerIndex + 1 >= ws.way.getNodesCount()) {
                return;
            }
            this.visit((Node)ws.way.getNodes().get(ws.lowerIndex));
            this.visit((Node)ws.way.getNodes().get(ws.lowerIndex + 1));
        }
    }
}

