/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.tests.ChangePropertyKeyCommand;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.plugins.validator.util.Entities;
import org.openstreetmap.josm.plugins.validator.util.Util;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagChecker
extends Test {
    public static final String DATA_FILE = "http://svn.openstreetmap.org/applications/editors/josm/plugins/validator/tagchecker.cfg";
    public static final String IGNORE_FILE = "http://svn.openstreetmap.org/applications/editors/josm/plugins/validator/ignoretags.cfg";
    public static final String SPELL_FILE = "http://svn.openstreetmap.org/applications/utils/planet.osm/java/speller/words.cfg";
    protected static Map<String, String> spellCheckKeyData;
    protected static Bag<String, String> presetsValueData;
    protected static List<CheckerData> checkerData;
    protected static ArrayList<String> ignoreDataStartsWith;
    protected static ArrayList<String> ignoreDataEquals;
    protected static ArrayList<String> ignoreDataEndsWith;
    protected static ArrayList<IgnoreKeyPair> ignoreDataKeyPair;
    protected static ArrayList<IgnoreTwoKeyPair> ignoreDataTwoKeyPair;
    protected static final String PREFIX;
    public static final String PREF_CHECK_VALUES;
    public static final String PREF_CHECK_KEYS;
    public static final String PREF_CHECK_COMPLEX;
    public static final String PREF_CHECK_FIXMES;
    public static final String PREF_CHECK_PAINT;
    public static final String PREF_SOURCES;
    public static final String PREF_USE_DATA_FILE;
    public static final String PREF_USE_IGNORE_FILE;
    public static final String PREF_USE_SPELL_FILE;
    public static final String PREF_CHECK_KEYS_BEFORE_UPLOAD;
    public static final String PREF_CHECK_VALUES_BEFORE_UPLOAD;
    public static final String PREF_CHECK_COMPLEX_BEFORE_UPLOAD;
    public static final String PREF_CHECK_FIXMES_BEFORE_UPLOAD;
    public static final String PREF_CHECK_PAINT_BEFORE_UPLOAD;
    protected boolean checkKeys = false;
    protected boolean checkValues = false;
    protected boolean checkComplex = false;
    protected boolean checkFixmes = false;
    protected boolean checkPaint = false;
    protected JCheckBox prefCheckKeys;
    protected JCheckBox prefCheckValues;
    protected JCheckBox prefCheckComplex;
    protected JCheckBox prefCheckFixmes;
    protected JCheckBox prefCheckPaint;
    protected JCheckBox prefCheckKeysBeforeUpload;
    protected JCheckBox prefCheckValuesBeforeUpload;
    protected JCheckBox prefCheckComplexBeforeUpload;
    protected JCheckBox prefCheckFixmesBeforeUpload;
    protected JCheckBox prefCheckPaintBeforeUpload;
    protected JCheckBox prefUseDataFile;
    protected JCheckBox prefUseIgnoreFile;
    protected JCheckBox prefUseSpellFile;
    protected JButton addSrcButton;
    protected JButton editSrcButton;
    protected JButton deleteSrcButton;
    protected static int EMPTY_VALUES;
    protected static int INVALID_KEY;
    protected static int INVALID_VALUE;
    protected static int FIXME;
    protected static int INVALID_SPACE;
    protected static int INVALID_KEY_SPACE;
    protected static int INVALID_HTML;
    protected static int PAINT;
    protected JList Sources;
    protected static Entities entities;

    public TagChecker() {
        super(I18n.tr((String)"Properties checker :"), I18n.tr((String)"This plugin checks for errors in property keys and values."));
    }

    public static void initialize(OSMValidatorPlugin plugin) throws Exception {
        TagChecker.initializeData();
        TagChecker.initializePresets();
    }

    private static void initializeData() throws IOException {
        spellCheckKeyData = new HashMap<String, String>();
        String sources = Main.pref.get(PREF_SOURCES, "");
        if (Main.pref.getBoolean(PREF_USE_DATA_FILE, true)) {
            sources = sources == null || sources.length() == 0 ? DATA_FILE : "http://svn.openstreetmap.org/applications/editors/josm/plugins/validator/tagchecker.cfg;" + sources;
        }
        if (Main.pref.getBoolean(PREF_USE_IGNORE_FILE, true)) {
            sources = sources == null || sources.length() == 0 ? IGNORE_FILE : "http://svn.openstreetmap.org/applications/editors/josm/plugins/validator/ignoretags.cfg;" + sources;
        }
        if (Main.pref.getBoolean(PREF_USE_SPELL_FILE, true)) {
            sources = sources == null || sources.length() == 0 ? SPELL_FILE : "http://svn.openstreetmap.org/applications/utils/planet.osm/java/speller/words.cfg;" + sources;
        }
        String errorSources = "";
        if (sources.length() == 0) {
            return;
        }
        for (String source : sources.split(";")) {
            try {
                String line;
                InputStreamReader r;
                MirroredInputStream s = new MirroredInputStream(source, Util.getPluginDir(), -1L);
                try {
                    r = new InputStreamReader((InputStream)s, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    r = new InputStreamReader((InputStream)s);
                }
                BufferedReader reader = new BufferedReader(r);
                String okValue = null;
                Boolean tagcheckerfile = false;
                Boolean ignorefile = false;
                while ((line = reader.readLine()) != null && (tagcheckerfile.booleanValue() || line.length() != 0)) {
                    if (line.startsWith("#")) {
                        if (line.startsWith("# JOSM TagChecker")) {
                            tagcheckerfile = true;
                        }
                        if (!line.startsWith("# JOSM IgnoreTags")) continue;
                        ignorefile = true;
                        continue;
                    }
                    if (ignorefile.booleanValue()) {
                        int mid;
                        Object tmp;
                        if ((line = line.trim()).length() < 4) continue;
                        String key = line.substring(0, 2);
                        line = line.substring(2);
                        if (key.equals("S:")) {
                            ignoreDataStartsWith.add(line);
                            continue;
                        }
                        if (key.equals("E:")) {
                            ignoreDataEquals.add(line);
                            continue;
                        }
                        if (key.equals("F:")) {
                            ignoreDataEndsWith.add(line);
                            continue;
                        }
                        if (key.equals("K:")) {
                            tmp = new IgnoreKeyPair();
                            mid = line.indexOf("=");
                            ((IgnoreKeyPair)tmp).key = line.substring(0, mid);
                            ((IgnoreKeyPair)tmp).value = line.substring(mid + 1);
                            ignoreDataKeyPair.add((IgnoreKeyPair)tmp);
                            continue;
                        }
                        if (!key.equals("T:")) continue;
                        tmp = new IgnoreTwoKeyPair();
                        mid = line.indexOf("=");
                        int split = line.indexOf("|");
                        ((IgnoreTwoKeyPair)tmp).key1 = line.substring(0, mid);
                        ((IgnoreTwoKeyPair)tmp).value1 = line.substring(mid + 1, split);
                        line = line.substring(split + 1);
                        mid = line.indexOf("=");
                        ((IgnoreTwoKeyPair)tmp).key2 = line.substring(0, mid);
                        ((IgnoreTwoKeyPair)tmp).value2 = line.substring(mid + 1);
                        ignoreDataTwoKeyPair.add((IgnoreTwoKeyPair)tmp);
                        continue;
                    }
                    if (tagcheckerfile.booleanValue()) {
                        if (line.length() <= 0) continue;
                        CheckerData d = new CheckerData();
                        String err = d.getData(line);
                        if (err == null) {
                            checkerData.add(d);
                            continue;
                        }
                        System.err.println(I18n.tr((String)"Invalid tagchecker line - {0}: {1}", (Object[])new Object[]{err, line}));
                        continue;
                    }
                    if (line.charAt(0) == '+') {
                        okValue = line.substring(1);
                        continue;
                    }
                    if (line.charAt(0) == '-' && okValue != null) {
                        spellCheckKeyData.put(line.substring(1), okValue);
                        continue;
                    }
                    System.err.println(I18n.tr((String)"Invalid spellcheck line: {0}", (Object[])new Object[]{line}));
                }
            }
            catch (IOException e) {
                errorSources = errorSources + source + "\n";
            }
        }
        if (errorSources.length() > 0) {
            throw new IOException(I18n.tr((String)"Could not access data file(s):\n{0}", (Object[])new Object[]{errorSources}));
        }
    }

    public static void initializePresets() throws Exception {
        if (!Main.pref.getBoolean(PREF_CHECK_VALUES, true)) {
            return;
        }
        Collection presets = TaggingPresetPreference.taggingPresets;
        if (presets != null) {
            presetsValueData = new Bag();
            for (String a : OsmPrimitive.getUninterestingKeys()) {
                presetsValueData.add(a);
            }
            for (String a : OsmPrimitive.getDirectionKeys()) {
                presetsValueData.add(a);
            }
            for (String a : Main.pref.getCollection("validator.knownkeys", Arrays.asList("is_in", "int_ref", "fixme", "population"))) {
                presetsValueData.add(a);
            }
            for (TaggingPreset p : presets) {
                for (TaggingPreset.Item i : p.data) {
                    TaggingPreset.Key k;
                    if (i instanceof TaggingPreset.Combo) {
                        TaggingPreset.Combo combo = (TaggingPreset.Combo)i;
                        for (String value : combo.values.split(",")) {
                            presetsValueData.add(combo.key, value);
                        }
                        continue;
                    }
                    if (i instanceof TaggingPreset.Key) {
                        k = (TaggingPreset.Key)i;
                        presetsValueData.add(k.key, k.value);
                        continue;
                    }
                    if (i instanceof TaggingPreset.Text) {
                        k = (TaggingPreset.Text)i;
                        presetsValueData.add(k.key);
                        continue;
                    }
                    if (!(i instanceof TaggingPreset.Check)) continue;
                    k = (TaggingPreset.Check)i;
                    presetsValueData.add(k.key, "yes");
                    presetsValueData.add(k.key, "no");
                }
            }
        }
    }

    @Override
    public void visit(Node n) {
        this.checkPrimitive((OsmPrimitive)n);
    }

    @Override
    public void visit(Relation n) {
        this.checkPrimitive((OsmPrimitive)n);
    }

    @Override
    public void visit(Way w) {
        this.checkPrimitive((OsmPrimitive)w);
    }

    private void checkPrimitive(OsmPrimitive p) {
        Map props;
        Bag<OsmPrimitive, String> withErrors = new Bag<OsmPrimitive, String>();
        if (this.checkComplex) {
            props = p.getKeys() == null ? Collections.emptyMap() : p.getKeys();
            for (Map.Entry entry : props.entrySet()) {
                boolean ignore = true;
                String key1 = (String)entry.getKey();
                String value1 = (String)entry.getValue();
                for (IgnoreTwoKeyPair a : ignoreDataTwoKeyPair) {
                    if (key1.equals(a.key1) && value1.equals(a.value1)) {
                        ignore = false;
                        for (Map.Entry entry2 : props.entrySet()) {
                            String key2 = (String)entry2.getKey();
                            String value2 = (String)entry2.getValue();
                            for (IgnoreTwoKeyPair b : ignoreDataTwoKeyPair) {
                                if (!key2.equals(b.key2) || !value2.equals(b.value2)) continue;
                                ignore = true;
                                break;
                            }
                            if (!ignore) continue;
                            break;
                        }
                    }
                    if (!ignore) continue;
                    break;
                }
                if (ignore) continue;
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"Illegal tag/value combinations"), I18n.tr((String)"Illegal tag/value combinations"), I18n.tr((String)"Illegal tag/value combinations"), 1272, p));
                withErrors.add(p, "TC");
            }
            for (CheckerData checkerData : TagChecker.checkerData) {
                if (!checkerData.match(p).booleanValue()) continue;
                this.errors.add(new TestError((Test)this, checkerData.getSeverity(), I18n.tr((String)"Illegal tag/value combinations"), checkerData.getDescription(), checkerData.getDescriptionOrig(), checkerData.getCode(), p));
                withErrors.add(p, "TC");
            }
        }
        if (this.checkPaint && p.errors != null) {
            for (String s : p.errors) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Painting problem"), s, s, PAINT, p));
                withErrors.add(p, "P");
            }
        }
        props = p.getKeys() == null ? Collections.emptyMap() : p.getKeys();
        for (Map.Entry entry : props.entrySet()) {
            String s = I18n.marktr((String)"Key ''{0}'' invalid.");
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (this.checkValues && (value == null || value.trim().length() == 0) && !withErrors.contains(p, "EV")) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Tags with empty values"), I18n.tr((String)s, (Object[])new Object[]{key}), MessageFormat.format(s, key), EMPTY_VALUES, p));
                withErrors.add(p, "EV");
            }
            if (this.checkKeys && spellCheckKeyData.containsKey(key) && !withErrors.contains(p, "IPK")) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Invalid property key"), I18n.tr((String)s, (Object[])new Object[]{key}), MessageFormat.format(s, key), INVALID_KEY, p));
                withErrors.add(p, "IPK");
            }
            if (this.checkKeys && key.indexOf(" ") >= 0 && !withErrors.contains(p, "IPK")) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Invalid white space in property key"), I18n.tr((String)s, (Object[])new Object[]{key}), MessageFormat.format(s, key), INVALID_KEY_SPACE, p));
                withErrors.add(p, "IPK");
            }
            if (this.checkValues && value != null && (value.startsWith(" ") || value.endsWith(" ")) && !withErrors.contains(p, "SPACE")) {
                this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Property values start or end with white space"), I18n.tr((String)s, (Object[])new Object[]{key}), MessageFormat.format(s, key), INVALID_SPACE, p));
                withErrors.add(p, "SPACE");
            }
            if (this.checkValues && value != null && !value.equals(entities.unescape(value)) && !withErrors.contains(p, "HTML")) {
                this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Property values contain HTML entity"), I18n.tr((String)s, (Object[])new Object[]{key}), MessageFormat.format(s, key), INVALID_HTML, p));
                withErrors.add(p, "HTML");
            }
            if (this.checkValues && value != null && value.length() > 0 && presetsValueData != null) {
                String i;
                List<String> values = presetsValueData.get(key);
                if (values == null) {
                    Boolean ignore = false;
                    for (String string : ignoreDataStartsWith) {
                        if (!key.startsWith(string)) continue;
                        ignore = true;
                    }
                    for (String string : ignoreDataEquals) {
                        if (!key.equals(string)) continue;
                        ignore = true;
                    }
                    for (String string : ignoreDataEndsWith) {
                        if (!key.endsWith(string)) continue;
                        ignore = true;
                    }
                    if (!ignore.booleanValue()) {
                        i = I18n.marktr((String)"Key ''{0}'' not in presets.");
                        this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Presets do not contain property key"), I18n.tr((String)i, (Object[])new Object[]{key}), MessageFormat.format(i, key), INVALID_VALUE, p));
                        withErrors.add(p, "UPK");
                    }
                } else if (values.size() > 0 && !values.contains(entry.getValue())) {
                    boolean ignore = false;
                    for (IgnoreKeyPair ignoreKeyPair : ignoreDataKeyPair) {
                        if (!key.equals(ignoreKeyPair.key) || !value.equals(ignoreKeyPair.value)) continue;
                        ignore = true;
                    }
                    for (IgnoreTwoKeyPair ignoreTwoKeyPair : ignoreDataTwoKeyPair) {
                        if (!key.equals(ignoreTwoKeyPair.key2) || !value.equals(ignoreTwoKeyPair.value2)) continue;
                        ignore = true;
                    }
                    if (!ignore) {
                        i = I18n.marktr((String)"Value ''{0}'' for key ''{1}'' not in presets.");
                        this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Presets do not contain property value"), I18n.tr((String)i, (Object[])new Object[]{entry.getValue(), key}), MessageFormat.format(i, entry.getValue(), key), INVALID_VALUE, p));
                        withErrors.add(p, "UPV");
                    }
                }
            }
            if (!this.checkFixmes || value == null || value.length() <= 0 || !value.contains("FIXME") && !value.contains("check and delete") && !key.contains("todo") && !key.contains("fixme") || withErrors.contains(p, "FIXME")) continue;
            this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"FIXMES"), FIXME, p));
            withErrors.add(p, "FIXME");
        }
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.checkKeys = Main.pref.getBoolean(PREF_CHECK_KEYS, true);
        if (this.isBeforeUpload) {
            this.checkKeys = this.checkKeys && Main.pref.getBoolean(PREF_CHECK_KEYS_BEFORE_UPLOAD, true);
        }
        this.checkValues = Main.pref.getBoolean(PREF_CHECK_VALUES, true);
        if (this.isBeforeUpload) {
            this.checkValues = this.checkValues && Main.pref.getBoolean(PREF_CHECK_VALUES_BEFORE_UPLOAD, true);
        }
        this.checkComplex = Main.pref.getBoolean(PREF_CHECK_COMPLEX, true);
        if (this.isBeforeUpload) {
            this.checkComplex = this.checkValues && Main.pref.getBoolean(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, true);
        }
        this.checkFixmes = Main.pref.getBoolean(PREF_CHECK_FIXMES, true);
        if (this.isBeforeUpload) {
            this.checkFixmes = this.checkFixmes && Main.pref.getBoolean(PREF_CHECK_FIXMES_BEFORE_UPLOAD, true);
        }
        this.checkPaint = Main.pref.getBoolean(PREF_CHECK_PAINT, true);
        if (this.isBeforeUpload) {
            this.checkPaint = this.checkPaint && Main.pref.getBoolean(PREF_CHECK_PAINT_BEFORE_UPLOAD, true);
        }
    }

    @Override
    public void visit(Collection<OsmPrimitive> selection) {
        if (this.checkKeys || this.checkValues || this.checkComplex) {
            super.visit(selection);
        }
    }

    @Override
    public void addGui(JPanel testPanel) {
        GBC a = GBC.eol();
        a.anchor = 13;
        testPanel.add((Component)new JLabel(this.name), GBC.eol().insets(3, 0, 0, 0));
        this.prefCheckKeys = new JCheckBox(I18n.tr((String)"Check property keys."), Main.pref.getBoolean(PREF_CHECK_KEYS, true));
        this.prefCheckKeys.setToolTipText(I18n.tr((String)"Validate that property keys are valid checking against list of words."));
        testPanel.add((Component)this.prefCheckKeys, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckKeysBeforeUpload = new JCheckBox();
        this.prefCheckKeysBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_KEYS_BEFORE_UPLOAD, true));
        testPanel.add((Component)this.prefCheckKeysBeforeUpload, a);
        this.prefCheckComplex = new JCheckBox(I18n.tr((String)"Use complex property checker."), Main.pref.getBoolean(PREF_CHECK_COMPLEX, true));
        this.prefCheckComplex.setToolTipText(I18n.tr((String)"Validate property values and tags using complex rules."));
        testPanel.add((Component)this.prefCheckComplex, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckComplexBeforeUpload = new JCheckBox();
        this.prefCheckComplexBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, true));
        testPanel.add((Component)this.prefCheckComplexBeforeUpload, a);
        this.Sources = new JList(new DefaultListModel());
        String sources = Main.pref.get(PREF_SOURCES);
        if (sources != null && sources.length() > 0) {
            for (String source : sources.split(";")) {
                ((DefaultListModel)this.Sources.getModel()).addElement(source);
            }
        }
        this.addSrcButton = new JButton(I18n.tr((String)"Add"));
        this.addSrcButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String source = JOptionPane.showInputDialog(Main.parent, I18n.tr((String)"TagChecker source"), I18n.tr((String)"TagChecker source"), 3);
                if (source != null) {
                    ((DefaultListModel)TagChecker.this.Sources.getModel()).addElement(source);
                }
                TagChecker.this.Sources.clearSelection();
            }
        });
        this.editSrcButton = new JButton(I18n.tr((String)"Edit"));
        this.editSrcButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = TagChecker.this.Sources.getSelectedIndex();
                if (row == -1 && TagChecker.this.Sources.getModel().getSize() == 1) {
                    TagChecker.this.Sources.setSelectedIndex(0);
                    row = 0;
                }
                if (row == -1) {
                    if (TagChecker.this.Sources.getModel().getSize() == 0) {
                        String source = JOptionPane.showInputDialog(Main.parent, I18n.tr((String)"TagChecker source"), I18n.tr((String)"TagChecker source"), 3);
                        if (source != null) {
                            ((DefaultListModel)TagChecker.this.Sources.getModel()).addElement(source);
                        }
                    } else {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select the row to edit."), I18n.tr((String)"Information"), 1);
                    }
                } else {
                    String source = (String)JOptionPane.showInputDialog(Main.parent, I18n.tr((String)"TagChecker source"), I18n.tr((String)"TagChecker source"), 3, null, null, TagChecker.this.Sources.getSelectedValue());
                    if (source != null) {
                        ((DefaultListModel)TagChecker.this.Sources.getModel()).setElementAt(source, row);
                    }
                }
                TagChecker.this.Sources.clearSelection();
            }
        });
        this.deleteSrcButton = new JButton(I18n.tr((String)"Delete"));
        this.deleteSrcButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (TagChecker.this.Sources.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select the row to delete."), I18n.tr((String)"Information"), 3);
                } else {
                    ((DefaultListModel)TagChecker.this.Sources.getModel()).remove(TagChecker.this.Sources.getSelectedIndex());
                }
            }
        });
        this.Sources.setMinimumSize(new Dimension(300, 50));
        this.Sources.setVisibleRowCount(3);
        this.Sources.setToolTipText(I18n.tr((String)"The sources (URL or filename) of spell check (see http://wiki.openstreetmap.org/index.php/User:JLS/speller) or tag checking data files."));
        this.addSrcButton.setToolTipText(I18n.tr((String)"Add a new source to the list."));
        this.editSrcButton.setToolTipText(I18n.tr((String)"Edit the selected source."));
        this.deleteSrcButton.setToolTipText(I18n.tr((String)"Delete the selected source from the list."));
        testPanel.add((Component)new JLabel(I18n.tr((String)"Data sources")), GBC.eol().insets(23, 0, 0, 0));
        testPanel.add((Component)new JScrollPane(this.Sources), GBC.eol().insets(23, 0, 0, 0).fill(2));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        testPanel.add((Component)buttonPanel, GBC.eol().fill(2));
        buttonPanel.add((Component)this.addSrcButton, GBC.std().insets(0, 5, 0, 0));
        buttonPanel.add((Component)this.editSrcButton, GBC.std().insets(5, 5, 5, 0));
        buttonPanel.add((Component)this.deleteSrcButton, GBC.std().insets(0, 5, 0, 0));
        ActionListener disableCheckActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TagChecker.this.handlePrefEnable();
            }
        };
        this.prefCheckKeys.addActionListener(disableCheckActionListener);
        this.prefCheckKeysBeforeUpload.addActionListener(disableCheckActionListener);
        this.prefCheckComplex.addActionListener(disableCheckActionListener);
        this.prefCheckComplexBeforeUpload.addActionListener(disableCheckActionListener);
        this.handlePrefEnable();
        this.prefCheckValues = new JCheckBox(I18n.tr((String)"Check property values."), Main.pref.getBoolean(PREF_CHECK_VALUES, true));
        this.prefCheckValues.setToolTipText(I18n.tr((String)"Validate that property values are valid checking against presets."));
        testPanel.add((Component)this.prefCheckValues, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckValuesBeforeUpload = new JCheckBox();
        this.prefCheckValuesBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_VALUES_BEFORE_UPLOAD, true));
        testPanel.add((Component)this.prefCheckValuesBeforeUpload, a);
        this.prefCheckFixmes = new JCheckBox(I18n.tr((String)"Check for FIXMES."), Main.pref.getBoolean(PREF_CHECK_FIXMES, true));
        this.prefCheckFixmes.setToolTipText(I18n.tr((String)"Looks for nodes or ways with FIXME in any property value."));
        testPanel.add((Component)this.prefCheckFixmes, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckFixmesBeforeUpload = new JCheckBox();
        this.prefCheckFixmesBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_FIXMES_BEFORE_UPLOAD, true));
        testPanel.add((Component)this.prefCheckFixmesBeforeUpload, a);
        this.prefCheckPaint = new JCheckBox(I18n.tr((String)"Check for paint notes."), Main.pref.getBoolean(PREF_CHECK_PAINT, true));
        this.prefCheckPaint.setToolTipText(I18n.tr((String)"Check if map painting found data errors."));
        testPanel.add((Component)this.prefCheckPaint, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckPaintBeforeUpload = new JCheckBox();
        this.prefCheckPaintBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_PAINT_BEFORE_UPLOAD, true));
        testPanel.add((Component)this.prefCheckPaintBeforeUpload, a);
        this.prefUseDataFile = new JCheckBox(I18n.tr((String)"Use default data file."), Main.pref.getBoolean(PREF_USE_DATA_FILE, true));
        this.prefUseDataFile.setToolTipText(I18n.tr((String)"Use the default data file (recommended)."));
        testPanel.add((Component)this.prefUseDataFile, GBC.eol().insets(20, 0, 0, 0));
        this.prefUseIgnoreFile = new JCheckBox(I18n.tr((String)"Use default tag ignore file."), Main.pref.getBoolean(PREF_USE_IGNORE_FILE, true));
        this.prefUseIgnoreFile.setToolTipText(I18n.tr((String)"Use the default tag ignore file (recommended)."));
        testPanel.add((Component)this.prefUseIgnoreFile, GBC.eol().insets(20, 0, 0, 0));
        this.prefUseSpellFile = new JCheckBox(I18n.tr((String)"Use default spellcheck file."), Main.pref.getBoolean(PREF_USE_SPELL_FILE, true));
        this.prefUseSpellFile.setToolTipText(I18n.tr((String)"Use the default spellcheck file (recommended)."));
        testPanel.add((Component)this.prefUseSpellFile, GBC.eol().insets(20, 0, 0, 0));
    }

    public void handlePrefEnable() {
        boolean selected = this.prefCheckKeys.isSelected() || this.prefCheckKeysBeforeUpload.isSelected() || this.prefCheckComplex.isSelected() || this.prefCheckComplexBeforeUpload.isSelected();
        this.Sources.setEnabled(selected);
        this.addSrcButton.setEnabled(selected);
        this.editSrcButton.setEnabled(selected);
        this.deleteSrcButton.setEnabled(selected);
    }

    @Override
    public boolean ok() {
        this.enabled = this.prefCheckKeys.isSelected() || this.prefCheckValues.isSelected() || this.prefCheckComplex.isSelected() || this.prefCheckFixmes.isSelected();
        this.testBeforeUpload = this.prefCheckKeysBeforeUpload.isSelected() || this.prefCheckValuesBeforeUpload.isSelected() || this.prefCheckFixmesBeforeUpload.isSelected() || this.prefCheckComplexBeforeUpload.isSelected();
        Main.pref.put(PREF_CHECK_VALUES, this.prefCheckValues.isSelected());
        Main.pref.put(PREF_CHECK_COMPLEX, this.prefCheckComplex.isSelected());
        Main.pref.put(PREF_CHECK_KEYS, this.prefCheckKeys.isSelected());
        Main.pref.put(PREF_CHECK_FIXMES, this.prefCheckFixmes.isSelected());
        Main.pref.put(PREF_CHECK_PAINT, this.prefCheckPaint.isSelected());
        Main.pref.put(PREF_CHECK_VALUES_BEFORE_UPLOAD, this.prefCheckValuesBeforeUpload.isSelected());
        Main.pref.put(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, this.prefCheckComplexBeforeUpload.isSelected());
        Main.pref.put(PREF_CHECK_KEYS_BEFORE_UPLOAD, this.prefCheckKeysBeforeUpload.isSelected());
        Main.pref.put(PREF_CHECK_FIXMES_BEFORE_UPLOAD, this.prefCheckFixmesBeforeUpload.isSelected());
        Main.pref.put(PREF_CHECK_PAINT_BEFORE_UPLOAD, this.prefCheckPaintBeforeUpload.isSelected());
        Main.pref.put(PREF_USE_DATA_FILE, this.prefUseDataFile.isSelected());
        Main.pref.put(PREF_USE_IGNORE_FILE, this.prefUseIgnoreFile.isSelected());
        Main.pref.put(PREF_USE_SPELL_FILE, this.prefUseSpellFile.isSelected());
        String sources = "";
        if (this.Sources.getModel().getSize() > 0) {
            String sb = "";
            for (int i = 0; i < this.Sources.getModel().getSize(); ++i) {
                sb = sb + ";" + this.Sources.getModel().getElementAt(i);
            }
            sources = sb.substring(1);
        }
        if (sources.length() == 0) {
            sources = null;
        }
        return Main.pref.put(PREF_SOURCES, sources);
    }

    @Override
    public Command fixError(TestError testError) {
        ArrayList<Object> commands = new ArrayList<Object>(50);
        int i = -1;
        List<? extends OsmPrimitive> primitives = testError.getPrimitives();
        for (OsmPrimitive osmPrimitive : primitives) {
            ++i;
            Map tags = osmPrimitive.getKeys();
            if (tags == null || tags.size() == 0) continue;
            for (Map.Entry prop : tags.entrySet()) {
                String key = (String)prop.getKey();
                String value = (String)prop.getValue();
                if (value == null || value.trim().length() == 0) {
                    commands.add(new ChangePropertyCommand(Collections.singleton(primitives.get(i)), key, null));
                    continue;
                }
                if (value.startsWith(" ") || value.endsWith(" ")) {
                    commands.add(new ChangePropertyCommand(Collections.singleton(primitives.get(i)), key, value.trim()));
                    continue;
                }
                if (key.startsWith(" ") || key.endsWith(" ")) {
                    commands.add((Object)new ChangePropertyKeyCommand(Collections.singleton(primitives.get(i)), key, key.trim()));
                    continue;
                }
                String evalue = entities.unescape(value);
                if (!evalue.equals(value)) {
                    commands.add(new ChangePropertyCommand(Collections.singleton(primitives.get(i)), key, evalue));
                    continue;
                }
                String replacementKey = spellCheckKeyData.get(key);
                if (replacementKey == null) continue;
                commands.add((Object)new ChangePropertyKeyCommand(Collections.singleton(primitives.get(i)), key, replacementKey));
            }
        }
        if (commands.size() == 0) {
            return null;
        }
        if (commands.size() == 1) {
            return (Command)commands.get(0);
        }
        return new SequenceCommand(I18n.tr((String)"Fix properties"), commands);
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof TagChecker) {
            int code = testError.getCode();
            return code == INVALID_KEY || code == EMPTY_VALUES || code == INVALID_SPACE || code == INVALID_KEY_SPACE || code == INVALID_HTML;
        }
        return false;
    }

    static {
        checkerData = new ArrayList<CheckerData>();
        ignoreDataStartsWith = new ArrayList();
        ignoreDataEquals = new ArrayList();
        ignoreDataEndsWith = new ArrayList();
        ignoreDataKeyPair = new ArrayList();
        ignoreDataTwoKeyPair = new ArrayList();
        PREFIX = "validator." + TagChecker.class.getSimpleName();
        PREF_CHECK_VALUES = PREFIX + ".checkValues";
        PREF_CHECK_KEYS = PREFIX + ".checkKeys";
        PREF_CHECK_COMPLEX = PREFIX + ".checkComplex";
        PREF_CHECK_FIXMES = PREFIX + ".checkFixmes";
        PREF_CHECK_PAINT = PREFIX + ".paint";
        PREF_SOURCES = PREFIX + ".sources";
        PREF_USE_DATA_FILE = PREFIX + ".usedatafile";
        PREF_USE_IGNORE_FILE = PREFIX + ".useignorefile";
        PREF_USE_SPELL_FILE = PREFIX + ".usespellfile";
        PREF_CHECK_KEYS_BEFORE_UPLOAD = PREF_CHECK_KEYS + "BeforeUpload";
        PREF_CHECK_VALUES_BEFORE_UPLOAD = PREF_CHECK_VALUES + "BeforeUpload";
        PREF_CHECK_COMPLEX_BEFORE_UPLOAD = PREF_CHECK_COMPLEX + "BeforeUpload";
        PREF_CHECK_FIXMES_BEFORE_UPLOAD = PREF_CHECK_FIXMES + "BeforeUpload";
        PREF_CHECK_PAINT_BEFORE_UPLOAD = PREF_CHECK_PAINT + "BeforeUpload";
        EMPTY_VALUES = 1200;
        INVALID_KEY = 1201;
        INVALID_VALUE = 1202;
        FIXME = 1203;
        INVALID_SPACE = 1204;
        INVALID_KEY_SPACE = 1205;
        INVALID_HTML = 1206;
        PAINT = 1207;
        entities = new Entities();
    }

    private static class CheckerData {
        private String description;
        private List<CheckerElement> data = new ArrayList<CheckerElement>();
        private Integer type = 0;
        private Integer code;
        protected Severity severity;
        protected static int NODE = 1;
        protected static int WAY = 2;
        protected static int RELATION = 3;
        protected static int ALL = 4;
        protected static int TAG_CHECK_ERROR = 1250;
        protected static int TAG_CHECK_WARN = 1260;
        protected static int TAG_CHECK_INFO = 1270;

        private CheckerData() {
        }

        public String getData(String str) {
            Matcher m = Pattern.compile(" *# *([^#]+) *$").matcher(str);
            str = m.replaceFirst("").trim();
            try {
                this.description = m.group(1);
                if (this.description != null && this.description.length() == 0) {
                    this.description = null;
                }
            }
            catch (IllegalStateException e) {
                this.description = null;
            }
            String[] n = str.split(" *: *", 3);
            if (n[0].equals("way")) {
                this.type = WAY;
            } else if (n[0].equals("node")) {
                this.type = NODE;
            } else if (n[0].equals("relation")) {
                this.type = RELATION;
            } else if (n[0].equals("*")) {
                this.type = ALL;
            }
            if (this.type == 0 || n.length != 3) {
                return I18n.tr((String)"Could not find element type");
            }
            if (n[1].equals("W")) {
                this.severity = Severity.WARNING;
                this.code = TAG_CHECK_WARN;
            } else if (n[1].equals("E")) {
                this.severity = Severity.ERROR;
                this.code = TAG_CHECK_ERROR;
            } else if (n[1].equals("I")) {
                this.severity = Severity.OTHER;
                this.code = TAG_CHECK_INFO;
            } else {
                return I18n.tr((String)"Could not find warning level");
            }
            for (String exp : n[2].split(" *&& *")) {
                try {
                    this.data.add(new CheckerElement(exp));
                }
                catch (IllegalStateException e) {
                    return I18n.tr((String)"Illegal expression ''{0}''", (Object[])new Object[]{exp});
                }
                catch (PatternSyntaxException e) {
                    return I18n.tr((String)"Illegal regular expression ''{0}''", (Object[])new Object[]{exp});
                }
            }
            return null;
        }

        public Boolean match(OsmPrimitive osm) {
            if (osm.getKeys() == null || this.type == NODE && !(osm instanceof Node) || this.type == RELATION && !(osm instanceof Relation) || this.type == WAY && !(osm instanceof Way)) {
                return false;
            }
            for (CheckerElement ce : this.data) {
                if (ce.match(osm).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public String getDescription() {
            return I18n.tr((String)this.description);
        }

        public String getDescriptionOrig() {
            return this.description;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public int getCode() {
            return this.code + this.type;
        }

        private class CheckerElement {
            public Object tag;
            public Object value;
            public Boolean noMatch;
            public Boolean tagAll = false;
            public Boolean valueAll = false;
            public Boolean valueBool = false;

            private Pattern getPattern(String str) throws IllegalStateException, PatternSyntaxException {
                if (str.endsWith("/i")) {
                    return Pattern.compile(str.substring(1, str.length() - 2), 2);
                }
                if (str.endsWith("/")) {
                    return Pattern.compile(str.substring(1, str.length() - 1));
                }
                throw new IllegalStateException();
            }

            public CheckerElement(String exp) throws IllegalStateException, PatternSyntaxException {
                Matcher m = Pattern.compile("(.+)([!=]=)(.+)").matcher(exp);
                m.matches();
                String n = m.group(1).trim();
                if (n.equals("*")) {
                    this.tagAll = true;
                } else {
                    this.tag = n.startsWith("/") ? this.getPattern(n) : n;
                }
                this.noMatch = m.group(2).equals("!=");
                n = m.group(3).trim();
                if (n.equals("*")) {
                    this.valueAll = true;
                } else if (n.equals("BOOLEAN_TRUE")) {
                    this.valueBool = true;
                    this.value = "yes";
                } else if (n.equals("BOOLEAN_FALSE")) {
                    this.valueBool = true;
                    this.value = "no";
                } else {
                    this.value = n.startsWith("/") ? this.getPattern(n) : n;
                }
            }

            public Boolean match(OsmPrimitive osm) {
                for (Map.Entry prop : osm.getKeys().entrySet()) {
                    String val;
                    String key = (String)prop.getKey();
                    String string = val = this.valueBool != false ? OsmUtils.getNamedOsmBoolean((String)((String)prop.getValue())) : (String)prop.getValue();
                    if (!this.tagAll.booleanValue() && !(this.tag instanceof Pattern ? ((Pattern)this.tag).matcher(key).matches() : key.equals(this.tag)) || !this.valueAll.booleanValue() && !(this.value instanceof Pattern ? ((Pattern)this.value).matcher(val).matches() : val.equals(this.value))) continue;
                    return this.noMatch == false;
                }
                return this.noMatch;
            }
        }
    }

    private static class IgnoreKeyPair {
        public String key;
        public String value;

        private IgnoreKeyPair() {
        }
    }

    private static class IgnoreTwoKeyPair {
        public String key1;
        public String value1;
        public String key2;
        public String value2;

        private IgnoreTwoKeyPair() {
        }
    }
}

