/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osmarender;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.CollectBackReferencesVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class OsmarenderPlugin
extends Plugin {
    private JMenuItem osmarenderMenu;

    public OsmarenderPlugin() throws IOException {
        this.osmarenderMenu = MainMenu.add((JMenu)Main.main.menu.viewMenu, (JosmAction)new Action());
        this.osmarenderMenu.setVisible(false);
        this.copy("/osmarender.xsl", "osmarender.xsl");
        this.copy("/osm-map-features.xml", "osm-map-features.xml");
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame != null && newFrame == null) {
            this.osmarenderMenu.setVisible(false);
        } else if (oldFrame == null && newFrame != null) {
            this.osmarenderMenu.setVisible(true);
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new PreferenceSetting(){
            private JTextField firefox = new JTextField(10);

            public void addGui(PreferenceDialog gui) {
                gui.map.add((Component)new JLabel(I18n.tr((String)"osmarender options")), GBC.eol().insets(0, 5, 0, 0));
                gui.map.add((Component)new JLabel(I18n.tr((String)"Firefox executable")), GBC.std().insets(10, 5, 5, 0));
                gui.map.add((Component)this.firefox, GBC.eol().insets(0, 5, 0, 0).fill(2));
                this.firefox.setText(Main.pref.get("osmarender.firefox"));
            }

            public boolean ok() {
                Main.pref.put("osmarender.firefox", this.firefox.getText());
                return false;
            }
        };
    }

    private void writeGenerated(Bounds b) throws IOException {
        String bounds_tag = "<bounds minlat=\"" + b.min.lat() + "\" " + "maxlat=\"" + b.max.lat() + "\" " + "minlon=\"" + b.min.lon() + "\" " + "maxlon=\"" + b.max.lon() + "\" " + "/>";
        BufferedReader reader = new BufferedReader(new FileReader(this.getPluginDir() + File.separator + "osm-map-features.xml"));
        PrintWriter writer = new PrintWriter(this.getPluginDir() + File.separator + "generated.xml");
        String str = null;
        while ((str = reader.readLine()) != null) {
            if (str.contains("<!--bounds_mkr1-->")) {
                writer.println(str);
                writer.println("    " + bounds_tag);
                while (!str.contains("<!--bounds_mkr2-->")) {
                    str = reader.readLine();
                }
                writer.println(str);
                continue;
            }
            writer.println(str);
        }
        writer.close();
    }

    private class Action
    extends JosmAction {
        public Action() {
            super(I18n.tr((String)"Osmarender"), null, I18n.tr((String)"Osmarender"), null, true);
        }

        public void actionPerformed(ActionEvent e) {
            LatLon bottomLeft = Main.map.mapView.getLatLon(0, Main.map.mapView.getHeight());
            LatLon topRight = Main.map.mapView.getLatLon(Main.map.mapView.getWidth(), 0);
            Bounds b = new Bounds(bottomLeft, topRight);
            try {
                OsmarenderPlugin.this.writeGenerated(b);
            }
            catch (Exception ex) {
                // empty catch block
            }
            CollectBackReferencesVisitor backRefsV = new CollectBackReferencesVisitor(Main.main.getCurrentDataSet(), true);
            DataSet fromDataSet = new DataSet();
            for (Node n : Main.main.getCurrentDataSet().nodes) {
                if (!n.isUsable() || !n.getCoor().isWithin(b)) continue;
                fromDataSet.nodes.add((OsmPrimitive)n);
                n.visit((Visitor)backRefsV);
            }
            for (OsmPrimitive p : new HashSet(backRefsV.getData())) {
                if (!(p instanceof Way)) continue;
                for (Node n : ((Way)p).getNodes()) {
                    if (!n.getCoor().isWithin(b)) continue;
                    backRefsV.getData().add(n);
                }
            }
            for (OsmPrimitive p : backRefsV.getData()) {
                fromDataSet.addPrimitive(p);
            }
            String firefox = Main.pref.get("osmarender.firefox", "firefox");
            try {
                OsmWriter w = new OsmWriter(new PrintWriter(new FileOutputStream(OsmarenderPlugin.this.getPluginDir() + File.separator + "data.osm")), false, fromDataSet.version);
                w.header();
                w.writeDataSources(fromDataSet);
                w.writeContent(fromDataSet);
                w.footer();
                w.close();
                String exec = firefox;
                exec = System.getProperty("os.name").startsWith("Windows") ? exec + " file:///" + OsmarenderPlugin.this.getPluginDir().replace('\\', '/').replace(" ", "%20") + File.separator + "generated.xml\"" : exec + " " + OsmarenderPlugin.this.getPluginDir() + File.separator + "generated.xml";
                Runtime.getRuntime().exec(exec);
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Firefox not found. Please set firefox executable in the Map Settings page of the preferences."));
            }
        }
    }
}

