/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.remotecontrol;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestProcessor
extends Thread {
    private Socket request;

    public RequestProcessor(Socket request) {
        super("RemoteControl request processor");
        this.setDaemon(true);
        this.request = request;
    }

    public static void processRequest(Socket request) {
        RequestProcessor processor = new RequestProcessor(request);
        processor.start();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block38: {
            out = null;
            raw = new BufferedOutputStream(this.request.getOutputStream());
            out = new OutputStreamWriter(raw);
            in = new InputStreamReader((InputStream)new BufferedInputStream(this.request.getInputStream()), "ASCII");
            requestLine = new StringBuffer();
            while (requestLine.length() < 1024) {
                c = in.read();
                if (c == 13 || c == 10) break;
                requestLine.append((char)c);
            }
            System.out.println("RemoteControl received: " + requestLine);
            get = requestLine.toString();
            st = new StringTokenizer(get);
            if (st.hasMoreTokens()) break block38;
            this.sendError(out);
lbl18:
            // 11 sources

            while (true) {
                try {
                    this.request.close();
                }
                catch (IOException v0) {}
                return;
            }
        }
        try {
            block45: {
                block50: {
                    block49: {
                        block46: {
                            block48: {
                                block47: {
                                    block42: {
                                        block44: {
                                            block43: {
                                                block41: {
                                                    block40: {
                                                        method = st.nextToken();
                                                        if (st.hasMoreTokens()) break block40;
                                                        this.sendError(out);
                                                        ** GOTO lbl18
                                                    }
                                                    url = st.nextToken();
                                                    if (method.equals("GET")) break block41;
                                                    this.sendNotImplemented(out);
                                                    ** GOTO lbl18
                                                }
                                                st = new StringTokenizer(url, "&?");
                                                command = null;
                                                args = new HashMap<String, String>();
                                                while (st.hasMoreTokens()) {
                                                    param = st.nextToken();
                                                    if (command == null) {
                                                        command = param;
                                                        continue;
                                                    }
                                                    eq = param.indexOf("=");
                                                    if (eq <= -1) continue;
                                                    args.put(param.substring(0, eq), param.substring(eq + 1));
                                                }
                                                if (!command.equals("/load_and_zoom")) break block42;
                                                if (!Main.pref.getBoolean("remotecontrol.always-confirm", false) || JOptionPane.showConfirmDialog(Main.parent, "<html>" + I18n.tr((String)"Remote Control has been asked to load data from the API.") + "<br>" + I18n.tr((String)"Request details: {0}", (Object[])new Object[]{url}) + "<br>" + I18n.tr((String)"Do you want to allow this?"), I18n.tr((String)"Confirm Remote Control action"), 0) == 0) break block43;
                                                this.sendForbidden(out);
                                                ** GOTO lbl18
                                            }
                                            osmTask = new DownloadOsmTask();
                                            if (args.containsKey("bottom") && args.containsKey("top") && args.containsKey("left") && args.containsKey("right")) break block44;
                                            this.sendBadRequest(out);
                                            System.out.println("load_and_zoom remote control request must have bottom,top,left,right parameters");
                                            ** GOTO lbl18
                                        }
                                        minlat = 0.0;
                                        maxlat = 0.0;
                                        minlon = 0.0;
                                        maxlon = 0.0;
                                        try {
                                            minlat = Double.parseDouble(args.get("bottom"));
                                            maxlat = Double.parseDouble(args.get("top"));
                                            minlon = Double.parseDouble(args.get("left"));
                                            maxlon = Double.parseDouble(args.get("right"));
                                            if (!Main.pref.getBoolean("remotecontrol.permission.load-data", true)) {
                                                throw new LoadDeniedException();
                                            }
                                            present = null;
                                            ds = Main.main.getCurrentDataSet();
                                            if (ds != null) {
                                                present = ds.getDataSourceArea();
                                            }
                                            if (present != null && !present.isEmpty()) {
                                                toDownload = new Area(new Rectangle2D.Double(minlon, minlat, maxlon - minlon, maxlat - minlat));
                                                toDownload.subtract(present);
                                                if (toDownload.isEmpty()) {
                                                    throw new AlreadyLoadedException();
                                                }
                                                downloadBounds = toDownload.getBounds2D();
                                                minlat = downloadBounds.getMinY();
                                                minlon = downloadBounds.getMinX();
                                                maxlat = downloadBounds.getMaxY();
                                                maxlon = downloadBounds.getMaxX();
                                            }
                                            osmTask.download(null, minlat, minlon, maxlat, maxlon, (ProgressMonitor)new PleaseWaitProgressMonitor());
                                        }
                                        catch (AlreadyLoadedException v1) {
                                            System.out.println("RemoteControl: no download necessary");
                                        }
                                        catch (LoadDeniedException v2) {
                                            System.out.println("RemoteControl: download forbidden by preferences");
                                        }
                                        catch (Exception ex) {
                                            this.sendError(out);
                                            System.out.println("RemoteControl: Error parsing load_and_zoom remote control request:");
                                            ex.printStackTrace();
                                            ** GOTO lbl18
                                        }
                                        if (args.containsKey("select") && Main.pref.getBoolean("remotecontrol.permission.change-selection", true)) {
                                            selection = args.get("select");
                                            Main.worker.execute(new Runnable(){

                                                public void run() {
                                                    HashSet<Long> ways = new HashSet<Long>();
                                                    HashSet<Long> nodes = new HashSet<Long>();
                                                    HashSet<Long> relations = new HashSet<Long>();
                                                    HashSet<Object> newSel = new HashSet<Object>();
                                                    String[] stringArray = selection.split(",");
                                                    int n = stringArray.length;
                                                    int n2 = 0;
                                                    while (n2 < n) {
                                                        String item = stringArray[n2];
                                                        if (item.startsWith("way")) {
                                                            ways.add(Long.parseLong(item.substring(3)));
                                                        } else if (item.startsWith("node")) {
                                                            nodes.add(Long.parseLong(item.substring(4)));
                                                        } else if (item.startsWith("relation")) {
                                                            relations.add(Long.parseLong(item.substring(8)));
                                                        } else {
                                                            System.out.println("RemoteControl: invalid selection '" + item + "' ignored");
                                                        }
                                                        ++n2;
                                                    }
                                                    for (Way w : Main.main.getCurrentDataSet().ways) {
                                                        if (!ways.contains(w.getId())) continue;
                                                        newSel.add(w);
                                                    }
                                                    for (Node n3 : Main.main.getCurrentDataSet().nodes) {
                                                        if (!nodes.contains(n3.getId())) continue;
                                                        newSel.add(n3);
                                                    }
                                                    for (Relation r : Main.main.getCurrentDataSet().relations) {
                                                        if (!relations.contains(r.getId())) continue;
                                                        newSel.add(r);
                                                    }
                                                    Main.main.getCurrentDataSet().setSelected(newSel);
                                                    if (Main.pref.getBoolean("remotecontrol.permission.change-viewport", true)) {
                                                        new AutoScaleAction("selection").actionPerformed(null);
                                                    }
                                                }
                                            });
                                        } else if (Main.pref.getBoolean("remotecontrol.permission.change-viewport", true)) {
                                            bounds = new Bounds(new LatLon(minlat, minlon), new LatLon(maxlat, maxlon));
                                            Main.worker.execute(new Runnable(){

                                                public void run() {
                                                    BoundingXYVisitor bbox = new BoundingXYVisitor();
                                                    bbox.visit(bounds);
                                                    Main.map.mapView.recalculateCenterScale(bbox);
                                                }
                                            });
                                        }
                                        break block45;
                                    }
                                    if (!command.equals("/add_node")) break block46;
                                    if (Main.pref.getBoolean("remotecontrol.permission.create-objects", true)) break block47;
                                    this.sendForbidden(out);
                                    ** GOTO lbl18
                                }
                                if (!Main.pref.getBoolean("remotecontrol.always-confirm", false) || JOptionPane.showConfirmDialog(Main.parent, "<html>" + I18n.tr((String)"Remote Control has been asked to create a new node.") + "<br>" + I18n.tr((String)"Do you want to allow this?"), I18n.tr((String)"Confirm Remote Control action"), 0) == 0) break block48;
                                this.sendForbidden(out);
                                ** GOTO lbl18
                            }
                            this.addNode(args, out);
                            break block45;
                        }
                        if (!command.equals("/import")) break block45;
                        if (!Main.pref.getBoolean("remotecontrol.always-confirm", false) || JOptionPane.showConfirmDialog(Main.parent, "<html>" + I18n.tr((String)"Remote Control has been asked to import data from the following URL:") + "<br>" + url + "<br>" + I18n.tr((String)"Do you want to allow this?"), I18n.tr((String)"Confirm Remote Control action"), 0) == 0) break block49;
                        this.sendForbidden(out);
                        ** GOTO lbl18
                    }
                    if (args.containsKey("url")) break block50;
                    this.sendBadRequest(out);
                    System.out.println("'import' remote control request must have url parameter");
                    ** GOTO lbl18
                }
                try {
                    if (!Main.pref.getBoolean("remotecontrol.permission.import", true)) {
                        throw new LoadDeniedException();
                    }
                    osmTask = new DownloadOsmTask();
                    osmTask.loadUrl(false, URLDecoder.decode(args.get("url"), "UTF-8"), null);
                }
                catch (LoadDeniedException v3) {
                    System.out.println("RemoteControl: import forbidden by preferences");
                }
                catch (Exception ex) {
                    this.sendError(out);
                    System.out.println("RemoteControl: Error parsing import remote control request:");
                    ex.printStackTrace();
                    ** continue;
                }
            }
            this.sendHeader(out, "200 OK", "text/plain", false);
            out.write("Content-length: 4\r\n");
            out.write("\r\n");
            out.write("OK\r\n");
            out.flush();
        }
        catch (IOException v4) {
            try {
                this.request.close();
            }
            catch (IOException v5) {}
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                try {
                    this.sendError(out);
                }
                catch (IOException v6) {}
            }
            catch (Throwable var24_25) {
                try {
                    this.request.close();
                }
                catch (IOException v7) {}
                throw var24_25;
            }
            try {
                this.request.close();
            }
            catch (IOException v8) {}
        }
        try {
            this.request.close();
        }
        catch (IOException v9) {}
    }

    private void addNode(HashMap<String, String> args, Writer out) throws IOException {
        if (!args.containsKey("lat") || !args.containsKey("lon")) {
            this.sendBadRequest(out);
            return;
        }
        double lat = Double.parseDouble(args.get("lat"));
        double lon = Double.parseDouble(args.get("lon"));
        System.out.println("Adding node at (" + lat + ", " + lon + ")");
        LatLon ll = new LatLon(lat, lon);
        Node nnew = new Node(ll);
        Main.main.undoRedo.add((Command)new AddCommand((OsmPrimitive)nnew));
        Main.main.getCurrentDataSet().setSelected(new OsmPrimitive[]{nnew});
        Main.map.mapView.repaint();
    }

    private void sendError(Writer out) throws IOException {
        this.sendHeader(out, "500 Internal Server Error", "text/html", true);
        out.write("<HTML>\r\n");
        out.write("<HEAD><TITLE>Internal Error</TITLE>\r\n");
        out.write("</HEAD>\r\n");
        out.write("<BODY>");
        out.write("<H1>HTTP Error 500: Internal Server Error</h2>\r\n");
        out.write("</BODY></HTML>\r\n");
        out.flush();
    }

    private void sendNotImplemented(Writer out) throws IOException {
        this.sendHeader(out, "501 Not Implemented", "text/html", true);
        out.write("<HTML>\r\n");
        out.write("<HEAD><TITLE>Not Implemented</TITLE>\r\n");
        out.write("</HEAD>\r\n");
        out.write("<BODY>");
        out.write("<H1>HTTP Error 501: Not Implemented</h2>\r\n");
        out.write("</BODY></HTML>\r\n");
        out.flush();
    }

    private void sendForbidden(Writer out) throws IOException {
        this.sendHeader(out, "403 Forbidden", "text/html", true);
        out.write("<HTML>\r\n");
        out.write("<HEAD><TITLE>Forbidden</TITLE>\r\n");
        out.write("</HEAD>\r\n");
        out.write("<BODY>");
        out.write("<H1>HTTP Error 403: Forbidden</h2>\r\n");
        out.write("</BODY></HTML>\r\n");
        out.flush();
    }

    private void sendBadRequest(Writer out) throws IOException {
        this.sendHeader(out, "400 Bad Request", "text/html", true);
        out.write("<HTML>\r\n");
        out.write("<HEAD><TITLE>Bad Request</TITLE>\r\n");
        out.write("</HEAD>\r\n");
        out.write("<BODY>");
        out.write("<H1>HTTP Error 400: Bad Request</h2>\r\n");
        out.write("</BODY></HTML>\r\n");
        out.flush();
    }

    private void sendHeader(Writer out, String status, String contentType, boolean endHeaders) throws IOException {
        out.write("HTTP/1.1 " + status + "\r\n");
        Date now = new Date();
        out.write("Date: " + now + "\r\n");
        out.write("Server: JOSM RemoteControl\r\n");
        out.write("Content-type: " + contentType + "\r\n");
        if (endHeaders) {
            out.write("\r\n");
        }
    }

    private class AlreadyLoadedException
    extends Exception {
        private AlreadyLoadedException() {
        }
    }

    private class LoadDeniedException
    extends Exception {
        private LoadDeniedException() {
        }
    }
}

