/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.slippymap;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapKey;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapPreferences;
import org.openstreetmap.josm.tools.I18n;

public class SlippyMapTile
implements ImageObserver {
    private Image tileImage;
    private long timestamp;
    private int x;
    private int y;
    private int z;
    private String status = "pending download";
    private boolean imageDownloaded = false;
    private String metadata;

    public SlippyMapTile(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.timestamp = System.currentTimeMillis();
    }

    public String getStatus() {
        return this.status;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public URL getImageURL() {
        try {
            return new URL(SlippyMapPreferences.getMapUrl() + "/" + this.z + "/" + this.x + "/" + this.y + ".png");
        }
        catch (MalformedURLException mfu) {
            mfu.printStackTrace();
            return null;
        }
    }

    public Image loadImage() {
        URL imageURL = this.getImageURL();
        this.tileImage = Toolkit.getDefaultToolkit().createImage(imageURL);
        Toolkit.getDefaultToolkit().prepareImage(this.tileImage, -1, -1, this);
        Toolkit.getDefaultToolkit().sync();
        this.status = "being downloaded";
        return this.tileImage;
    }

    public String toString() {
        return "SlippyMapTile{zoom=" + this.z + " (" + this.x + "," + this.y + ") '" + this.status + "'}";
    }

    public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x20) != 0) {
            this.imageDownloaded = true;
            this.status = "downloaded";
            if (this.tileImage == null) {
                System.out.println("completed null'd image: " + this.toString());
            }
            this.tileImage = img;
            return false;
        }
        return true;
    }

    public Image getImageNoTimestamp() {
        return this.tileImage;
    }

    public Image getImage() {
        this.timestamp = System.currentTimeMillis();
        return this.tileImage;
    }

    public int getZoom() {
        return this.z;
    }

    public synchronized void dropImage() {
        if (this.tileImage != null) {
            this.tileImage.flush();
            this.status = "dropped";
        }
        this.tileImage = null;
        this.imageDownloaded = false;
    }

    public boolean isDownloaded() {
        return this.imageDownloaded;
    }

    public void loadMetadata() {
        try {
            URL dev = new URL("http://tah.openstreetmap.org/Tiles/info_short.php?x=" + this.x + "&y=" + this.y + "&z=" + this.z + "/layer=tile");
            URLConnection devc = dev.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(devc.getInputStream()));
            this.metadata = I18n.tr((String)in.readLine());
        }
        catch (Exception ex) {
            this.metadata = I18n.tr((String)("error loading metadata" + ex.toString()));
        }
    }

    public void requestUpdate() {
        if (this.z != 12) {
            this.metadata = I18n.tr((String)"error requesting update: not zoom-level 12");
        }
        try {
            URL dev = new URL("http://tah.openstreetmap.org/Request/create/?x=" + this.x + "&y=" + this.y + "&priority=1&src=slippymap_plugin");
            URLConnection devc = dev.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(devc.getInputStream()));
            this.timestamp = System.currentTimeMillis();
            this.metadata = I18n.tr((String)"requested: {0}", (Object[])new Object[]{I18n.tr((String)in.readLine())});
        }
        catch (Exception ex) {
            this.metadata = I18n.tr((String)"error requesting update");
        }
    }

    public long access_time() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SlippyMapTile)) {
            return false;
        }
        SlippyMapTile other = (SlippyMapTile)o;
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }

    SlippyMapKey getKey() {
        return new SlippyMapKey(this.x, this.y, this.z);
    }
}

