/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.WMSLayer;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.tools.I18n;

public class MenuActionSaveRasterAs
extends JosmAction {
    public static String name = "Export image as JPG/JGW";
    private static final long serialVersionUID = 1L;
    private WMSLayer wmsLayer;
    FiltreJpg filtreJpg = new FiltreJpg();

    public MenuActionSaveRasterAs(WMSLayer wmsLayer) {
        super(I18n.tr((String)name), "save", I18n.tr((String)"Export as JPG/JGW format (only raster images)"), null, false);
        this.wmsLayer = wmsLayer;
    }

    public void actionPerformed(ActionEvent arg0) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(this.filtreJpg);
        int returnVal = fc.showSaveDialog(Main.parent);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            if (!file.getName().endsWith(".jpg")) {
                file = new File(file.getParent(), String.valueOf(file.getName()) + ".jpg");
            }
            BufferedImage bi = this.wmsLayer.images.get((int)0).image;
            try {
                FileOutputStream flux = new FileOutputStream(file);
                BufferedOutputStream fluxBuf = new BufferedOutputStream(flux);
                JPEGImageEncoder codec = JPEGCodec.createJPEGEncoder((OutputStream)fluxBuf, (JPEGEncodeParam)JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bi));
                codec.encode(bi);
                fluxBuf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public class FiltreJpg
    extends FileFilter {
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase().endsWith(".jpg");
        }

        public String getDescription() {
            return I18n.tr((String)"JPG/JGW files (*.jpg, *.jgw)");
        }
    }
}

