/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.AddrInterpolation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.AddrInterpolation.EscapeDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UrlLabel;

public class AddrInterpolationDialog
extends ToggleDialog
implements ActionListener {
    private Way selectedStreet = null;
    private Way addrInterpolationWay = null;
    private Relation associatedStreetRelation = null;
    private ArrayList<Node> houseNumberNodes = null;
    private static String lastCity = "";
    private static String lastState = "";
    private static String lastPostCode = "";
    private static String lastCountry = "";
    private static String lastFullAddress = "";
    private EscapeDialog dialog = null;
    private JRadioButton streetNameButton = null;
    private JRadioButton streetRelationButton = null;
    private JTextField startTextField = null;
    private JTextField endTextField = null;
    private JTextField cityTextField = null;
    private JTextField stateTextField = null;
    private JTextField postCodeTextField = null;
    private JTextField countryTextField = null;
    private JTextField fullTextField = null;
    private boolean relationChanged = false;
    String[] addrInterpolationTags = new String[]{"odd", "even", "all", "alphabetic"};
    String[] addrInterpolationStrings = new String[]{I18n.tr((String)"Odd"), I18n.tr((String)"Even"), I18n.tr((String)"All"), I18n.tr((String)"Alphabetic")};
    private JComboBox addrInterpolationList = null;
    private static Pattern p = Pattern.compile("^[0-9]+$");

    public AddrInterpolationDialog(String name, String iconName, String tooltip, Shortcut shortcut, int preferredHeight) {
        super(name, iconName, tooltip, shortcut, preferredHeight);
        if (!this.FindAndSaveSelections()) {
            return;
        }
        JPanel editControlsPane = this.CreateEditControls();
        this.ShowDialog(editControlsPane, name);
    }

    private void ShowDialog(JPanel editControlsPane, String name) {
        this.dialog = new EscapeDialog((Frame)Main.parent, name, true);
        this.dialog.add(editControlsPane);
        this.dialog.setSize(new Dimension(300, 450));
        this.dialog.setLocation(new Point(100, 300));
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                if (AddrInterpolationDialog.this.addrInterpolationWay != null) {
                    AddrInterpolationDialog.this.addrInterpolationList.requestFocus();
                } else {
                    AddrInterpolationDialog.this.cityTextField.requestFocus();
                }
            }
        });
        this.dialog.setVisible(true);
        lastCity = this.cityTextField.getText();
        lastState = this.stateTextField.getText();
        lastPostCode = this.postCodeTextField.getText();
        lastCountry = this.countryTextField.getText();
        lastFullAddress = this.fullTextField.getText();
    }

    private JPanel CreateEditControls() {
        JPanel editControlsPane = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        editControlsPane.setLayout(gridbag);
        editControlsPane.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        String streetName = this.selectedStreet.get("name");
        String streetRelation = this.FindRelation();
        if (streetRelation.equals("")) {
            streetRelation = " (Create new)";
        }
        this.streetNameButton = new JRadioButton(I18n.tr((String)"Name: {0}", (Object[])new Object[]{streetName}));
        this.streetRelationButton = new JRadioButton(I18n.tr((String)"Relation: {0}", (Object[])new Object[]{streetRelation}));
        if (this.associatedStreetRelation == null) {
            this.streetNameButton.setSelected(true);
        } else {
            this.streetRelationButton.setSelected(true);
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.streetNameButton);
        group.add(this.streetRelationButton);
        JPanel radioButtonPanel = new JPanel(new BorderLayout());
        radioButtonPanel.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Associate with street using:")));
        radioButtonPanel.add((Component)this.streetNameButton, "North");
        radioButtonPanel.add((Component)this.streetRelationButton, "South");
        c.gridx = 0;
        c.gridwidth = 2;
        c.fill = 2;
        c.gridwidth = 0;
        editControlsPane.add((Component)radioButtonPanel, c);
        JLabel numberingLabel = new JLabel(I18n.tr((String)"Numbering Scheme:"));
        this.addrInterpolationList = new JComboBox<String>(this.addrInterpolationStrings);
        JLabel startLabel = new JLabel(I18n.tr((String)"Starting #:"));
        JLabel endLabel = new JLabel(I18n.tr((String)"Ending #:"));
        this.startTextField = new JTextField(10);
        this.endTextField = new JTextField(10);
        this.GetExistingMapKeys();
        JLabel[] textLabels = new JLabel[]{numberingLabel, startLabel, endLabel};
        Component[] editFields = new Component[]{this.addrInterpolationList, this.startTextField, this.endTextField};
        this.AddEditControlRows(textLabels, editFields, editControlsPane);
        if (this.addrInterpolationWay == null) {
            this.addrInterpolationList.setEnabled(false);
            this.startTextField.setEnabled(false);
            this.endTextField.setEnabled(false);
        }
        JPanel optionPanel = this.CreateOptionalFields();
        c.gridx = 0;
        c.gridwidth = 2;
        c.fill = 1;
        c.gridwidth = 0;
        editControlsPane.add((Component)optionPanel, c);
        KeyAdapter enterProcessor = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && AddrInterpolationDialog.this.ValidateAndSave()) {
                    AddrInterpolationDialog.this.dialog.dispose();
                }
            }
        };
        this.endTextField.addKeyListener(enterProcessor);
        this.cityTextField.addKeyListener(enterProcessor);
        if (this.houseNumberNodes.size() > 0) {
            JLabel houseNumberNodeNote = new JLabel(I18n.tr((String)"Will associate {0} additional house number nodes", (Object[])new Object[]{this.houseNumberNodes.size()}));
            editControlsPane.add((Component)houseNumberNodeNote, c);
        }
        editControlsPane.add((Component)new UrlLabel("http://wiki.openstreetmap.org/wiki/JOSM/Plugins/AddrInterpolation", I18n.tr((String)"More information about this feature")), c);
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        c.insets = new Insets(15, 0, 0, 0);
        c.anchor = 22;
        JButton okButton = new JButton(I18n.tr((String)"OK"), ImageProvider.get((String)"ok"));
        editControlsPane.add((Component)okButton, c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.anchor = 21;
        JButton cancelButton = new JButton(I18n.tr((String)"Cancel"), ImageProvider.get((String)"cancel"));
        editControlsPane.add((Component)cancelButton, c);
        okButton.setActionCommand("ok");
        okButton.addActionListener(this);
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(this);
        return editControlsPane;
    }

    private JPanel CreateOptionalFields() {
        JPanel editControlsPane = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        editControlsPane.setLayout(gridbag);
        editControlsPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel[] optionalTextLabels = new JLabel[]{new JLabel(I18n.tr((String)"City:")), new JLabel(I18n.tr((String)"State:")), new JLabel(I18n.tr((String)"Post Code:")), new JLabel(I18n.tr((String)"Country:")), new JLabel(I18n.tr((String)"Full Address:"))};
        this.cityTextField = new JTextField(lastCity, 100);
        this.stateTextField = new JTextField(lastState, 100);
        this.postCodeTextField = new JTextField(lastPostCode, 20);
        this.countryTextField = new JTextField(lastCountry, 2);
        this.fullTextField = new JTextField(lastFullAddress, 300);
        this.countryTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                JTextField jtextfield = (JTextField)e.getSource();
                String text = jtextfield.getText();
                int length = text.length();
                if (length == jtextfield.getColumns()) {
                    e.consume();
                } else if (length > jtextfield.getColumns()) {
                    e.consume();
                } else if (!e.isActionKey()) {
                    e.setKeyChar(Character.toUpperCase(e.getKeyChar()));
                }
            }
        });
        Component[] optionalEditFields = new Component[]{this.cityTextField, this.stateTextField, this.postCodeTextField, this.countryTextField, this.fullTextField};
        this.AddEditControlRows(optionalTextLabels, optionalEditFields, editControlsPane);
        JPanel optionPanel = new JPanel(new BorderLayout());
        Border groupBox = BorderFactory.createEtchedBorder();
        TitledBorder titleBorder = BorderFactory.createTitledBorder(groupBox, I18n.tr((String)"Optional Information:"), 1, 2);
        optionPanel.setBorder(titleBorder);
        optionPanel.add((Component)editControlsPane, "Center");
        return optionPanel;
    }

    private void GetExistingMapKeys() {
        for (Node node : this.houseNumberNodes) {
            this.CheckNodeForAddressTags(node);
        }
        if (this.addrInterpolationWay != null) {
            String currentMethod = this.addrInterpolationWay.get("addr:interpolation");
            if (currentMethod != null) {
                int currentIndex = 0;
                int i = 0;
                while (i < this.addrInterpolationTags.length) {
                    if (this.addrInterpolationTags[i].equals(currentMethod)) {
                        currentIndex = i;
                        break;
                    }
                    ++i;
                }
                this.addrInterpolationList.setSelectedIndex(currentIndex);
            }
            Node firstNode = this.addrInterpolationWay.getNode(0);
            Node lastNode = this.addrInterpolationWay.getNode(this.addrInterpolationWay.getNodesCount() - 1);
            String value = firstNode.get("addr:housenumber");
            if (value != null) {
                this.startTextField.setText(value);
            }
            if ((value = lastNode.get("addr:housenumber")) != null) {
                this.endTextField.setText(value);
            }
            this.CheckNodeForAddressTags(firstNode);
            this.CheckNodeForAddressTags(lastNode);
        }
    }

    private void CheckNodeForAddressTags(Node checkNode) {
        String value = checkNode.get("addr:city");
        if (value != null) {
            lastCity = value;
        }
        if ((value = checkNode.get("addr:state")) != null) {
            lastState = value;
        }
        if ((value = checkNode.get("addr:postcode")) != null) {
            lastPostCode = value;
        }
        if ((value = checkNode.get("addr:country")) != null) {
            lastCountry = value;
        }
        if ((value = checkNode.get("addr:full")) != null) {
            lastFullAddress = value;
        }
    }

    private String FindRelation() {
        String relationDescription = null;
        DataSet currentDataSet = Main.main.getCurrentDataSet();
        if (currentDataSet != null) {
            for (Relation relation : currentDataSet.relations) {
                String relationType = relation.get("type");
                if (relationType == null || !relationType.equals("associatedStreet")) continue;
                for (RelationMember relationMember : relation.getMembers()) {
                    Way way;
                    if (!relationMember.isWay() || (way = (Way)relationMember.getMember()) != this.selectedStreet) continue;
                    this.associatedStreetRelation = relation;
                    relationDescription = Long.toString(way.getId());
                    String streetName = "";
                    streetName = relation.getKeys().containsKey("name") ? relation.get("name") : this.selectedStreet.get("name");
                    relationDescription = String.valueOf(relationDescription) + " (" + streetName + ")";
                    return relationDescription;
                }
            }
        }
        return "";
    }

    private boolean FindAndSaveSelections() {
        boolean isValid = false;
        int namedWayCount = 0;
        int unNamedWayCount = 0;
        DataSet currentDataSet = Main.main.getCurrentDataSet();
        if (currentDataSet != null) {
            for (OsmPrimitive osm : currentDataSet.getSelectedWays()) {
                Way way = (Way)osm;
                if (way.getKeys().containsKey("name")) {
                    ++namedWayCount;
                    this.selectedStreet = way;
                    continue;
                }
                ++unNamedWayCount;
                this.addrInterpolationWay = way;
            }
            this.houseNumberNodes = new ArrayList();
            for (OsmPrimitive osm : currentDataSet.getSelectedNodes()) {
                Node node = (Node)osm;
                if (!node.getKeys().containsKey("addr:housenumber")) continue;
                this.houseNumberNodes.add(node);
            }
            if (this.addrInterpolationWay != null && this.addrInterpolationWay.getNodesCount() > 2) {
                int i = 1;
                while (i < this.addrInterpolationWay.getNodesCount() - 2) {
                    Node testNode = this.addrInterpolationWay.getNode(i);
                    if (testNode.getKeys().containsKey("addr:housenumber")) {
                        this.houseNumberNodes.add(testNode);
                    }
                    ++i;
                }
            }
        }
        if (namedWayCount != 1) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select a street to associate with address interpolation way"), I18n.tr((String)"Error"), 0);
        } else if (unNamedWayCount != 1) {
            if (this.houseNumberNodes.size() > 0) {
                isValid = true;
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select address interpolation way for this street"), I18n.tr((String)"Error"), 0);
            }
        } else {
            isValid = true;
        }
        return isValid;
    }

    private void AddEditControlRows(JLabel[] labels, Component[] editFields, Container container) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        int numLabels = labels.length;
        int i = 0;
        while (i < numLabels) {
            c.gridx = 0;
            c.gridwidth = 1;
            c.fill = 0;
            c.weightx = 0.0;
            container.add((Component)labels[i], c);
            c.gridx = 1;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            container.add(editFields[i], c);
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if ("ok".equals(e.getActionCommand())) {
            if (this.ValidateAndSave()) {
                this.dialog.dispose();
            }
        } else if ("cancel".equals(e.getActionCommand())) {
            this.dialog.dispose();
        }
    }

    private boolean isLong(String input) {
        try {
            Long.parseLong(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isEven(Long input) {
        return input % 2L == 0L;
    }

    private static boolean IsNumeric(String s) {
        return p.matcher(s).matches();
    }

    private boolean ValidateAndSave() {
        String startValueString = this.ReadTextField(this.startTextField);
        String endValueString = this.ReadTextField(this.endTextField);
        String city = this.ReadTextField(this.cityTextField);
        String state = this.ReadTextField(this.stateTextField);
        String postCode = this.ReadTextField(this.postCodeTextField);
        String country = this.ReadTextField(this.countryTextField);
        String fullAddress = this.ReadTextField(this.fullTextField);
        String selectedMethod = this.GetInterpolationMethod();
        if (this.addrInterpolationWay != null) {
            Long startAddr = 0L;
            Long endAddr = 0L;
            if (!selectedMethod.equals("alphabetic")) {
                Long[] addrArray = new Long[]{startAddr, endAddr};
                if (!this.ValidAddressNumbers(startValueString, endValueString, addrArray)) {
                    return false;
                }
                startAddr = addrArray[0];
                endAddr = addrArray[1];
            }
            String errorMessage = "";
            if (selectedMethod.equals("odd")) {
                if (this.isEven(startAddr) || this.isEven(endAddr)) {
                    errorMessage = I18n.tr((String)"Expected odd numbers for addresses");
                }
            } else if (selectedMethod.equals("even")) {
                if (!this.isEven(startAddr) || !this.isEven(endAddr)) {
                    errorMessage = I18n.tr((String)"Expected even numbers for addresses");
                }
            } else if (!selectedMethod.equals("all") && selectedMethod.equals("alphabetic")) {
                errorMessage = this.ValidateAlphaAddress(startValueString, endValueString);
            }
            if (!errorMessage.equals("")) {
                JOptionPane.showMessageDialog(Main.parent, errorMessage, I18n.tr((String)"Error"), 0);
                return false;
            }
        }
        if (country != null && country.length() != 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Country code must be 2 letters"), I18n.tr((String)"Error"), 0);
            return false;
        }
        String streetName = this.selectedStreet.get("name");
        if (this.addrInterpolationWay != null) {
            this.addrInterpolationWay.setModified(true);
            Node firstNode = this.addrInterpolationWay.getNode(0);
            Node lastNode = this.addrInterpolationWay.getNode(this.addrInterpolationWay.getNodesCount() - 1);
            this.addrInterpolationWay.put("addr:interpolation", selectedMethod);
            firstNode.put("addr:housenumber", startValueString);
            lastNode.put("addr:housenumber", endValueString);
            if (this.streetNameButton.isSelected()) {
                firstNode.put("addr:street", streetName);
                lastNode.put("addr:street", streetName);
            }
            this.houseNumberNodes.add(firstNode);
            this.houseNumberNodes.add(lastNode);
            this.addrInterpolationWay.setSelected(false);
        }
        if (this.streetRelationButton.isSelected()) {
            if (this.associatedStreetRelation == null) {
                this.CreateRelation(streetName);
                this.relationChanged = true;
            }
            if (this.addrInterpolationWay != null) {
                this.AddToRelation(this.associatedStreetRelation, (OsmPrimitive)this.addrInterpolationWay, "house");
            }
        }
        for (Node node : this.houseNumberNodes) {
            node.setModified(true);
            if (this.streetRelationButton.isSelected()) {
                this.AddToRelation(this.associatedStreetRelation, (OsmPrimitive)node, "house");
            }
            if (city != null || this.streetNameButton.isSelected()) {
                node.put("addr:street", streetName);
            }
            node.put("addr:city", city);
            node.put("addr:state", state);
            node.put("addr:postcode", postCode);
            node.put("addr:country", country);
            node.put("addr:full", fullAddress);
        }
        if (this.relationChanged) {
            this.associatedStreetRelation.setModified(true);
            Main.main.getEditLayer().fireDataChange();
        }
        Main.map.mapView.repaint();
        return true;
    }

    private void CreateRelation(String streetName) {
        this.associatedStreetRelation = new Relation();
        this.associatedStreetRelation.put("name", streetName);
        this.associatedStreetRelation.put("type", "associatedStreet");
        RelationMember newStreetMember = new RelationMember("street", (OsmPrimitive)this.selectedStreet);
        this.associatedStreetRelation.addMember(newStreetMember);
        Main.main.getCurrentDataSet().addPrimitive((OsmPrimitive)this.associatedStreetRelation);
    }

    private String ReadTextField(JTextField field) {
        String value = field.getText();
        if (value != null && (value = value.trim()).equals("")) {
            value = null;
        }
        return value;
    }

    private void AddToRelation(Relation relation, OsmPrimitive testMember, String role) {
        boolean isFound = false;
        for (RelationMember relationMember : relation.getMembers()) {
            if (testMember != relationMember.getMember()) continue;
            isFound = true;
            break;
        }
        if (!isFound) {
            RelationMember newMember = new RelationMember(role, testMember);
            this.associatedStreetRelation.addMember(newMember);
            this.relationChanged = true;
        }
    }

    private String ValidateAlphaAddress(String startValueString, String endValueString) {
        String errorMessage = "";
        if (startValueString.equals("") || endValueString.equals("")) {
            errorMessage = I18n.tr((String)"Please enter valid number for starting and ending address");
        } else {
            char startingChar = startValueString.charAt(startValueString.length() - 1);
            char endingChar = endValueString.charAt(endValueString.length() - 1);
            if (AddrInterpolationDialog.IsNumeric("" + startingChar) || AddrInterpolationDialog.IsNumeric("" + endingChar)) {
                errorMessage = I18n.tr((String)"Alphabetic address must end with a letter");
            }
            if (startingChar >= endingChar) {
                errorMessage = I18n.tr((String)"Starting address letter must be less than ending address letter");
            }
        }
        return errorMessage;
    }

    private boolean ValidAddressNumbers(String startValueString, String endValueString, Long[] addrArray) {
        String errorMessage = "";
        if (!this.isLong(startValueString)) {
            errorMessage = I18n.tr((String)"Please enter valid number for starting address");
        }
        if (!this.isLong(endValueString)) {
            errorMessage = I18n.tr((String)"Please enter valid number for ending address");
        }
        if (errorMessage.equals("")) {
            addrArray[0] = Long.parseLong(startValueString);
            addrArray[1] = Long.parseLong(endValueString);
            if (addrArray[1] <= addrArray[0]) {
                errorMessage = I18n.tr((String)"Starting address number must be less than ending address number");
            }
        }
        if (errorMessage.equals("")) {
            return true;
        }
        JOptionPane.showMessageDialog(Main.parent, errorMessage, I18n.tr((String)"Error"), 0);
        return false;
    }

    private String GetInterpolationMethod() {
        int selectedIndex = this.addrInterpolationList.getSelectedIndex();
        return this.addrInterpolationTags[selectedIndex];
    }
}

