/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.tcx.ActivityLapT;
import org.openstreetmap.josm.io.tcx.ActivityT;
import org.openstreetmap.josm.io.tcx.CourseT;
import org.openstreetmap.josm.io.tcx.PositionT;
import org.openstreetmap.josm.io.tcx.TrackT;
import org.openstreetmap.josm.io.tcx.TrackpointT;
import org.openstreetmap.josm.io.tcx.TrainingCenterDatabaseT;
import org.openstreetmap.josm.tools.I18n;

public class Tcx
extends FileImporter {
    private GpxData gpxData;

    public Tcx() {
        super(new ExtensionFileFilter("tcx", "tcx", I18n.tr((String)"TCX Files (*.tcx)")));
    }

    public void importData(File tcxFile) throws IOException {
        this.parseFile(tcxFile);
        GpxData gpxData = this.getGpxData();
        gpxData.storageFile = tcxFile;
        GpxLayer gpxLayer = new GpxLayer(gpxData, tcxFile.getName());
        Main.main.addLayer((Layer)gpxLayer);
        if (Main.pref.getBoolean("marker.makeautomarkers", true)) {
            MarkerLayer ml = new MarkerLayer(gpxData, I18n.tr((String)"Markers from {0}", (Object[])new Object[]{tcxFile.getName()}), tcxFile, gpxLayer);
            if (ml.data.size() > 0) {
                Main.main.addLayer((Layer)ml);
            }
        }
    }

    private void parseFile(File tcxFile) {
        try {
            JAXBContext jc = JAXBContext.newInstance(TrainingCenterDatabaseT.class);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            JAXBElement element = (JAXBElement)unmarshaller.unmarshal(tcxFile);
            TrainingCenterDatabaseT tcd = (TrainingCenterDatabaseT)element.getValue();
            this.gpxData = new GpxData();
            this.parseDataFromActivities(tcd);
            this.parseDataFromCourses(tcd);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private static WayPoint convertPoint(TrackpointT tp) {
        XMLGregorianCalendar time;
        PositionT p = tp.getPosition();
        if (p == null) {
            return null;
        }
        WayPoint waypt = new WayPoint(new LatLon(p.getLatitudeDegrees(), p.getLongitudeDegrees()));
        Double altitudeMeters = tp.getAltitudeMeters();
        if (altitudeMeters != null) {
            waypt.attr.put("ele", altitudeMeters.toString());
        }
        if ((time = tp.getTime()) != null) {
            waypt.attr.put("time", time.toString());
            waypt.time = 0.001 * (double)time.toGregorianCalendar().getTimeInMillis();
        }
        return waypt;
    }

    private void parseDataFromActivities(TrainingCenterDatabaseT tcd) {
        int lap = 0;
        if (tcd.getActivities() != null && tcd.getActivities().getActivity() != null) {
            for (ActivityT activity : tcd.getActivities().getActivity()) {
                if (activity.getLap() == null) continue;
                for (ActivityLapT activityLap : activity.getLap()) {
                    if (activityLap.getTrack() == null) continue;
                    XMLGregorianCalendar startTime = activityLap.getStartTime();
                    GpxTrack currentTrack = new GpxTrack();
                    this.gpxData.tracks.add(currentTrack);
                    for (TrackT track : activityLap.getTrack()) {
                        if (track.getTrackpoint() == null) continue;
                        ArrayList<WayPoint> currentTrackSeg = new ArrayList<WayPoint>();
                        currentTrack.trackSegs.add(currentTrackSeg);
                        for (TrackpointT tp : track.getTrackpoint()) {
                            WayPoint waypt = Tcx.convertPoint(tp);
                            if (waypt == null) continue;
                            if (startTime != null) {
                                waypt.attr.put("name", "LAP" + ++lap);
                                this.gpxData.waypoints.add(waypt);
                                startTime = null;
                            }
                            currentTrackSeg.add(waypt);
                        }
                    }
                }
            }
        }
    }

    private void parseDataFromCourses(TrainingCenterDatabaseT tcd) {
        if (tcd.getCourses() != null && tcd.getCourses().getCourse() != null) {
            for (CourseT course : tcd.getCourses().getCourse()) {
                if (course.getTrack() == null) continue;
                GpxTrack currentTrack = new GpxTrack();
                this.gpxData.tracks.add(currentTrack);
                for (TrackT track : course.getTrack()) {
                    if (track.getTrackpoint() == null) continue;
                    ArrayList<WayPoint> currentTrackSeg = new ArrayList<WayPoint>();
                    currentTrack.trackSegs.add(currentTrackSeg);
                    for (TrackpointT tp : track.getTrackpoint()) {
                        WayPoint waypt = Tcx.convertPoint(tp);
                        if (waypt == null) continue;
                        currentTrackSeg.add(waypt);
                    }
                }
            }
        }
    }

    private GpxData getGpxData() {
        return this.gpxData;
    }
}

