/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.agpifoj;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.agpifoj.AgpifojLayer;
import org.openstreetmap.josm.plugins.agpifoj.ImageDisplay;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class AgpifojDialog
extends ToggleDialog
implements ActionListener {
    private static final String COMMAND_ZOOM = "zoom";
    private static final String COMMAND_CENTERVIEW = "centre";
    private static final String COMMAND_NEXT = "next";
    private static final String COMMAND_REMOVE = "remove";
    private static final String COMMAND_PREVIOUS = "previous";
    private ImageDisplay imgDisplay = new ImageDisplay();
    private boolean centerView = false;
    private static AgpifojDialog INSTANCE = null;
    private AgpifojLayer currentLayer = null;
    private AgpifojLayer.ImageEntry currentEntry = null;

    public static AgpifojDialog getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AgpifojDialog();
        }
        return INSTANCE;
    }

    private AgpifojDialog() {
        super(I18n.tr((String)"AgPifoJ - Geotagged pictures"), "agpifoj", I18n.tr((String)"Display geotagged photos"), Shortcut.registerShortcut((String)"tools:geotagged", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Display geotagged photos")}), (int)89, (int)3), 200);
        if (INSTANCE != null) {
            throw new IllegalStateException("Agpifoj dialog should not be instanciated twice !");
        }
        INSTANCE = this;
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        content.add((Component)this.imgDisplay, "Center");
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        Dimension buttonDim = new Dimension(26, 26);
        JButton button = new JButton();
        button.setIcon(ImageProvider.get((String)"dialogs", (String)COMMAND_PREVIOUS));
        button.setActionCommand(COMMAND_PREVIOUS);
        button.setToolTipText(I18n.tr((String)"Previous"));
        button.addActionListener(this);
        button.setPreferredSize(buttonDim);
        buttons.add(button);
        button = new JButton();
        button.setIcon(ImageProvider.get((String)"dialogs", (String)"delete"));
        button.setActionCommand(COMMAND_REMOVE);
        button.setToolTipText(I18n.tr((String)"Remove photo from layer"));
        button.addActionListener(this);
        button.setPreferredSize(buttonDim);
        buttons.add(button);
        button = new JButton();
        button.setIcon(ImageProvider.get((String)"dialogs", (String)COMMAND_NEXT));
        button.setActionCommand(COMMAND_NEXT);
        button.setToolTipText(I18n.tr((String)"Next"));
        button.addActionListener(this);
        button.setPreferredSize(buttonDim);
        buttons.add(button);
        JToggleButton tb = new JToggleButton();
        tb.setIcon(ImageProvider.get((String)"dialogs", (String)"centreview"));
        tb.setActionCommand(COMMAND_CENTERVIEW);
        tb.setToolTipText(I18n.tr((String)"Center view"));
        tb.addActionListener(this);
        tb.setPreferredSize(buttonDim);
        buttons.add(tb);
        button = new JButton();
        button.setIcon(ImageProvider.get((String)"dialogs", (String)"zoom-best-fit"));
        button.setActionCommand(COMMAND_ZOOM);
        button.setToolTipText(I18n.tr((String)"Zoom best fit and 1:1"));
        button.addActionListener(this);
        button.setPreferredSize(buttonDim);
        buttons.add(button);
        content.add((Component)buttons, "South");
        this.add(content, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        if (COMMAND_NEXT.equals(e.getActionCommand())) {
            if (this.currentLayer != null) {
                this.currentLayer.showNextPhoto();
            }
        } else if (COMMAND_PREVIOUS.equals(e.getActionCommand())) {
            if (this.currentLayer != null) {
                this.currentLayer.showPreviousPhoto();
            }
        } else if (COMMAND_CENTERVIEW.equals(e.getActionCommand())) {
            this.centerView = ((JToggleButton)e.getSource()).isSelected();
            if (this.centerView && this.currentEntry != null && this.currentEntry.pos != null) {
                Main.map.mapView.zoomTo((LatLon)this.currentEntry.pos);
            }
        } else if (COMMAND_ZOOM.equals(e.getActionCommand())) {
            this.imgDisplay.zoomBestFitOrOne();
        } else if (COMMAND_REMOVE.equals(e.getActionCommand()) && this.currentLayer != null) {
            this.currentLayer.removeCurrentPhoto();
        }
    }

    public static void showImage(AgpifojLayer layer, AgpifojLayer.ImageEntry entry) {
        AgpifojDialog.getInstance().displayImage(layer, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayImage(AgpifojLayer layer, AgpifojLayer.ImageEntry entry) {
        AgpifojDialog agpifojDialog = this;
        synchronized (agpifojDialog) {
            if (this.currentLayer == layer && this.currentEntry == entry) {
                this.repaint();
                return;
            }
            if (this.centerView && Main.map != null && entry != null && entry.pos != null) {
                Main.map.mapView.zoomTo((LatLon)entry.pos);
            }
            this.currentLayer = layer;
            this.currentEntry = entry;
        }
        if (entry != null) {
            this.imgDisplay.setImage(entry.file);
            StringBuffer osd = new StringBuffer(entry.file != null ? entry.file.getName() : "");
            if (entry.elevation != null) {
                osd.append(I18n.tr((String)"\nAltitude: {0} m", (Object[])new Object[]{entry.elevation.longValue()}));
            }
            if (entry.speed != null) {
                osd.append(I18n.tr((String)"\n{0} km/h", (Object[])new Object[]{Math.round(entry.speed)}));
            }
            this.imgDisplay.setOsdText(osd.toString());
        } else {
            this.imgDisplay.setImage(null);
            this.imgDisplay.setOsdText("");
        }
    }

    public boolean hasImage() {
        return this.currentEntry != null;
    }
}

