/*
 * Decompiled with CFR 0.152.
 */
package MichiganLeft;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MichiganLeftAction
extends JosmAction {
    private LinkedList<Command> cmds = new LinkedList();

    public MichiganLeftAction() {
        super(I18n.tr((String)"Michigan Left"), "michigan_left", I18n.tr((String)"Adds no left turn for sets of 4 or 5 ways."), Shortcut.registerShortcut((String)"tools:michigan_left", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Michigan Left")}), (int)77, (int)3, (int)1), true);
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = Main.main.getCurrentDataSet().getSelected();
        int ways = 0;
        for (OsmPrimitive prim : selection) {
            if (!(prim instanceof Way)) continue;
            ++ways;
        }
        if (ways != 4 && ways != 5) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select 4 or 5 ways to assign no left turns."));
            return;
        }
        if (ways == 5) {
            Node last;
            Node first;
            Way way;
            Hashtable ExtremNodes = new Hashtable();
            for (OsmPrimitive prim : selection) {
                if (!(prim instanceof Way)) continue;
                Way way2 = (Way)prim;
                this.incrementHashtable(ExtremNodes, way2.firstNode());
                this.incrementHashtable(ExtremNodes, way2.lastNode());
            }
            System.out.println(I18n.tr((String)"{0} extrem nodes.", (Object[])new Object[]{ExtremNodes.size()}));
            ArrayList<Node> viaNodes = new ArrayList<Node>();
            Enumeration enumKey = ExtremNodes.keys();
            while (enumKey.hasMoreElements()) {
                Node extrem = (Node)enumKey.nextElement();
                Integer nb = (Integer)ExtremNodes.get(extrem);
                System.out.println(I18n.tr((String)"Via node {0}, {1}", (Object[])new Object[]{extrem.getId(), (int)nb}));
                if (nb != 3) continue;
                viaNodes.add(extrem);
            }
            System.out.println(I18n.tr((String)"{0} via nodes.", (Object[])new Object[]{viaNodes.size()}));
            if (viaNodes.size() != 2) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Unable to find via nodes. Please check your selection"));
                return;
            }
            Node viaFirst = (Node)viaNodes.get(0);
            Node viaLast = (Node)viaNodes.get(1);
            Way middle = null;
            for (OsmPrimitive prim : selection) {
                if (!(prim instanceof Way)) continue;
                way = (Way)prim;
                first = way.firstNode();
                last = way.lastNode();
                if ((!first.equals((Object)viaFirst) || !last.equals((Object)viaLast)) && (!first.equals((Object)viaLast) || !last.equals((Object)viaFirst))) continue;
                middle = way;
            }
            System.out.println(I18n.tr((String)"MIddle way: {0}", (Object[])new Object[]{middle.getId()}));
            for (OsmPrimitive prim : selection) {
                if (!(prim instanceof Way) || (way = (Way)prim) == middle) continue;
                first = way.firstNode();
                last = way.lastNode();
                if (first == viaFirst) {
                    this.buildRelation(middle, way, (Node)viaNodes.get(0));
                    continue;
                }
                if (first == viaLast) {
                    this.buildRelation(middle, way, (Node)viaNodes.get(1));
                    continue;
                }
                if (last == viaFirst) {
                    this.buildRelation(way, middle, (Node)viaNodes.get(0));
                    continue;
                }
                if (last != viaLast) continue;
                this.buildRelation(way, middle, (Node)viaNodes.get(1));
            }
            SequenceCommand c = new SequenceCommand(I18n.tr((String)"Create Michigan left turn restriction"), this.cmds);
            Main.main.undoRedo.add((Command)c);
            this.cmds.clear();
        }
    }

    public void incrementHashtable(Hashtable hash, Node node) {
        System.out.println(I18n.tr((String)"Processing {0}", (Object[])new Object[]{node.getId()}));
        if (hash.containsKey(node)) {
            Integer nb = (Integer)hash.get(node);
            hash.put(node, new Integer(nb + 1));
            System.out.println(I18n.tr((String)"Old value", (Object[])new Object[]{(int)nb}));
        } else {
            hash.put(node, new Integer(1));
        }
    }

    public void buildRelation(Way fromWay, Way toWay, Node viaNode) {
        System.out.println(I18n.tr((String)"Relation: from {0} to {1} via {2}", (Object[])new Object[]{fromWay.getId(), toWay.getId(), viaNode.getId()}));
        Relation relation = new Relation();
        RelationMember from = new RelationMember("from", (OsmPrimitive)fromWay);
        relation.addMember(from);
        RelationMember to = new RelationMember("to", (OsmPrimitive)toWay);
        relation.addMember(to);
        RelationMember via = new RelationMember("via", (OsmPrimitive)viaNode);
        relation.addMember(via);
        relation.put("type", "restriction");
        relation.put("restriction", "no_left_turn");
        this.cmds.add((Command)new AddCommand((OsmPrimitive)relation));
    }
}

