/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.preset;

import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.tageditor.preset.Group;
import org.openstreetmap.josm.plugins.tageditor.preset.INameIconProvider;
import org.openstreetmap.josm.plugins.tageditor.preset.Tag;
import org.openstreetmap.josm.plugins.tageditor.util.IndentWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Item
implements INameIconProvider {
    private static Logger logger = Logger.getLogger(Item.class.getName());
    private String name;
    private String iconName;
    private ImageIcon icon;
    private String label;
    private List<Tag> tags;
    private Group parent;

    public Item() {
        this.tags = new ArrayList<Tag>();
    }

    public Group getParent() {
        return this.parent;
    }

    public void setParent(Group parent) {
        this.parent = parent;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Item(String name) {
        this.setName(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIconName() {
        return this.iconName;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    @Override
    public Icon getIcon() {
        if (this.icon == null) {
            URL url = Main.class.getResource("/images/" + this.getIconName());
            if (url == null) {
                logger.warning("failed to create URL for resource 'images/" + this.getIconName() + "'");
                this.icon = null;
            } else {
                this.icon = new ImageIcon(url);
            }
            Image i = this.icon.getImage().getScaledInstance(16, 16, 1);
            this.icon = new ImageIcon(i);
        }
        return this.icon;
    }

    public void addTag(Tag tag) {
        this.tags.add(tag);
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void dump(IndentWriter writer) throws IOException {
        writer.indent();
        writer.write("<item ");
        writer.write(String.format("name=\"%s\" ", this.name));
        writer.write(String.format("label=\"%s\" ", this.label));
        writer.write(String.format("iconName=\"%s\" ", this.iconName));
        writer.write(">");
        writer.write("\n");
        writer.incLevel();
        for (Tag tag : this.tags) {
            tag.dump(writer);
        }
        writer.decLevel();
        writer.writeLine("</item>");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(this.getClass().getName()).append(":").append("name=").append(this.name).append("]");
        return builder.toString();
    }
}

