/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.ac;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.plugins.tageditor.ac.AutoCompletionListItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompletionList
extends AbstractTableModel {
    private ArrayList<AutoCompletionListItem> list = new ArrayList();
    private ArrayList<AutoCompletionListItem> filtered = new ArrayList();
    private String filter = null;

    public void applyFilter(String filter) {
        if (filter == null) {
            throw new IllegalArgumentException("argument 'filter' must not be null");
        }
        this.filter = filter;
        this.filter();
    }

    public void clearFilter() {
        this.filter = null;
        this.filter();
    }

    public String getFilter() {
        return this.filter;
    }

    public void add(AutoCompletionListItem item) {
        if (item == null) {
            return;
        }
        this.appendOrUpdatePriority(item);
        this.sort();
        this.filter();
    }

    public void add(AutoCompletionList other) {
        if (other == null) {
            throw new IllegalArgumentException("argument 'other' must not be null");
        }
        for (AutoCompletionListItem item : other.list) {
            this.appendOrUpdatePriority(item);
        }
        this.sort();
        this.filter();
    }

    public void add(List<AutoCompletionListItem> other) {
        if (other == null) {
            throw new IllegalArgumentException("argument 'other' must not be null");
        }
        for (AutoCompletionListItem toadd : other) {
            this.appendOrUpdatePriority(toadd);
        }
        this.sort();
        this.filter();
    }

    protected void appendOrUpdatePriority(AutoCompletionListItem toadd) {
        AutoCompletionListItem item = this.lookup(toadd.getValue());
        if (item == null) {
            this.list.add(toadd);
        } else if (toadd.getPriority().compareTo(item.getPriority()) < 0) {
            item.setPriority(toadd.getPriority());
        }
    }

    public boolean contains(AutoCompletionListItem item) {
        if (item == null) {
            return false;
        }
        return this.list.contains(item);
    }

    public boolean contains(String value) {
        if (value == null) {
            return false;
        }
        for (AutoCompletionListItem item : this.list) {
            if (!item.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public AutoCompletionListItem lookup(String value) {
        if (value == null) {
            return null;
        }
        for (AutoCompletionListItem item : this.list) {
            if (!item.getValue().equals(value)) continue;
            return item;
        }
        return null;
    }

    public void remove(String key) {
        if (key == null) {
            return;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            AutoCompletionListItem item = this.list.get(i);
            if (!item.getValue().equals(key)) continue;
            this.list.remove(i);
            return;
        }
    }

    protected void sort() {
        Collections.sort(this.list);
    }

    protected void filter() {
        this.filtered.clear();
        if (this.filter == null) {
            this.filtered.ensureCapacity(this.list.size());
            for (AutoCompletionListItem item : this.list) {
                this.filtered.add(item);
            }
            return;
        }
        for (AutoCompletionListItem item : this.list) {
            if (!item.getValue().startsWith(this.filter)) continue;
            this.filtered.add(item);
        }
        this.fireTableDataChanged();
    }

    public int getFilteredSize() {
        return this.filtered.size();
    }

    public AutoCompletionListItem getFilteredItem(int idx) {
        if (idx < 0 || idx >= this.getFilteredSize()) {
            throw new IndexOutOfBoundsException("idx out of bounds. idx=" + idx);
        }
        return this.filtered.get(idx);
    }

    public void clear() {
        this.list.clear();
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return this.list == null ? 0 : this.getFilteredSize();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.list == null ? null : this.getFilteredItem(rowIndex);
    }
}

