/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress;

import java.text.Normalizer;
import java.util.ArrayList;
import org.openstreetmap.josm.data.coor.LatLon;

public abstract class StringUtils {
    public static String extractNumber(String s) {
        char ch;
        String result = "";
        for (int i = 0; i < s.length() && (ch = s.charAt(i)) >= '0' && ch <= '9'; ++i) {
            result = result + ch;
        }
        return result;
    }

    public static String coordinateToString(double coor) {
        double degrees = Math.floor(coor);
        double minutes = Math.floor(60.0 * (coor - degrees));
        double seconds = 3600.0 * (coor - degrees - minutes / 60.0);
        return String.valueOf(Math.round(degrees)) + "\u00b0" + String.valueOf(Math.round(minutes)) + "'" + String.valueOf((double)Math.round(100.0 * seconds) / 100.0) + "\"";
    }

    public static String latLonToString(LatLon position) {
        if (position == null) {
            return "";
        }
        return "(lat: " + StringUtils.coordinateToString(position.lat()) + " lon: " + StringUtils.coordinateToString(position.lon()) + ")";
    }

    public static boolean matchAbbrev(String s1, String s2) {
        int i;
        s1 = StringUtils.anglicize(s1);
        s2 = StringUtils.anglicize(s2);
        ArrayList<Integer> beg1 = new ArrayList<Integer>(4);
        ArrayList<Integer> beg2 = new ArrayList<Integer>(4);
        int lastChar = 32;
        for (i = 0; i < s1.length(); ++i) {
            if (s1.charAt(i) != ' ' && lastChar == 32) {
                beg1.add(i);
            }
            lastChar = s1.charAt(i);
        }
        lastChar = 32;
        for (i = 0; i < s2.length(); ++i) {
            if (s2.charAt(i) != ' ' && lastChar == 32) {
                beg2.add(i);
            }
            lastChar = s2.charAt(i);
        }
        if (beg1.size() != beg2.size()) {
            return false;
        }
        for (i = 0; i < beg1.size(); ++i) {
            int pos2;
            int pos1 = (Integer)beg1.get(i);
            boolean doContinue = false;
            for (pos2 = ((Integer)beg2.get(i)).intValue(); pos1 < s1.length() && pos2 < s2.length(); ++pos1, ++pos2) {
                if (s1.charAt(pos1) == '.' || s2.charAt(pos2) == '.') {
                    doContinue = true;
                    break;
                }
                if (s1.charAt(pos1) == ' ' && s2.charAt(pos2) == ' ') {
                    doContinue = true;
                    break;
                }
                if (Character.toUpperCase(s1.charAt(pos1)) == Character.toUpperCase(s2.charAt(pos2))) continue;
                return false;
            }
            if (doContinue || !(pos1 >= s1.length() ^ pos2 >= s2.length())) continue;
            return false;
        }
        return true;
    }

    public static String capitalize(String s) {
        String[] noBegCap;
        String[] mesice;
        String[] noCapitalize;
        char last;
        if (s == null) {
            return null;
        }
        char[] charr = s.toCharArray();
        char ch = last = ' ';
        for (int i = 0; i < charr.length; ++i) {
            ch = charr[i];
            ch = last >= 'a' && last <= '\u017e' || last >= 'A' && last <= '\u017d' ? Character.toLowerCase(ch) : Character.toTitleCase(ch);
            last = charr[i] = ch;
        }
        String result = String.valueOf(charr);
        result = result.replaceAll("N\u00e1b\u0159. ", "n\u00e1b\u0159e\u017e\u00ed ");
        result = result.replaceAll("Ul. ", "ulice ");
        result = result.replaceAll("N\u00e1m. ", "n\u00e1m\u011bst\u00ed ");
        result = result.replaceAll("Kpt. ", "kapit\u00e1na ");
        result = result.replaceAll("B\u0159\u00ed. ", "brat\u0159\u00ed ");
        for (String noc : noCapitalize = new String[]{"Nad", "Pod", "U", "Na", "Z"}) {
            result = result.replaceAll(" " + noc + " ", " " + noc.toLowerCase() + " ");
        }
        for (String mesic : mesice = new String[]{"Ledna", "\u00danora", "B\u0159ezna", "Dubna", "Kv\u011btna", "M\u00e1je", "\u010cervna", "\u010cervence", "Srpna", "Z\u00e1\u0159\u00ed", "\u0158\u00edjna", "Listopadu", "Prosince"}) {
            result = result.replaceAll("." + mesic, ". " + mesic.toLowerCase());
        }
        for (String noc : noBegCap = new String[]{"T\u0159\u00edda", "Ulice", "N\u00e1m\u011bst\u00ed", "N\u00e1b\u0159e\u017e\u00ed"}) {
            result = result.replaceAll(noc, noc.toLowerCase());
        }
        return result.replaceAll("  ", " ");
    }

    public static String anglicize(String str) {
        String strNFD = Normalizer.normalize(str, Normalizer.Form.NFD);
        StringBuilder sb = new StringBuilder(str.length());
        for (char ch : strNFD.toCharArray()) {
            if (Character.getType(ch) == 6) continue;
            sb.append(ch);
        }
        return sb.toString();
    }
}

