/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.validator.ErrorTreePanel;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.AgregatePrimitivesVisitor;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidateUploadHook
implements UploadAction.UploadHook {
    private static final long serialVersionUID = -2304521273582574603L;
    private OSMValidatorPlugin plugin;

    public ValidateUploadHook(OSMValidatorPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean checkUpload(APIDataSet apiDataSet) {
        Collection<Test> tests = OSMValidatorPlugin.getEnabledTests(true);
        if (tests.isEmpty()) {
            return true;
        }
        AgregatePrimitivesVisitor v = new AgregatePrimitivesVisitor();
        v.visit(apiDataSet.getPrimitivesToAdd());
        Collection<OsmPrimitive> selection = v.visit(apiDataSet.getPrimitivesToUpdate());
        ArrayList<TestError> errors = new ArrayList<TestError>(30);
        for (Test test : tests) {
            test.setBeforeUpload(true);
            test.setPartialSelection(true);
            test.startTest();
            test.visit(selection);
            test.endTest();
            if (Main.pref.getBoolean("validator.otherUpload", false)) {
                errors.addAll(test.getErrors());
                continue;
            }
            for (TestError e : test.getErrors()) {
                if (e.getSeverity() == Severity.OTHER) continue;
                errors.add(e);
            }
        }
        tests = null;
        if (errors == null || errors.isEmpty()) {
            return true;
        }
        if (Main.pref.getBoolean("validator.ignore", true)) {
            int nume = 0;
            for (TestError error : errors) {
                ArrayList<String> s = new ArrayList<String>();
                s.add(error.getIgnoreState());
                s.add(error.getIgnoreGroup());
                s.add(error.getIgnoreSubGroup());
                for (String state : s) {
                    if (state == null || !this.plugin.ignoredErrors.contains(state)) continue;
                    error.setIgnored(true);
                }
                if (error.getIgnored().booleanValue()) continue;
                ++nume;
            }
            if (nume == 0) {
                return true;
            }
        }
        return this.displayErrorScreen(errors);
    }

    private boolean displayErrorScreen(List<TestError> errors) {
        JPanel p = new JPanel(new GridBagLayout());
        ErrorTreePanel errorPanel = new ErrorTreePanel(errors);
        errorPanel.expandAll();
        p.add((Component)new JScrollPane(errorPanel), GBC.eol());
        int res = JOptionPane.showConfirmDialog(Main.parent, p, I18n.tr((String)"Data with errors. Upload anyway?"), 0, 3);
        if (res == 1) {
            this.plugin.validationDialog.tree.setErrors(errors);
            this.plugin.validationDialog.setVisible(true);
            DataSet.fireSelectionChanged((Collection)Main.main.getCurrentDataSet().getSelected());
        }
        return res == 0;
    }
}

