/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.routes;

import java.awt.Color;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.OsmPrimitive;

public class RouteDefinition {
    private final Color color;
    private final String matchString;
    private SearchCompiler.Match match;
    private final int index;

    public RouteDefinition(int index, Color color, String expression) {
        this.color = color;
        this.matchString = expression;
        this.index = index;
        try {
            this.match = SearchCompiler.compile((String)expression, (boolean)false, (boolean)false);
        }
        catch (SearchCompiler.ParseError e) {
            this.match = null;
            e.printStackTrace();
        }
    }

    public boolean matches(OsmPrimitive primitive) {
        try {
            return this.match.match(primitive);
        }
        catch (SearchCompiler.ParseError e) {
            e.printStackTrace();
            return false;
        }
    }

    public Color getColor() {
        return this.color;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return this.color.toString() + " " + this.matchString;
    }
}

