/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.data.projection.Epsg4326;
import org.openstreetmap.josm.data.projection.Lambert;
import org.openstreetmap.josm.data.projection.Mercator;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.validator.ErrorLayer;
import org.openstreetmap.josm.plugins.validator.GridLayer;
import org.openstreetmap.josm.plugins.validator.PreferenceEditor;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.ValidateAction;
import org.openstreetmap.josm.plugins.validator.ValidateUploadHook;
import org.openstreetmap.josm.plugins.validator.ValidatorDialog;
import org.openstreetmap.josm.plugins.validator.tests.Coastlines;
import org.openstreetmap.josm.plugins.validator.tests.CrossingWays;
import org.openstreetmap.josm.plugins.validator.tests.DuplicateNode;
import org.openstreetmap.josm.plugins.validator.tests.DuplicateWay;
import org.openstreetmap.josm.plugins.validator.tests.DuplicatedWayNodes;
import org.openstreetmap.josm.plugins.validator.tests.NodesWithSameName;
import org.openstreetmap.josm.plugins.validator.tests.OverlappingWays;
import org.openstreetmap.josm.plugins.validator.tests.SelfIntersectingWay;
import org.openstreetmap.josm.plugins.validator.tests.SimilarNamedWays;
import org.openstreetmap.josm.plugins.validator.tests.TagChecker;
import org.openstreetmap.josm.plugins.validator.tests.UnclosedWays;
import org.openstreetmap.josm.plugins.validator.tests.UnconnectedWays;
import org.openstreetmap.josm.plugins.validator.tests.UntaggedNode;
import org.openstreetmap.josm.plugins.validator.tests.UntaggedWay;
import org.openstreetmap.josm.plugins.validator.tests.WronglyOrderedWays;
import org.openstreetmap.josm.plugins.validator.util.Util;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSMValidatorPlugin
extends Plugin
implements Layer.LayerChangeListener {
    protected static OSMValidatorPlugin plugin;
    protected static ErrorLayer errorLayer;
    ValidateAction validateAction = new ValidateAction(this);
    ValidatorDialog validationDialog;
    Map<Layer, List<TestError>> layerErrors = new HashMap<Layer, List<TestError>>();
    public static double griddetail;
    public Collection<String> ignoredErrors = new TreeSet<String>();
    public static Class<Test>[] allAvailableTests;
    private ValidateUploadHook uploadHook;

    public OSMValidatorPlugin() {
        plugin = this;
        this.checkPluginDir();
        this.initializeGridDetail();
        this.initializeTests(OSMValidatorPlugin.getTests());
        this.loadIgnoredErrors();
    }

    private void checkPluginDir() {
        try {
            File pathDir = new File(Util.getPluginDir());
            if (!pathDir.exists()) {
                pathDir.mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadIgnoredErrors() {
        this.ignoredErrors.clear();
        if (Main.pref.getBoolean("validator.ignore", true)) {
            try {
                BufferedReader in = new BufferedReader(new FileReader(Util.getPluginDir() + "ignorederrors"));
                String line = in.readLine();
                while (line != null) {
                    this.ignoredErrors.add(line);
                    line = in.readLine();
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveIgnoredErrors() {
        try {
            PrintWriter out = new PrintWriter((Writer)new FileWriter(Util.getPluginDir() + "ignorederrors"), false);
            for (String e : this.ignoredErrors) {
                out.println(e);
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new PreferenceEditor(this);
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            this.validationDialog = new ValidatorDialog(this);
            newFrame.addToggleDialog((ToggleDialog)this.validationDialog);
            this.initializeErrorLayer();
            if (Main.pref.hasKey("validator.debug.grid")) {
                Main.main.addLayer((Layer)new GridLayer(I18n.tr((String)"Grid")));
            }
            Layer.listeners.add(this);
        } else {
            Layer.listeners.remove((Object)this);
        }
        if (newFrame != null) {
            this.uploadHook = new ValidateUploadHook(this);
            UploadAction.registerUploadHook((UploadAction.UploadHook)this.uploadHook);
        } else {
            UploadAction.unregisterUploadHook((UploadAction.UploadHook)this.uploadHook);
            this.uploadHook = null;
        }
    }

    public void initializeErrorLayer() {
        if (!Main.pref.getBoolean("validator.layer", true)) {
            return;
        }
        if (errorLayer == null) {
            errorLayer = new ErrorLayer(this);
            Main.main.addLayer((Layer)errorLayer);
        }
    }

    public static Map<String, Test> getAllTestsMap() {
        HashMap<String, Test> tests = new HashMap<String, Test>();
        for (Class<Test> testClass : OSMValidatorPlugin.getAllAvailableTests()) {
            try {
                Test test = testClass.newInstance();
                tests.put(testClass.getSimpleName(), test);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        OSMValidatorPlugin.applyPrefs(tests, false);
        OSMValidatorPlugin.applyPrefs(tests, true);
        return tests;
    }

    private static void applyPrefs(Map<String, Test> tests, boolean beforeUpload) {
        Pattern regexp = Pattern.compile("(\\w+)=(true|false),?");
        Matcher m = regexp.matcher(Main.pref.get(beforeUpload ? "validator.testsBeforeUpload" : "validator.tests"));
        int pos = 0;
        while (m.find(pos)) {
            String testName = m.group(1);
            Test test = tests.get(testName);
            if (test != null) {
                boolean enabled = Boolean.valueOf(m.group(2));
                if (beforeUpload) {
                    test.testBeforeUpload = enabled;
                } else {
                    test.enabled = enabled;
                }
            }
            pos = m.end();
        }
    }

    public static Collection<Test> getTests() {
        return OSMValidatorPlugin.getAllTestsMap().values();
    }

    public static Collection<Test> getEnabledTests(boolean beforeUpload) {
        Collection<Test> enabledTests = OSMValidatorPlugin.getTests();
        for (Test t : new ArrayList<Test>(enabledTests)) {
            if (beforeUpload ? t.testBeforeUpload : t.enabled) continue;
            enabledTests.remove((Object)t);
        }
        return enabledTests;
    }

    public static Class<Test>[] getAllAvailableTests() {
        return allAvailableTests;
    }

    public void initializeGridDetail() {
        if (Main.proj.toString().equals(new Epsg4326().toString())) {
            griddetail = 10000.0;
        } else if (Main.proj.toString().equals(new Mercator().toString())) {
            griddetail = 100000.0;
        } else if (Main.proj.toString().equals(new Lambert().toString())) {
            griddetail = 0.1;
        }
    }

    public void initializeTests(Collection<Test> allTests) {
        for (Test test : allTests) {
            try {
                if (!test.enabled) continue;
                ((Object)((Object)test)).getClass().getMethod("initialize", OSMValidatorPlugin.class).invoke(null, new Object[]{this});
            }
            catch (InvocationTargetException ite) {
                ite.getCause().printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error initializing test {0}:\n {1}", (Object[])new Object[]{((Object)((Object)test)).getClass().getSimpleName(), ite.getCause().getMessage()}), I18n.tr((String)"Error"), 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error initializing test {0}:\n {1}", (Object[])new Object[]{((Object)((Object)test)).getClass().getSimpleName(), e}), I18n.tr((String)"Error"), 0);
            }
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        if (newLayer instanceof OsmDataLayer) {
            List<TestError> errors = this.layerErrors.get(newLayer);
            this.validationDialog.tree.setErrorList(errors);
            Main.map.repaint();
        }
    }

    public void layerAdded(Layer newLayer) {
        if (newLayer instanceof OsmDataLayer) {
            this.layerErrors.put(newLayer, new ArrayList());
        }
    }

    public void layerRemoved(Layer oldLayer) {
        this.layerErrors.remove(oldLayer);
    }

    static {
        errorLayer = null;
        allAvailableTests = new Class[]{DuplicateNode.class, OverlappingWays.class, UntaggedNode.class, UntaggedWay.class, SelfIntersectingWay.class, DuplicatedWayNodes.class, CrossingWays.class, SimilarNamedWays.class, NodesWithSameName.class, Coastlines.class, WronglyOrderedWays.class, UnclosedWays.class, TagChecker.class, UnconnectedWays.class, DuplicateWay.class};
    }
}

