/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.openvisible;

import at.dallermassl.josm.plugin.openvisible.OsmGpxBounds;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.GpxImporter;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmImporter;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class OpenVisibleAction
extends JosmAction {
    private File lastDirectory;

    public OpenVisibleAction() {
        super(I18n.tr((String)"Open Visible..."), "openvisible", I18n.tr((String)"Open only files that are visible in current view."), Shortcut.registerShortcut((String)"tools:openvisible", (String)I18n.tr((String)"Menu: {0}", (Object[])new Object[]{I18n.tr((String)"Open Visible...")}), (int)73, (int)2, (int)1), true);
    }

    public void actionPerformed(ActionEvent e) {
        if (Main.map == null || Main.map.mapView == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No view open - cannot determine boundaries!"));
            return;
        }
        MapView view = Main.map.mapView;
        Rectangle bounds = view.getBounds();
        LatLon bottomLeft = view.getLatLon(bounds.x, bounds.y + bounds.height);
        LatLon topRight = view.getLatLon(bounds.x + bounds.width, bounds.y);
        System.err.println("FileFind Bounds: " + bottomLeft + " to " + topRight);
        JFileChooser fileChooser = this.lastDirectory != null ? new JFileChooser(this.lastDirectory) : new JFileChooser();
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.showOpenDialog(Main.parent);
        File[] files = fileChooser.getSelectedFiles();
        this.lastDirectory = fileChooser.getCurrentDirectory();
        for (File file : files) {
            try {
                OsmGpxBounds parser = new OsmGpxBounds();
                parser.parse(new BufferedInputStream(new FileInputStream(file)));
                if (!parser.intersects(bottomLeft.lat(), topRight.lat(), bottomLeft.lon(), topRight.lon())) continue;
                System.out.println(file.getAbsolutePath());
                if (file.getName().endsWith("osm")) {
                    this.openAsData(file);
                    continue;
                }
                if (!file.getName().endsWith("gpx")) continue;
                this.openFileAsGpx(file);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (SAXException e1) {
                e1.printStackTrace();
            }
            catch (IllegalDataException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void openAsData(File file) throws SAXException, IOException, FileNotFoundException, IllegalDataException {
        String fn = file.getName();
        if (new OsmImporter().acceptFile(file)) {
            DataSet dataSet = OsmReader.parseDataSet((InputStream)new FileInputStream(file), (ProgressMonitor)NullProgressMonitor.INSTANCE);
            OsmDataLayer layer = new OsmDataLayer(dataSet, fn, file);
            Main.main.addLayer((Layer)layer);
        } else {
            JOptionPane.showMessageDialog(Main.parent, fn + ": " + I18n.tr((String)"Unknown file extension: {0}", (Object[])new Object[]{fn.substring(fn.lastIndexOf(46) + 1)}));
        }
    }

    private void openFileAsGpx(File file) throws SAXException, IOException, FileNotFoundException {
        String fn = file.getName();
        if (!new GpxImporter().acceptFile(file)) {
            throw new IllegalStateException();
        }
        GpxReader r = null;
        r = file.getName().endsWith(".gpx.gz") ? new GpxReader((InputStream)new GZIPInputStream(new FileInputStream(file)), file.getAbsoluteFile().getParentFile()) : new GpxReader((InputStream)new FileInputStream(file), file.getAbsoluteFile().getParentFile());
        r.data.storageFile = file;
        GpxLayer gpxLayer = new GpxLayer(r.data, fn);
        Main.main.addLayer((Layer)gpxLayer);
        Main.main.addLayer((Layer)new MarkerLayer(r.data, I18n.tr((String)"Markers from {0}", (Object[])new Object[]{fn}), file, gpxLayer));
    }
}

