/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.josm;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.tools.I18n;

public class CompatibilityUtil {
    private static boolean useMainDs = false;
    private static boolean useGetCurrentDataSet = false;

    private CompatibilityUtil() {
    }

    private static boolean hasMainDs() {
        try {
            Field f = Main.class.getField("ds");
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        return true;
    }

    private static boolean hasGetCurrentDataSet() {
        try {
            Method m = Main.class.getMethod("getCurrentDataSet", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    private static void analyse() {
        if (useMainDs || useGetCurrentDataSet) {
            return;
        }
        if (CompatibilityUtil.hasMainDs()) {
            useMainDs = true;
            System.out.println(I18n.tr((String)"INFO: entering compatibilty mode for JOSM with Main.ds"));
        } else if (CompatibilityUtil.hasGetCurrentDataSet()) {
            useGetCurrentDataSet = true;
            System.out.println(I18n.tr((String)"INFO: entering compatibilty mode for JOSM with Main.getCurrentDataSet()"));
        } else {
            throw new RuntimeException(I18n.tr((String)"Unexpected version of JOSM. Neither Main.ds nor Main.getCurrentDataSet() found."));
        }
    }

    private static DataSet getMainDs() throws RuntimeException {
        DataSet ds = null;
        try {
            Field f = Main.class.getField("ds");
            ds = (DataSet)f.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ds;
    }

    private static DataSet getGetCurrentDataSet() throws RuntimeException {
        DataSet ds = null;
        try {
            Method m = Main.class.getMethod("getCurrentDataSet", new Class[0]);
            ds = (DataSet)m.invoke((Object)Main.main, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ds;
    }

    public static DataSet getCurrentDataSet() throws RuntimeException {
        CompatibilityUtil.analyse();
        if (useMainDs) {
            return CompatibilityUtil.getMainDs();
        }
        if (useGetCurrentDataSet) {
            return CompatibilityUtil.getGetCurrentDataSet();
        }
        return null;
    }
}

