/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.lakewalker;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.lakewalker.LakewalkerException;
import org.openstreetmap.josm.plugins.lakewalker.LakewalkerWMS;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lakewalker {
    protected Collection<Command> commands = new LinkedList<Command>();
    protected Collection<Way> ways = new ArrayList<Way>();
    protected boolean cancel;
    private int waylen;
    private int maxnode;
    private int threshold;
    private double epsilon;
    private int resolution;
    private int tilesize;
    private String startdir;
    private String wmslayer;
    private File workingdir;
    private int[] dirslat = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private int[] dirslon = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    double start_radius_big = 0.001;
    double start_radius_small = 2.0E-4;

    public Lakewalker(int waylen, int maxnode, int threshold, double epsilon, int resolution, int tilesize, String startdir, String wmslayer, File workingdir) {
        this.waylen = waylen;
        this.maxnode = maxnode;
        this.threshold = threshold;
        this.epsilon = epsilon;
        this.resolution = resolution;
        this.tilesize = tilesize;
        this.startdir = startdir;
        this.wmslayer = wmslayer;
        this.workingdir = workingdir;
    }

    private int getDirectionIndex(String direction) throws ArrayIndexOutOfBoundsException {
        int i = 0;
        if (direction.equals("East") || direction.equals("east")) {
            i = 0;
        } else if (direction.equals("Northeast") || direction.equals("northeast")) {
            i = 1;
        } else if (direction.equals("North") || direction.equals("north")) {
            i = 2;
        } else if (direction.equals("Northwest") || direction.equals("northwest")) {
            i = 3;
        } else if (direction.equals("West") || direction.equals("west")) {
            i = 4;
        } else if (direction.equals("Southwest") || direction.equals("southwest")) {
            i = 5;
        } else if (direction.equals("South") || direction.equals("south")) {
            i = 6;
        } else if (direction.equals("Southeast") || direction.equals("southeast")) {
            i = 7;
        } else {
            throw new ArrayIndexOutOfBoundsException(I18n.tr((String)"Direction index '{0}' not found", (Object[])new Object[]{direction}));
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<double[]> trace(double lat, double lon, double tl_lon, double br_lon, double tl_lat, double br_lat, ProgressMonitor progressMonitor) throws LakewalkerException {
        progressMonitor.beginTask(null);
        try {
            int v;
            double[] geo;
            LakewalkerWMS wms = new LakewalkerWMS(this.resolution, this.tilesize, this.wmslayer, this.workingdir);
            LakewalkerBBox bbox = new LakewalkerBBox(tl_lat, tl_lon, br_lat, br_lon);
            Boolean detect_loop = false;
            ArrayList<double[]> nodelist = new ArrayList<double[]>();
            int[] xy = this.geo_to_xy(lat, lon, this.resolution);
            if (!bbox.contains(lat, lon).booleanValue()) {
                throw new LakewalkerException(I18n.tr((String)"The starting location was not within the bbox"));
            }
            progressMonitor.indeterminateSubTask(I18n.tr((String)"Looking for shoreline..."));
            while (bbox.contains((geo = this.xy_to_geo(xy[0], xy[1], this.resolution))[0], geo[1]).booleanValue() && (v = wms.getPixel(xy[0], xy[1], progressMonitor.createSubTaskMonitor(0, false))) <= this.threshold) {
                int delta_lat = this.dirslat[this.getDirectionIndex(this.startdir)];
                int delta_lon = this.dirslon[this.getDirectionIndex(this.startdir)];
                xy[0] = xy[0] + delta_lon;
                xy[1] = xy[1] + delta_lat;
            }
            int[] startxy = new int[]{xy[0], xy[1]};
            double[] startgeo = this.xy_to_geo(xy[0], xy[1], this.resolution);
            int last_dir = this.getDirectionIndex(this.startdir);
            for (int i = 0; i < this.maxnode; ++i) {
                double[] geo2;
                if (i % 250 == 0) {
                    progressMonitor.indeterminateSubTask(I18n.tr((String)"{0} nodes so far...", (Object[])new Object[]{i}));
                }
                int test_x = 0;
                int test_y = 0;
                int new_dir = 0;
                for (int d = 1; d <= this.dirslat.length; ++d) {
                    new_dir = (last_dir + d + 4) % 8;
                    test_x = xy[0] + this.dirslon[new_dir];
                    test_y = xy[1] + this.dirslat[new_dir];
                    geo2 = this.xy_to_geo(test_x, test_y, this.resolution);
                    if (!bbox.contains(geo2[0], geo2[1]).booleanValue()) {
                        System.out.println("Outside bbox");
                        break;
                    }
                    v = wms.getPixel(test_x, test_y, progressMonitor.createSubTaskMonitor(0, false));
                    if (v > this.threshold) break;
                    if (d != this.dirslat.length - 1) continue;
                    System.out.println("Got stuck");
                    break;
                }
                last_dir = new_dir;
                xy[0] = test_x;
                xy[1] = test_y;
                if (xy[0] == startxy[0] && xy[1] == startxy[1]) break;
                geo2 = this.xy_to_geo(xy[0], xy[1], this.resolution);
                nodelist.add(geo2);
                double start_proximity = Math.pow(geo2[0] - startgeo[0], 2.0) + Math.pow(geo2[1] - startgeo[1], 2.0);
                if (detect_loop.booleanValue()) {
                    if (!(start_proximity < Math.pow(this.start_radius_small, 2.0))) continue;
                    System.out.println("Detected loop");
                    break;
                }
                if (!(start_proximity > Math.pow(this.start_radius_big, 2.0))) continue;
                detect_loop = true;
            }
            ArrayList<double[]> arrayList = nodelist;
            return arrayList;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public ArrayList<double[]> duplicateNodeRemove(ArrayList<double[]> nodes) {
        if (nodes.size() <= 1) {
            return nodes;
        }
        double[] lastnode = new double[]{nodes.get(0)[0], nodes.get(0)[1]};
        for (int i = 1; i < nodes.size(); ++i) {
            double[] thisnode = new double[]{nodes.get(i)[0], nodes.get(i)[1]};
            if (thisnode[0] == lastnode[0] && thisnode[1] == lastnode[1]) {
                nodes.remove(i);
                --i;
            }
            lastnode = thisnode;
        }
        return nodes;
    }

    public ArrayList<double[]> vertexReduce(ArrayList<double[]> nodes, double proximity) {
        if (nodes.size() <= 1) {
            return nodes;
        }
        double[] test_v = nodes.get(0);
        ArrayList<double[]> reducednodes = new ArrayList<double[]>();
        double prox_sq = Math.pow(proximity, 2.0);
        for (int v = 0; v < nodes.size(); ++v) {
            if (!(Math.pow(nodes.get(v)[0] - test_v[0], 2.0) + Math.pow(nodes.get(v)[1] - test_v[1], 2.0) > prox_sq)) continue;
            reducednodes.add(nodes.get(v));
            test_v = nodes.get(v);
        }
        return reducednodes;
    }

    public double pointLineDistance(double[] p1, double[] p2, double[] p3) {
        double x0 = p1[0];
        double y0 = p1[1];
        double x1 = p2[0];
        double y1 = p2[1];
        double x2 = p3[0];
        double y2 = p3[1];
        if (x2 == x1 && y2 == y1) {
            return Math.sqrt(Math.pow(x1 - x0, 2.0) + Math.pow(y1 - y0, 2.0));
        }
        return Math.abs((x2 - x1) * (y1 - y0) - (x1 - x0) * (y2 - y1)) / Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
    }

    public ArrayList<double[]> douglasPeucker(ArrayList<double[]> nodes, double epsilon, int depth) {
        if (nodes.size() <= 1 || depth > 500) {
            return nodes;
        }
        int farthest_node = -1;
        double farthest_dist = 0.0;
        double[] first = nodes.get(0);
        double[] last = nodes.get(nodes.size() - 1);
        ArrayList<double[]> new_nodes = new ArrayList<double[]>();
        double d = 0.0;
        for (int i = 1; i < nodes.size(); ++i) {
            d = this.pointLineDistance(nodes.get(i), first, last);
            if (!(d > farthest_dist)) continue;
            farthest_dist = d;
            farthest_node = i;
        }
        ArrayList<Object> seg_a = new ArrayList();
        ArrayList<Object> seg_b = new ArrayList();
        if (farthest_dist > epsilon) {
            seg_a = this.douglasPeucker(this.sublist(nodes, 0, farthest_node + 1), epsilon, depth + 1);
            seg_b = this.douglasPeucker(this.sublist(nodes, farthest_node, nodes.size() - 1), epsilon, depth + 1);
            new_nodes.addAll(seg_a);
            new_nodes.addAll(seg_b);
        } else {
            new_nodes.add(nodes.get(0));
            new_nodes.add(nodes.get(nodes.size() - 1));
        }
        return new_nodes;
    }

    private ArrayList<double[]> sublist(ArrayList<double[]> l, int i, int f) throws ArrayIndexOutOfBoundsException {
        ArrayList<double[]> sub = new ArrayList<double[]>();
        if (f < i || i < 0 || f < 0 || f > l.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int j = i; j < f; ++j) {
            sub.add(l.get(j));
        }
        return sub;
    }

    public double[] xy_to_geo(int x, int y, double resolution) {
        double[] geo = new double[]{(double)y / resolution, (double)x / resolution};
        return geo;
    }

    public int[] geo_to_xy(double lat, double lon, double resolution) {
        int[] xy = new int[]{(int)Math.floor(lon * resolution + 0.5), (int)Math.floor(lat * resolution + 0.5)};
        return xy;
    }

    public void cancel() {
        this.cancel = true;
    }

    private class LakewalkerBBox {
        private double top = 90.0;
        private double left = -180.0;
        private double bottom = -90.0;
        private double right = 180.0;

        protected LakewalkerBBox(double top, double left, double bottom, double right) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }

        protected Boolean contains(double lat, double lon) {
            if (lat >= this.top || lat <= this.bottom) {
                return false;
            }
            if (lon >= this.right || lon <= this.left) {
                return false;
            }
            if ((this.right - this.left) % 360.0 == 0.0) {
                return true;
            }
            return (lon - this.left) % 360.0 <= (this.right - this.left) % 360.0;
        }
    }
}

