/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastrePlugin;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckSourceUploadHook
implements UploadAction.UploadHook {
    private static final long serialVersionUID = -1L;

    public boolean checkUpload(Collection<OsmPrimitive> add, Collection<OsmPrimitive> update, Collection<OsmPrimitive> delete) {
        if (CadastrePlugin.autoSourcing && CadastrePlugin.pluginUsed && !add.isEmpty()) {
            HashSet<OsmPrimitive> sel = new HashSet<OsmPrimitive>();
            for (OsmPrimitive osm : add) {
                if (!(osm instanceof Node) && !(osm instanceof Way) || osm.getKeys() != null && this.tagSourceExist(osm)) continue;
                sel.add(osm);
            }
            if (!sel.isEmpty()) {
                this.displaySource(sel);
            }
        }
        return true;
    }

    private boolean tagSourceExist(OsmPrimitive osm) {
        for (String key : osm.keySet()) {
            if (!key.equals("source")) continue;
            return true;
        }
        return false;
    }

    private void displaySource(Collection<OsmPrimitive> sel) {
        if (!sel.isEmpty()) {
            boolean bContinue;
            JPanel p = new JPanel(new GridBagLayout());
            OsmPrimitivRenderer renderer = new OsmPrimitivRenderer();
            p.add((Component)new JLabel(I18n.tr((String)"Auto-tag source added:")), GBC.eol());
            JList<Object> l = new JList<Object>(sel.toArray());
            l.setCellRenderer((ListCellRenderer<Object>)renderer);
            l.setVisibleRowCount(l.getModel().getSize() < 6 ? l.getModel().getSize() : 10);
            p.add((Component)new JScrollPane(l), GBC.eol().fill());
            boolean bl = bContinue = JOptionPane.showConfirmDialog(Main.parent, p, I18n.tr((String)"Add \"source=...\" to elements?"), 0) == 0;
            if (bContinue) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand(sel, "source", CadastrePlugin.source));
            }
        }
    }
}

