/*
 * Decompiled with CFR 0.152.
 */
package UtilsPlugin;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.CollectBackReferencesVisitor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplifyWayAction
extends JosmAction {
    public static double EARTH_RAD = 6378137.0;

    public SimplifyWayAction() {
        super(I18n.tr((String)"Simplify Way"), "simplify", I18n.tr((String)"Delete unnecessary nodes from a way."), Shortcut.registerShortcut((String)"tools:simplify", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Simplify Way")}), (int)89, (int)3, (int)1), true);
    }

    public void actionPerformed(ActionEvent e) {
        int option;
        Collection selection = Main.main.getCurrentDataSet().getSelected();
        int ways = 0;
        LinkedList<Bounds> bounds = new LinkedList<Bounds>();
        OsmDataLayer dataLayer = Main.map.mapView.getEditLayer();
        for (DataSource ds : dataLayer.data.dataSources) {
            if (ds.bounds == null) continue;
            bounds.add(ds.bounds);
        }
        for (OsmPrimitive prim : selection) {
            if (!(prim instanceof Way)) continue;
            if (bounds.size() > 0) {
                Way way = (Way)prim;
                for (Node node : way.getNodes()) {
                    boolean isInsideOneBoundingBox = false;
                    for (Bounds b : bounds) {
                        if (!b.contains(node.getCoor())) continue;
                        isInsideOneBoundingBox = true;
                        break;
                    }
                    if (isInsideOneBoundingBox) continue;
                    int option2 = JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)"The selected way(s) have nodes outside of the downloaded data region.\nThis can lead to nodes being deleted accidentally.\nAre you really sure to continue?"), I18n.tr((String)"Please abort if you are not sure"), 1, 2);
                    if (option2 == 0) break;
                    return;
                }
            }
            ++ways;
        }
        if (ways == 0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select at least one way to simplify."));
            return;
        }
        if (ways > 10 && (option = JOptionPane.showConfirmDialog(Main.parent, I18n.trn((String)"The selection contains {0} way. Are you sure you want to simplify it?", (String)"The selection contains {0} ways. Are you sure you want to simplify them all?", (long)ways, (Object[])new Object[]{ways}), I18n.tr((String)"Are you sure?"), 0)) != 0) {
            return;
        }
        for (OsmPrimitive prim : selection) {
            if (!(prim instanceof Way)) continue;
            this.simplifyWay((Way)prim);
        }
    }

    public void simplifyWay(Way w) {
        double threshold = Double.parseDouble(Main.pref.get("simplify-way.max-error", "3"));
        Way wnew = new Way(w);
        int toI = wnew.getNodesCount() - 1;
        for (int i = wnew.getNodesCount() - 1; i >= 0; --i) {
            CollectBackReferencesVisitor backRefsV = new CollectBackReferencesVisitor(Main.main.getCurrentDataSet(), false);
            backRefsV.visit(wnew.getNode(i));
            boolean used = false;
            if (backRefsV.data.size() == 1) {
                used = Collections.frequency(w.getNodes(), wnew.getNode(i)) > 1;
            } else {
                backRefsV.data.remove(w);
                boolean bl = used = !backRefsV.data.isEmpty();
            }
            if (!used) {
                used = wnew.getNode(i).isTagged();
            }
            if (!used) continue;
            this.simplifyWayRange(wnew, i, toI, threshold);
            toI = i;
        }
        this.simplifyWayRange(wnew, 0, toI, threshold);
        HashSet delNodes = new HashSet();
        delNodes.addAll(w.getNodes());
        delNodes.removeAll(wnew.getNodes());
        if (wnew.getNodesCount() != w.getNodesCount()) {
            LinkedList<Object> cmds = new LinkedList<Object>();
            cmds.add(new ChangeCommand((OsmPrimitive)w, (OsmPrimitive)wnew));
            cmds.add(new DeleteCommand(delNodes));
            Main.main.undoRedo.add((Command)new SequenceCommand(I18n.trn((String)"Simplify Way (remove {0} node)", (String)"Simplify Way (remove {0} nodes)", (long)delNodes.size(), (Object[])new Object[]{delNodes.size()}), cmds));
            Main.map.repaint();
        }
    }

    public void simplifyWayRange(Way wnew, int from, int to, double thr) {
        if (to - from >= 2) {
            ArrayList<Node> ns = new ArrayList<Node>();
            this.simplifyWayRange(wnew, from, to, ns, thr);
            List nodes = wnew.getNodes();
            for (int j = to - 1; j > from; --j) {
                nodes.remove(j);
            }
            nodes.addAll(from + 1, ns);
            wnew.setNodes(nodes);
        }
    }

    public void simplifyWayRange(Way wnew, int from, int to, ArrayList<Node> ns, double thr) {
        Node fromN = wnew.getNode(from);
        Node toN = wnew.getNode(to);
        int imax = -1;
        double xtemax = 0.0;
        for (int i = from + 1; i < to; ++i) {
            Node n = wnew.getNode(i);
            double xte = Math.abs(EARTH_RAD * SimplifyWayAction.xtd(fromN.getCoor().lat() * Math.PI / 180.0, fromN.getCoor().lon() * Math.PI / 180.0, toN.getCoor().lat() * Math.PI / 180.0, toN.getCoor().lon() * Math.PI / 180.0, n.getCoor().lat() * Math.PI / 180.0, n.getCoor().lon() * Math.PI / 180.0));
            if (!(xte > xtemax)) continue;
            xtemax = xte;
            imax = i;
        }
        if (imax != -1 && xtemax >= thr) {
            this.simplifyWayRange(wnew, from, imax, ns, thr);
            ns.add(wnew.getNode(imax));
            this.simplifyWayRange(wnew, imax, to, ns, thr);
        }
    }

    public static double dist(double lat1, double lon1, double lat2, double lon2) {
        return 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((lat1 - lat2) / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin((lon1 - lon2) / 2.0), 2.0)));
    }

    public static double course(double lat1, double lon1, double lat2, double lon2) {
        return Math.atan2(Math.sin(lon1 - lon2) * Math.cos(lat2), Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(lon1 - lon2)) % (Math.PI * 2);
    }

    public static double xtd(double lat1, double lon1, double lat2, double lon2, double lat3, double lon3) {
        double dist_AD = SimplifyWayAction.dist(lat1, lon1, lat3, lon3);
        double crs_AD = SimplifyWayAction.course(lat1, lon1, lat3, lon3);
        double crs_AB = SimplifyWayAction.course(lat1, lon1, lat2, lon2);
        return Math.asin(Math.sin(dist_AD) * Math.sin(crs_AD - crs_AB));
    }
}

