/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolTip;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.osb.OsbPlugin;
import org.openstreetmap.josm.plugins.osb.gui.action.OsbAction;
import org.openstreetmap.josm.plugins.osb.gui.action.PopupFactory;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.I18n;

public class OsbLayer
extends Layer
implements MouseListener {
    private DataSet data;
    private Collection<? extends OsmPrimitive> selection;
    private JToolTip tooltip = new JToolTip();

    public OsbLayer(DataSet dataSet, String name) {
        super(name);
        this.data = dataSet;
        DataSet.selListeners.add(new SelectionChangedListener(){

            public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
                OsbLayer.this.selection = newSelection;
            }
        });
        if (Main.map != null && Main.map.mapView != null) {
            Main.map.mapView.addMouseListener((MouseListener)this);
        }
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Component[] getMenuEntries() {
        return new Component[]{new JMenuItem((Action)LayerListDialog.getInstance().createShowHideLayerAction((Layer)this)), new JMenuItem((Action)LayerListDialog.getInstance().createDeleteLayerAction((Layer)this)), new JSeparator(), new JMenuItem((Action)new RenameLayerAction(null, (Layer)this)), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
    }

    public String getToolTipText() {
        return I18n.tr((String)"Displays OpenStreetBugs issues");
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public void paint(Graphics g, MapView mv) {
        Object[] nodes = this.data.nodes.toArray();
        for (int i = 0; i < nodes.length; ++i) {
            Node node = (Node)nodes[i];
            if (node.deleted) continue;
            Point p = mv.getPoint(node);
            ImageIcon icon = OsbPlugin.loadIcon("icon_error16.png");
            if ("1".equals(node.get("state"))) {
                icon = OsbPlugin.loadIcon("icon_valid16.png");
            }
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            g.drawImage(icon.getImage(), p.x - width / 2, p.y - height / 2, new ImageObserver(){

                public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                    return false;
                }
            });
            if (this.selection == null || !this.selection.contains(node)) continue;
            String desc = node.get("note");
            if (desc != null) {
                StringBuilder sb = new StringBuilder("<html>");
                sb.append(desc.replaceAll("<hr />", "<hr>"));
                sb.append("</html>");
                desc = sb.toString();
                int tooltipWidth = 0;
                Rectangle2D fontBounds = null;
                String[] lines = desc.split("<hr>");
                for (int j = 0; j < lines.length; ++j) {
                    String line = lines[j];
                    fontBounds = g.getFontMetrics().getStringBounds(line, g);
                    tooltipWidth = Math.max(tooltipWidth, (int)fontBounds.getWidth());
                }
                this.tooltip.setTipText(desc);
                this.tooltip.setSize(this.tooltip.getUI().getPreferredSize(this.tooltip));
                int tx = p.x + width / 2 + 5;
                int ty = p.y - height / 2 - 1;
                g.translate(tx, ty);
                this.tooltip.paint(g);
                g.translate(-tx, -ty);
            }
            g.setColor(ColorHelper.html2color((String)Main.pref.get("color.selected")));
            g.drawRect(p.x - width / 2, p.y - height / 2, 16, 16);
        }
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public Icon getIcon() {
        return OsbPlugin.loadIcon("icon_error16.png");
    }

    private Node getNearestNode(Point p) {
        double snapDistance = 10.0;
        double minDistanceSq = Double.MAX_VALUE;
        Node minPrimitive = null;
        for (Node n : this.data.nodes) {
            if (n.deleted || n.incomplete) continue;
            Point sp = Main.map.mapView.getPoint(n);
            double dist = p.distanceSq(sp);
            if (minDistanceSq > dist && p.distance(sp) < snapDistance) {
                minDistanceSq = p.distanceSq(sp);
                minPrimitive = n;
                continue;
            }
            if (minDistanceSq != dist || !n.isSelected() || minPrimitive.isSelected()) continue;
            minPrimitive = n;
        }
        return minPrimitive;
    }

    public void mouseClicked(MouseEvent e) {
        Node n;
        if (e.getButton() == 1 && Main.map.mapView.getActiveLayer() == this && this.data.nodes.contains(n = this.getNearestNode(e.getPoint()))) {
            this.data.setSelected(new OsmPrimitive[]{n});
        }
    }

    public void mousePressed(MouseEvent e) {
        this.mayTriggerPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.mayTriggerPopup(e);
    }

    private void mayTriggerPopup(MouseEvent e) {
        if (e.isPopupTrigger() && Main.map.mapView.getActiveLayer() == this) {
            Node n = this.getNearestNode(e.getPoint());
            OsbAction.setSelectedNode(n);
            if (this.data.nodes.contains(n)) {
                PopupFactory.createPopup(n).show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

