/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastrePlugin;
import cadastre_fr.DownloadWMSPlanImage;
import cadastre_fr.MenuActionNewLocation;
import cadastre_fr.WMSLayer;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class MenuActionGrabPlanImage
extends JosmAction
implements Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    public static String name = "Georeference an image";
    private DownloadWMSPlanImage downloadWMSPlanImage;
    private WMSLayer wmsLayer;
    private int countMouseClicked = 0;
    private int mode = 0;
    private int cGetCorners = 1;
    private int cGetLambertCrosspieces = 2;
    private EastNorth ea1;
    private Point mousePrevious = new Point();
    private EastNorth georefpoint1;
    private EastNorth georefpoint2;

    public MenuActionGrabPlanImage() {
        super(I18n.tr((String)name), "cadastre_small", I18n.tr((String)"Grab non-georeferenced image"), null, false);
    }

    public void actionCompleted() {
        this.countMouseClicked = 0;
        this.mode = 0;
        this.mousePrevious.setLocation(0, 0);
    }

    public void actionInterrupted() {
        this.actionCompleted();
        this.wmsLayer = null;
    }

    protected void updateEnabledState() {
        if (this.wmsLayer == null || Main.map == null || Main.map.mapView == null) {
            return;
        }
        if (this.countMouseClicked == 0 && this.mode == 0) {
            return;
        }
        for (Layer l : Main.map.mapView.getAllLayersAsList()) {
            if (l != this.wmsLayer) continue;
            return;
        }
        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Georeferencing interrupted"));
        this.actionInterrupted();
    }

    public void actionPerformed(ActionEvent ae) {
        if (Main.map != null) {
            if (CadastrePlugin.isCadastreProjection()) {
                this.wmsLayer = new MenuActionNewLocation().addNewLayer(new ArrayList<WMSLayer>());
                if (this.wmsLayer == null) {
                    return;
                }
                this.downloadWMSPlanImage = new DownloadWMSPlanImage();
                this.downloadWMSPlanImage.download(this.wmsLayer);
                Main.worker.execute(this);
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"To enable the cadastre WMS plugin, change\nthe current projection to one of the cadastre\nprojection and retry"));
            }
        }
    }

    public void run() {
        boolean loadedFromCache = this.downloadWMSPlanImage.waitFinished();
        if (this.wmsLayer.images.size() == 1 && !loadedFromCache) {
            Main.map.mapView.addMouseListener((MouseListener)this);
            this.mousePrevious.setLocation(0, 0);
            this.mode = this.cGetCorners;
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Click first corner for image cropping\n(two points required)"));
        } else {
            Main.map.repaint();
        }
    }

    public void mouseClicked(MouseEvent e) {
        if ((double)e.getX() == this.mousePrevious.getX() && (double)e.getY() == this.mousePrevious.getY()) {
            return;
        }
        this.mousePrevious.setLocation(e.getX(), e.getY());
        ++this.countMouseClicked;
        EastNorth ea = Main.proj.latlon2eastNorth(Main.map.mapView.getLatLon(e.getX(), e.getY()));
        System.out.println("clic:" + this.countMouseClicked + " ," + ea);
        if (ea.east() < this.wmsLayer.images.get((int)0).min.east() || ea.east() > this.wmsLayer.images.get((int)0).max.east() || ea.north() < this.wmsLayer.images.get((int)0).min.north() || ea.north() > this.wmsLayer.images.get((int)0).max.north()) {
            return;
        }
        if (this.mode == this.cGetCorners) {
            if (this.countMouseClicked == 1) {
                this.ea1 = ea;
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Click second corner for image cropping"));
            }
            if (this.countMouseClicked == 2) {
                this.wmsLayer.cropImage(this.ea1, ea);
                Main.map.mapView.repaint();
                this.countMouseClicked = 0;
                this.mode = this.cGetLambertCrosspieces;
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Click first Lambert crosspiece for georeferencing\n(two points required)"));
            }
        } else if (this.mode == this.cGetLambertCrosspieces) {
            if (this.countMouseClicked == 1) {
                this.ea1 = ea;
                this.georefpoint1 = this.inputLambertPosition();
                if (this.georefpoint1 == null) {
                    return;
                }
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Click second Lambert crosspiece for georeferencing\n"));
            }
            if (this.countMouseClicked == 2) {
                Main.map.mapView.removeMouseListener((MouseListener)this);
                this.georefpoint2 = this.inputLambertPosition();
                if (this.georefpoint2 == null) {
                    return;
                }
                this.affineTransform(this.ea1, ea, this.georefpoint1, this.georefpoint2);
                this.wmsLayer.saveNewCache();
                Main.map.mapView.repaint();
                this.actionCompleted();
            }
        }
    }

    private EastNorth inputLambertPosition() {
        JLabel labelEnterPosition = new JLabel(I18n.tr((String)"Enter cadastre east,north position"));
        JLabel labelWarning = new JLabel(I18n.tr((String)"(Warning: verify north with arrow !!)"));
        JPanel p = new JPanel(new GridBagLayout());
        JLabel labelEast = new JLabel(I18n.tr((String)"East"));
        JLabel labelNorth = new JLabel(I18n.tr((String)"North"));
        JTextField inputEast = new JTextField();
        JTextField inputNorth = new JTextField();
        p.add((Component)labelEnterPosition, GBC.eol());
        p.add((Component)labelWarning, GBC.eol());
        p.add((Component)labelEast, GBC.std().insets(0, 0, 10, 0));
        p.add((Component)inputEast, GBC.eol().fill(2).insets(10, 5, 0, 5));
        p.add((Component)labelNorth, GBC.std().insets(0, 0, 10, 0));
        p.add((Component)inputNorth, GBC.eol().fill(2).insets(10, 5, 0, 5));
        JOptionPane pane = new JOptionPane(p, 1, 2, null);
        pane.createDialog(Main.parent, I18n.tr((String)"Set Lambert coordinate")).setVisible(true);
        if (!Integer.valueOf(0).equals(pane.getValue())) {
            return null;
        }
        if (inputEast.getText().length() == 0 || inputNorth.getText().length() == 0) {
            return null;
        }
        try {
            double e = Double.parseDouble(inputEast.getText());
            double n = Double.parseDouble(inputNorth.getText());
            return new EastNorth(e, n);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void affineTransform(EastNorth org1, EastNorth org2, EastNorth dst1, EastNorth dst2) {
        double angle = dst1.heading(dst2) - org1.heading(org2);
        double proportion = dst1.distance((Point2D)dst2) / org1.distance((Point2D)org2);
        double dx = dst1.getX() - org1.getX();
        double dy = dst1.getY() - org1.getY();
        this.wmsLayer.images.get(0).shear(dx, dy);
        org1 = org1.add(dx, dy);
        org2 = org2.add(dx, dy);
        this.wmsLayer.images.get(0).rotate(dst1, angle);
        org2 = org2.rotate(dst1, angle);
        this.wmsLayer.images.get(0).scale(dst1, proportion);
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }
}

