/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastrePlugin;
import cadastre_fr.GeorefImage;
import cadastre_fr.WMSLayer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class CacheControl
implements Runnable {
    public static boolean cacheEnabled = true;
    public static int cacheSize = 500;
    public WMSLayer wmsLayer = null;
    private ArrayList<GeorefImage> imagesToSave = new ArrayList();
    private Lock imagesLock = new ReentrantLock();

    public CacheControl(WMSLayer wmsLayer) {
        cacheEnabled = Main.pref.getBoolean("cadastrewms.enableCaching", true);
        this.wmsLayer = wmsLayer;
        try {
            cacheSize = Integer.parseInt(Main.pref.get("cadastrewms.cacheSize", String.valueOf(500)));
        }
        catch (NumberFormatException e) {
            cacheSize = 500;
        }
        File path = new File(CadastrePlugin.cacheDir);
        if (!path.exists()) {
            path.mkdirs();
        } else {
            this.checkDirSize(path);
        }
        new Thread(this).start();
    }

    private void checkDirSize(File path) {
        long size = 0L;
        long oldestFileDate = Long.MAX_VALUE;
        int oldestFile = 0;
        File[] files = path.listFiles();
        for (int i = 0; i < files.length; ++i) {
            size += files[i].length();
            if (files[i].lastModified() >= oldestFileDate) continue;
            oldestFile = i;
            oldestFileDate = files[i].lastModified();
        }
        if (size > (long)(cacheSize * 1024 * 1024)) {
            System.out.println("Delete oldest file  \"" + files[oldestFile].getName() + "\" in cache dir to stay under the limit of " + cacheSize + " MB.");
            files[oldestFile].delete();
            this.checkDirSize(path);
        }
    }

    public boolean loadCacheIfExist() {
        try {
            File file = new File(CadastrePlugin.cacheDir + this.wmsLayer.getName() + "." + String.valueOf(this.wmsLayer.lambertZone + 1));
            if (file.exists()) {
                JOptionPane pane = new JOptionPane(I18n.tr((String)"Location \"{0}\" found in cache.\nLoad cache first ?\n(No = new cache)", (Object[])new Object[]{this.wmsLayer.getName()}), 3, 0, null);
                JDialog dialog = pane.createDialog(Main.parent, I18n.tr((String)"Select Feuille"));
                CadastrePlugin.prepareDialog(dialog);
                dialog.setVisible(true);
                int reply = (Integer)pane.getValue();
                if (reply == 0) {
                    return this.loadCache(file, this.wmsLayer.lambertZone);
                }
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return false;
    }

    public void deleteCacheFile() {
        try {
            File file = new File(CadastrePlugin.cacheDir + this.wmsLayer.getName() + "." + String.valueOf(this.wmsLayer.lambertZone + 1));
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public boolean loadCache(File file, int currentLambertZone) {
        try {
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            if (!this.wmsLayer.read(ois, currentLambertZone)) {
                return false;
            }
            ois.close();
            fis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error loading file"), I18n.tr((String)"Error"), 0);
            return false;
        }
        return true;
    }

    public synchronized void saveCache(GeorefImage image) {
        this.imagesLock.lock();
        this.imagesToSave.add(image);
        this.notify();
        this.imagesLock.unlock();
    }

    public synchronized void run() {
        while (true) {
            this.imagesLock.lock();
            ArrayList<GeorefImage> images = new ArrayList<GeorefImage>(this.imagesToSave);
            this.imagesToSave.clear();
            this.imagesLock.unlock();
            if (images != null && !images.isEmpty()) {
                File file = new File(CadastrePlugin.cacheDir + this.wmsLayer.getName() + "." + String.valueOf(this.wmsLayer.lambertZone + 1));
                try {
                    ObjectOutputStream oos;
                    if (file.exists()) {
                        oos = new ObjectOutputStreamAppend(new BufferedOutputStream(new FileOutputStream(file, true)));
                        for (GeorefImage img : images) {
                            oos.writeObject(img);
                        }
                        oos.close();
                    } else {
                        oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                        this.wmsLayer.write(oos, images);
                        oos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(System.out);
                }
            }
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace(System.out);
                continue;
            }
            break;
        }
    }

    public class ObjectOutputStreamAppend
    extends ObjectOutputStream {
        public ObjectOutputStreamAppend(OutputStream out) throws IOException {
            super(out);
        }

        protected void writeStreamHeader() throws IOException {
            this.reset();
        }
    }
}

