/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.Collection;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.awt.AWT;
import org.fest.swing.hierarchy.ChildrenFinder;
import org.fest.swing.hierarchy.ComponentHierarchy;
import org.fest.swing.hierarchy.ParentFinder;
import org.fest.swing.monitor.WindowMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExistingHierarchy
implements ComponentHierarchy {
    private static WindowMonitor windowMonitor = WindowMonitor.instance();
    private final ParentFinder parentFinder;
    private final ChildrenFinder childrenFinder;

    public ExistingHierarchy() {
        this(new ParentFinder(), new ChildrenFinder());
    }

    ExistingHierarchy(ParentFinder parentFinder, ChildrenFinder childrenFinder) {
        this.parentFinder = parentFinder;
        this.childrenFinder = childrenFinder;
    }

    @Override
    public Collection<? extends Container> roots() {
        return windowMonitor.rootWindows();
    }

    @Override
    @RunsInCurrentThread
    public Container parentOf(Component c) {
        return this.parentFinder.parentOf(c);
    }

    @Override
    public boolean contains(Component c) {
        return true;
    }

    @Override
    @RunsInCurrentThread
    public Collection<Component> childrenOf(Component c) {
        return this.childrenFinder.childrenOf(c);
    }

    @Override
    @RunsInCurrentThread
    public void dispose(Window w) {
        if (AWT.isAppletViewer(w)) {
            return;
        }
        for (Window owned : w.getOwnedWindows()) {
            this.dispose(owned);
        }
        if (AWT.isSharedInvisibleFrame(w)) {
            return;
        }
        w.dispose();
    }

    ParentFinder parentFinder() {
        return this.parentFinder;
    }

    ChildrenFinder childrenFinder() {
        return this.childrenFinder;
    }
}

