/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.fest.assertions.Assertions;
import org.fest.assertions.Description;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.cell.JTableCellWriter;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.data.TableCell;
import org.fest.swing.data.TableCellByColumnId;
import org.fest.swing.driver.ComponentDriver;
import org.fest.swing.driver.JTableDriver;
import org.fest.swing.fixture.ColorFixture;
import org.fest.swing.fixture.CommonComponentFixture;
import org.fest.swing.fixture.FontFixture;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.fixture.JPopupMenuInvokerFixture;
import org.fest.swing.fixture.JTableCellFixture;
import org.fest.swing.fixture.JTableHeaderFixture;
import org.fest.swing.timing.Timeout;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTableFixture
extends JPopupMenuInvokerFixture<JTable>
implements CommonComponentFixture {
    private JTableDriver driver;

    public JTableFixture(Robot robot, JTable target) {
        super(robot, target);
        this.createDriver();
    }

    public JTableFixture(Robot robot, String tableName) {
        super(robot, tableName, JTable.class);
        this.createDriver();
    }

    private void createDriver() {
        this.updateDriver(new JTableDriver(this.robot));
    }

    final void updateDriver(JTableDriver newDriver) {
        this.driver = newDriver;
    }

    protected final JTableDriver driver() {
        return this.driver;
    }

    public FontFixture fontAt(TableCell cell) {
        Font font = this.driver.font((JTable)this.target, cell);
        return new FontFixture(font, this.cellProperty(cell, "font"));
    }

    public ColorFixture backgroundAt(TableCell cell) {
        Color background = this.driver.background((JTable)this.target, cell);
        return new ColorFixture(background, this.cellProperty(cell, "background"));
    }

    public ColorFixture foregroundAt(TableCell cell) {
        Color foreground = this.driver.foreground((JTable)this.target, cell);
        return new ColorFixture(foreground, this.cellProperty(cell, "foreground"));
    }

    private Description cellProperty(TableCell cell, String propertyName) {
        return ComponentDriver.propertyName(this.target, Strings.concat((Object[])new Object[]{propertyName, " ", cell}));
    }

    public TableCell cell(String value) {
        return this.driver.cell((JTable)this.target, value);
    }

    public JTableCellFixture cell(TableCellByColumnId cell) {
        return new JTableCellFixture(this, this.driver.cell((JTable)this.target, cell));
    }

    public JTableCellFixture cell(TableCell cell) {
        this.driver.validate((JTable)this.target, cell);
        return new JTableCellFixture(this, cell);
    }

    public JTableHeaderFixture tableHeader() {
        JTableHeader tableHeader = this.driver.tableHeaderOf((JTable)this.target);
        Assertions.assertThat((Object)tableHeader).isNotNull();
        return new JTableHeaderFixture(this.robot, tableHeader);
    }

    public String selectionValue() {
        return this.driver.selectionValue((JTable)this.target);
    }

    public Point pointAt(TableCell cell) {
        return this.driver.pointAt((JTable)this.target, cell);
    }

    public String[][] contents() {
        return this.driver.contents((JTable)this.target);
    }

    public int rowCount() {
        return this.driver.rowCountOf((JTable)this.target);
    }

    public String valueAt(TableCell cell) {
        return this.driver.value((JTable)this.target, cell);
    }

    public JTableFixture selectCell(TableCell cell) {
        this.driver.selectCell((JTable)this.target, cell);
        return this;
    }

    public JTableFixture selectCells(TableCell ... cells) {
        this.driver.selectCells((JTable)this.target, cells);
        return this;
    }

    public JTableFixture drag(TableCell cell) {
        this.driver.drag((JTable)this.target, cell);
        return this;
    }

    public JTableFixture drop(TableCell cell) {
        this.driver.drop((JTable)this.target, cell);
        return this;
    }

    @Override
    public JTableFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public JTableFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public JTableFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    public JTableFixture click(TableCell cell, MouseButton button) {
        this.click(cell, button, 1);
        return this;
    }

    public JTableFixture click(TableCell cell, MouseClickInfo mouseClickInfo) {
        if (mouseClickInfo == null) {
            throw new NullPointerException("The given MouseClickInfo should not be null");
        }
        this.click(cell, mouseClickInfo.button(), mouseClickInfo.times());
        return this;
    }

    void click(TableCell cell, MouseButton button, int times) {
        this.driver.click((JTable)this.target, cell, button, times);
    }

    @Override
    public JTableFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public JTableFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    @Override
    public JTableFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public JTableFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public JTableFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public JTableFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    @Override
    public JTableFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    public JPopupMenuFixture showPopupMenuAt(TableCell cell) {
        return new JPopupMenuFixture(this.robot, this.driver.showPopupMenuAt((JTable)this.target, cell));
    }

    public JTableFixture enterValue(TableCell cell, String value) {
        this.driver.enterValueInCell((JTable)this.target, cell, value);
        return this;
    }

    public JTableFixture cellReader(JTableCellReader cellReader) {
        this.driver.cellReader(cellReader);
        return this;
    }

    public JTableFixture requireRowCount(int expected) {
        this.driver.requireRowCount((JTable)this.target, expected);
        return this;
    }

    public JTableFixture requireColumnCount(int expected) {
        this.driver.requireColumnCount((JTable)this.target, expected);
        return this;
    }

    @Override
    public JTableFixture requireFocused() {
        this.driver.requireFocused(this.target);
        return this;
    }

    @Override
    public JTableFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public JTableFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public JTableFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public JTableFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public JTableFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }

    public JTableFixture requireEditable(TableCell cell) {
        this.driver.requireEditable((JTable)this.target, cell);
        return this;
    }

    public JTableFixture requireNotEditable(TableCell cell) {
        this.driver.requireNotEditable((JTable)this.target, cell);
        return this;
    }

    public JTableFixture requireNoSelection() {
        this.driver.requireNoSelection((JTable)this.target);
        return this;
    }

    public JTableFixture requireCellValue(TableCell cell, String value) {
        this.driver.requireCellValue((JTable)this.target, cell, value);
        return this;
    }

    public void requireContents(String[][] contents) {
        this.driver.requireContents((JTable)this.target, contents);
    }

    public JTableFixture cellWriter(JTableCellWriter cellWriter) {
        this.driver.cellWriter(cellWriter);
        return this;
    }

    public int columnIndexFor(Object columnName) {
        return this.driver.columnIndex((JTable)this.target, columnName);
    }
}

