/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.fixture.ItemFixture;
import org.fest.swing.fixture.JListFixture;
import org.fest.swing.fixture.JPopupMenuFixture;

public class JListItemFixture
implements ItemFixture {
    final JListFixture list;
    final int index;

    public JListItemFixture(JListFixture list, int index) {
        if (list == null) {
            throw new NullPointerException("The given JListFixture should not be null");
        }
        this.list = list;
        this.index = index;
    }

    public final JListItemFixture select() {
        return this.click();
    }

    public final JListItemFixture click() {
        this.list.selectItem(this.index);
        return this;
    }

    public final JListItemFixture click(MouseButton button) {
        this.list.clickItem(this.index, button, 1);
        return this;
    }

    public final JListItemFixture click(MouseClickInfo mouseClickInfo) {
        this.list.clickItem(this.index, mouseClickInfo.button(), mouseClickInfo.times());
        return this;
    }

    public final JListItemFixture doubleClick() {
        this.list.doubleClickItem(this.index);
        return this;
    }

    public final JListItemFixture rightClick() {
        this.list.clickItem(this.index, MouseButton.RIGHT_BUTTON, 1);
        return this;
    }

    public final JPopupMenuFixture showPopupMenu() {
        return this.list.showPopupMenuAt(this.index);
    }

    public final String value() {
        return this.list.valueAt(this.index);
    }

    public final JListItemFixture drag() {
        this.list.drag(this.index);
        return this;
    }

    public final JListItemFixture drop() {
        this.list.drop(this.index);
        return this;
    }

    public final int index() {
        return this.index;
    }
}

