/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.fest.swing.core.Robot;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;

public final class Scrolling {
    public static void scrollToVisible(Robot robot, JComponent c) {
        JComponent root = Scrolling.findClosestValidatingRootAncestor(c);
        while (root != null) {
            Scrolling.scrollToVisible(robot, root, c);
            root = Scrolling.findClosestValidatingRootAncestor(root);
        }
    }

    protected static JComponent findClosestValidatingRootAncestor(JComponent c) {
        Container root = c;
        while (root != null) {
            Container parent = root.getParent();
            if (!((root = parent) instanceof JComponent) || !(root instanceof JViewport) && !(root instanceof JInternalFrame)) continue;
            return root;
        }
        return null;
    }

    protected static void scrollToVisible(Robot robot, JComponent container, Component target) {
        Rectangle r = SwingUtilities.convertRectangle(target.getParent(), target.getBounds(), container);
        Scrolling.scrollToVisible(robot, container, r);
    }

    protected static void scrollToVisible(Robot robot, final JComponent c, final Rectangle rectangle) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                c.scrollRectToVisible(rectangle);
            }
        });
        robot.waitForIdle();
    }

    private Scrolling() {
    }
}

