/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JTreePathFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.Collections;

final class JTreeMatchingPathQuery {
    @RunsInEDT
    static TreePath findVisibleMatchingPath(final JTree tree, final String path, final JTreePathFinder pathFinder) {
        return GuiActionRunner.execute(new GuiQuery<TreePath>(){

            @Override
            protected TreePath executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(tree);
                TreePath findMatchingPath = pathFinder.findMatchingPath(tree, path);
                return JTreeMatchingPathQuery.addRootIfInvisible(tree, findMatchingPath);
            }
        });
    }

    @RunsInCurrentThread
    static TreePath addRootIfInvisible(JTree tree, TreePath path) {
        if (path == null) {
            return path;
        }
        Object root = tree.getModel().getRoot();
        if (tree.isRootVisible() || root == null) {
            return path;
        }
        if (path.getPathCount() > 0 && root == path.getPathComponent(0)) {
            return path;
        }
        List newPath = Collections.list((Object[])path.getPath());
        newPath.add(0, root);
        return new TreePath(newPath.toArray());
    }

    @RunsInEDT
    static TreePath matchingPathFor(final JTree tree, final String path, final JTreePathFinder pathFinder) {
        return GuiActionRunner.execute(new GuiQuery<TreePath>(){

            @Override
            protected TreePath executeInEDT() {
                return pathFinder.findMatchingPath(tree, path);
            }
        });
    }

    private JTreeMatchingPathQuery() {
    }
}

