/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;
import org.fest.assertions.Assertions;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JTreeCellReader;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.CommonValidations;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JTreeChildrenShowUpCondition;
import org.fest.swing.driver.JTreeEditableQuery;
import org.fest.swing.driver.JTreeExpandPathTask;
import org.fest.swing.driver.JTreeLocation;
import org.fest.swing.driver.JTreeMatchingPathQuery;
import org.fest.swing.driver.JTreePathFinder;
import org.fest.swing.driver.JTreeToggleExpandStateTask;
import org.fest.swing.driver.MultipleSelectionTemplate;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.exception.WaitTimedOutError;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.fest.swing.util.Pair;
import org.fest.util.Arrays;
import org.fest.util.Collections;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTreeDriver
extends JComponentDriver {
    private static final String EDITABLE_PROPERTY = "editable";
    private static final String SELECTION_PROPERTY = "selection";
    private final JTreeLocation location = new JTreeLocation();
    private final JTreePathFinder pathFinder = new JTreePathFinder();

    public JTreeDriver(Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void toggleRow(JTree tree, int row) {
        Pair<Point, Integer> toggleRowInfo = JTreeDriver.toggleRowInfo(tree, row, this.location);
        Point p = (Point)toggleRowInfo.i;
        int toggleClickCount = (Integer)toggleRowInfo.ii;
        if (toggleClickCount == 0) {
            JTreeDriver.toggleRowThroughTreeUI(tree, p);
            this.robot.waitForIdle();
            return;
        }
        this.robot.click(tree, p, MouseButton.LEFT_BUTTON, toggleClickCount);
    }

    @RunsInEDT
    private static Pair<Point, Integer> toggleRowInfo(final JTree tree, final int row, final JTreeLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Point, Integer>>(){

            @Override
            protected Pair<Point, Integer> executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(tree);
                Point p = location.pointAt(tree, row);
                return new Pair<Point, Integer>(p, tree.getToggleClickCount());
            }
        });
    }

    @RunsInEDT
    private static void toggleRowThroughTreeUI(final JTree tree, final Point p) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                TreeUI treeUI = tree.getUI();
                if (!(treeUI instanceof BasicTreeUI)) {
                    throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Can't toggle row for ", treeUI}));
                }
                JTreeToggleExpandStateTask.toggleExpandState(tree, p);
            }
        });
    }

    @RunsInEDT
    public void selectRows(final JTree tree, final int[] rows) {
        if (rows == null) {
            throw new NullPointerException("The array of rows should not be null");
        }
        if (JTreeDriver.isEmptyArray(rows)) {
            throw new IllegalArgumentException("The array of rows should not be empty");
        }
        new MultipleSelectionTemplate(this.robot){

            int elementCount() {
                return rows.length;
            }

            void selectElement(int index) {
                JTreeDriver.this.selectRow(tree, rows[index]);
            }
        }.multiSelect();
    }

    @RunsInEDT
    public void selectRow(JTree tree, int row) {
        this.scrollAndSelectRow(tree, row);
    }

    @RunsInEDT
    public void selectPaths(final JTree tree, final String[] paths) {
        if (paths == null) {
            throw new NullPointerException("The array of paths should not be null");
        }
        if (Arrays.isEmpty((Object[])paths)) {
            throw new IllegalArgumentException("The array of paths should not be empty");
        }
        new MultipleSelectionTemplate(this.robot){

            int elementCount() {
                return paths.length;
            }

            void selectElement(int index) {
                JTreeDriver.this.selectPath(tree, paths[index]);
            }
        }.multiSelect();
    }

    @RunsInEDT
    public void selectPath(JTree tree, String path) {
        this.selectMatchingPath(tree, path);
    }

    @RunsInEDT
    public JPopupMenu showPopupMenu(JTree tree, int row) {
        return this.robot.showPopupMenu(tree, JTreeDriver.validateAndFindPointAtRow(tree, row, this.location));
    }

    @RunsInEDT
    private static Point validateAndFindPointAtRow(final JTree tree, final int row, final JTreeLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(tree);
                return location.pointAt(tree, row);
            }
        });
    }

    @RunsInEDT
    public JPopupMenu showPopupMenu(JTree tree, String path) {
        TreePath matchingPath = JTreeMatchingPathQuery.findVisibleMatchingPath(tree, path, this.pathFinder);
        matchingPath = JTreeDriver.addRootIfInvisible(tree, matchingPath);
        this.makeVisible(tree, matchingPath, false);
        return this.robot.showPopupMenu(tree, JTreeDriver.pointAtPath(tree, matchingPath, this.location));
    }

    @RunsInEDT
    private static Point pointAtPath(final JTree tree, final TreePath path, final JTreeLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                return location.pointAt(tree, path);
            }
        });
    }

    @RunsInEDT
    public void drag(JTree tree, int row) {
        Point p = this.scrollAndSelectRow(tree, row);
        this.drag((Component)tree, p);
    }

    @RunsInEDT
    private Point scrollAndSelectRow(JTree tree, int row) {
        Point p = JTreeDriver.scrollToRowToSelect(tree, row, this.location);
        this.robot.click((Component)tree, p);
        return p;
    }

    @RunsInEDT
    private static Point scrollToRowToSelect(final JTree tree, final int row, final JTreeLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(tree);
                Rectangle rowBounds = tree.getRowBounds(location.validIndex(tree, row));
                tree.scrollRectToVisible(rowBounds);
                return new Point(rowBounds.x + 1, rowBounds.y + rowBounds.height / 2);
            }
        });
    }

    @RunsInEDT
    public void drop(JTree tree, int row) {
        this.drop((Component)tree, JTreeDriver.scrollToRow(tree, row, this.location));
    }

    @RunsInEDT
    private static Point scrollToRow(final JTree tree, final int row, final JTreeLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(tree);
                tree.scrollRectToVisible(tree.getRowBounds(row));
                return location.pointAt(tree, row);
            }
        });
    }

    @RunsInEDT
    public void drag(JTree tree, String path) {
        Point p = this.selectMatchingPath(tree, path);
        this.drag((Component)tree, p);
    }

    @RunsInEDT
    private Point selectMatchingPath(JTree tree, String path) {
        TreePath matchingPath = JTreeMatchingPathQuery.findVisibleMatchingPath(tree, path, this.pathFinder);
        matchingPath = JTreeDriver.addRootIfInvisible(tree, matchingPath);
        this.makeVisible(tree, matchingPath, false);
        Point p = JTreeDriver.scrollToPathToSelect(tree, matchingPath, this.location);
        this.robot.click((Component)tree, p);
        return p;
    }

    @RunsInEDT
    private static TreePath addRootIfInvisible(final JTree tree, final TreePath path) {
        return GuiActionRunner.execute(new GuiQuery<TreePath>(){

            @Override
            protected TreePath executeInEDT() {
                Object first;
                if (tree.isRootVisible()) {
                    return path;
                }
                Object root = tree.getModel().getRoot();
                if (path.getPathCount() > 0 && root == (first = path.getPathComponent(0))) {
                    return path;
                }
                List newPath = Collections.list((Object[])path.getPath());
                newPath.add(0, root);
                return new TreePath(newPath.toArray());
            }
        });
    }

    @RunsInEDT
    private static Point scrollToPathToSelect(final JTree tree, final TreePath path, JTreeLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                Rectangle pathBounds = tree.getPathBounds(path);
                tree.scrollRectToVisible(pathBounds);
                return new Point(pathBounds.x + 1, pathBounds.y + pathBounds.height / 2);
            }
        });
    }

    @RunsInEDT
    public void drop(JTree tree, String path) {
        Point p = JTreeDriver.scrollToMatchingPath(tree, path, this.pathFinder, this.location);
        this.drop((Component)tree, p);
    }

    @RunsInEDT
    private static Point scrollToMatchingPath(final JTree tree, final String path, final JTreePathFinder pathFinder, final JTreeLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(tree);
                TreePath matchingPath = pathFinder.findMatchingPath(tree, path);
                tree.scrollRectToVisible(tree.getPathBounds(matchingPath));
                return location.pointAt(tree, matchingPath);
            }
        });
    }

    @RunsInEDT
    private boolean makeVisible(JTree tree, TreePath path, boolean expandWhenFound) {
        boolean changed = false;
        if (path.getPathCount() > 1) {
            changed = this.makeParentVisible(tree, path);
        }
        if (!expandWhenFound) {
            return changed;
        }
        JTreeExpandPathTask.expandPath(tree, path);
        this.waitForChildrenToShowUp(tree, path);
        return true;
    }

    @RunsInEDT
    private boolean makeParentVisible(JTree tree, TreePath path) {
        boolean changed = this.makeVisible(tree, path.getParentPath(), true);
        if (changed) {
            this.robot.waitForIdle();
        }
        return changed;
    }

    @RunsInEDT
    private void waitForChildrenToShowUp(JTree tree, TreePath path) {
        int timeout = this.robot.settings().timeoutToBeVisible();
        try {
            Pause.pause((Condition)JTreeChildrenShowUpCondition.untilChildrenShowUp(tree, path), (long)timeout);
        }
        catch (WaitTimedOutError e) {
            throw new LocationUnavailableException(e.getMessage());
        }
    }

    @RunsInEDT
    public void requireSelection(JTree tree, int[] rows) {
        if (rows == null) {
            throw new NullPointerException("The array of row indices should not be null");
        }
        JTreeDriver.requireSelection(tree, rows, this.pathFinder, this.selectionProperty(tree));
    }

    @RunsInEDT
    private static void requireSelection(final JTree tree, final int[] rows, final JTreePathFinder pathFinder, final Description errorMessage) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                JTreeDriver.assertHasSelection(tree, rows, pathFinder, errorMessage);
            }
        });
    }

    @RunsInCurrentThread
    private static void assertHasSelection(JTree tree, int[] rows, JTreePathFinder pathFinder, Description errorMessage) {
        int[] selectionRows = tree.getSelectionRows();
        if (JTreeDriver.isEmptyArray(selectionRows)) {
            JTreeDriver.failNoSelection(errorMessage);
        }
        int rowCount = rows.length;
        for (int i = 0; i < rowCount; ++i) {
            JTreeDriver.assertHasSelection(rows[i], selectionRows, errorMessage);
        }
    }

    private static boolean isEmptyArray(int[] array) {
        return array == null || array.length == 0;
    }

    @RunsInEDT
    private static void assertHasSelection(int row, int[] selectionRows, Description errorMessage) {
        Assertions.assertThat((int[])selectionRows).as(errorMessage).contains(new int[]{row});
    }

    @RunsInEDT
    public void requireSelection(JTree tree, String[] paths) {
        if (paths == null) {
            throw new NullPointerException("The array of paths should not be null");
        }
        JTreeDriver.requireSelection(tree, paths, this.pathFinder, this.selectionProperty(tree));
    }

    @RunsInEDT
    private static void requireSelection(final JTree tree, final String[] paths, final JTreePathFinder pathFinder, final Description errorMessage) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                JTreeDriver.assertHasSelection(tree, paths, pathFinder, errorMessage);
            }
        });
    }

    @RunsInCurrentThread
    private static void assertHasSelection(JTree tree, String[] paths, JTreePathFinder pathFinder, Description errorMessage) {
        Object[] selectionPaths = tree.getSelectionPaths();
        if (Arrays.isEmpty((Object[])selectionPaths)) {
            JTreeDriver.failNoSelection(errorMessage);
        }
        int pathCount = paths.length;
        for (int i = 0; i < pathCount; ++i) {
            JTreeDriver.assertHasSelection(JTreeMatchingPathQuery.matchingPathFor(tree, paths[i], pathFinder), (TreePath[])selectionPaths, errorMessage);
        }
    }

    private static void failNoSelection(Description errorMessage) {
        Fail.fail((String)Strings.concat((Object[])new Object[]{"[", errorMessage.value(), "] No selection"}));
    }

    @RunsInEDT
    private static void assertHasSelection(TreePath path, TreePath[] selectionPaths, Description errorMessage) {
        Assertions.assertThat((Object[])selectionPaths).as(errorMessage).contains(new Object[]{path});
    }

    @RunsInEDT
    public void requireNoSelection(JTree tree) {
        JTreeDriver.assertNoSelection(tree, this.selectionProperty(tree));
    }

    @RunsInEDT
    private static void assertNoSelection(final JTree tree, final Description errorMessage) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                if (tree.getSelectionCount() == 0) {
                    return;
                }
                String message = Strings.concat((Object[])new Object[]{"[", errorMessage.value(), "] expected no selection but was:<", Arrays.format((Object)tree.getSelectionPaths()), ">"});
                Fail.fail((String)message);
            }
        });
    }

    @RunsInEDT
    private Description selectionProperty(JTree tree) {
        return JTreeDriver.propertyName(tree, SELECTION_PROPERTY);
    }

    @RunsInEDT
    public void requireEditable(JTree tree) {
        this.assertEditable(tree, true);
    }

    @RunsInEDT
    public void requireNotEditable(JTree tree) {
        this.assertEditable(tree, false);
    }

    @RunsInEDT
    private void assertEditable(JTree tree, boolean editable) {
        Assertions.assertThat((boolean)JTreeEditableQuery.isEditable(tree)).as(JTreeDriver.editableProperty(tree)).isEqualTo(editable);
    }

    @RunsInEDT
    private static Description editableProperty(JTree tree) {
        return JTreeDriver.propertyName(tree, EDITABLE_PROPERTY);
    }

    public String separator() {
        return this.pathFinder.separator();
    }

    public void separator(String newSeparator) {
        if (newSeparator == null) {
            throw new NullPointerException("The path separator should not be null");
        }
        this.pathFinder.separator(newSeparator);
    }

    public void cellReader(JTreeCellReader newCellReader) {
        CommonValidations.validateCellReader(newCellReader);
        this.pathFinder.cellReader(newCellReader);
    }
}

