/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JTabbedPane;
import org.fest.assertions.Assertions;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.data.Index;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JTabbedPaneLocation;
import org.fest.swing.driver.JTabbedPaneSelectTabTask;
import org.fest.swing.driver.JTabbedPaneTabTitlesQuery;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTabbedPaneDriver
extends JComponentDriver {
    private final JTabbedPaneLocation location;

    public JTabbedPaneDriver(Robot robot) {
        this(robot, new JTabbedPaneLocation());
    }

    JTabbedPaneDriver(Robot robot, JTabbedPaneLocation location) {
        super(robot);
        this.location = location;
    }

    @RunsInEDT
    public String[] tabTitles(JTabbedPane tabbedPane) {
        return JTabbedPaneTabTitlesQuery.tabTitlesOf(tabbedPane);
    }

    @RunsInEDT
    public void selectTab(JTabbedPane tabbedPane, String title) {
        Pair<Integer, Point> tabToSelectInfo = JTabbedPaneDriver.tabToSelectInfo(this.location, tabbedPane, title);
        Point target = (Point)tabToSelectInfo.ii;
        if (target != null) {
            this.click((Component)tabbedPane, target);
            return;
        }
        this.setTabDirectly(tabbedPane, (Integer)tabToSelectInfo.i);
    }

    @RunsInEDT
    private static Pair<Integer, Point> tabToSelectInfo(final JTabbedPaneLocation location, final JTabbedPane tabbedPane, final String title) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Integer, Point>>(){

            @Override
            protected Pair<Integer, Point> executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(tabbedPane);
                int index = location.indexOf(tabbedPane, title);
                Point point = null;
                try {
                    point = location.pointAt(tabbedPane, index);
                }
                catch (LocationUnavailableException locationUnavailableException) {
                    // empty catch block
                }
                return new Pair<Integer, Point>(index, point);
            }
        });
    }

    public void selectTab(JTabbedPane tabbedPane, int index) {
        try {
            Point p = JTabbedPaneDriver.pointAt(this.location, tabbedPane, index);
            this.click((Component)tabbedPane, p);
        }
        catch (LocationUnavailableException e) {
            this.setTabDirectly(tabbedPane, index);
        }
    }

    @RunsInEDT
    private static Point pointAt(final JTabbedPaneLocation location, final JTabbedPane tabbedPane, final int index) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(tabbedPane);
                return location.pointAt(tabbedPane, index);
            }
        });
    }

    @RunsInEDT
    void setTabDirectly(JTabbedPane tabbedPane, int index) {
        JTabbedPaneSelectTabTask.setSelectedTab(tabbedPane, index);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public Component selectedComponentOf(JTabbedPane tabbedPane) {
        return JTabbedPaneDriver.selectedComponent(tabbedPane);
    }

    @RunsInEDT
    private static Component selectedComponent(final JTabbedPane tabbedPane) {
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            protected Component executeInEDT() {
                return tabbedPane.getSelectedComponent();
            }
        });
    }

    @RunsInEDT
    public void requireTabTitle(JTabbedPane tabbedPane, String title, Index index) {
        String actualTitle = JTabbedPaneDriver.titleAt(tabbedPane, index);
        Assertions.assertThat((String)actualTitle).as(JTabbedPaneDriver.propertyName(tabbedPane, "titleAt")).isEqualTo(title);
    }

    @RunsInEDT
    private static String titleAt(final JTabbedPane tabbedPane, final Index index) {
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                return tabbedPane.getTitleAt(index.value);
            }
        });
    }

    @RunsInEDT
    public void requireTabTitles(JTabbedPane tabbedPane, String[] titles) {
        Object[] actualTitles = JTabbedPaneDriver.allTabTitlesIn(tabbedPane);
        Assertions.assertThat((Object[])actualTitles).as(JTabbedPaneDriver.propertyName(tabbedPane, "tabTitles")).isEqualTo((Object[])titles);
    }

    @RunsInEDT
    private static String[] allTabTitlesIn(final JTabbedPane tabbedPane) {
        return GuiActionRunner.execute(new GuiQuery<String[]>(){

            @Override
            protected String[] executeInEDT() {
                ArrayList<String> allTitles = new ArrayList<String>();
                int tabCount = tabbedPane.getTabCount();
                for (int i = 0; i < tabCount; ++i) {
                    allTitles.add(tabbedPane.getTitleAt(i));
                }
                return allTitles.toArray(new String[allTitles.size()]);
            }
        });
    }
}

