/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JList;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.util.Strings;

final class JListItemIndexValidator {
    @RunsInCurrentThread
    static void validateIndex(JList list, int index) {
        int itemCount = list.getModel().getSize();
        if (index >= 0 && index < itemCount) {
            return;
        }
        throw new IndexOutOfBoundsException(Strings.concat((Object[])new Object[]{"Item index (", String.valueOf(index), ") should be between [", String.valueOf(0), "] and [", String.valueOf(itemCount - 1), "] (inclusive)"}));
    }

    private JListItemIndexValidator() {
    }
}

