/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.AbstractButton;
import org.fest.assertions.Assertions;
import org.fest.assertions.Description;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.AbstractButtonSelectedQuery;
import org.fest.swing.driver.AbstractButtonTextQuery;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;

public class AbstractButtonDriver
extends JComponentDriver {
    private static final String SELECTED_PROPERTY = "selected";
    private static final String TEXT_PROPERTY = "text";

    public AbstractButtonDriver(Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void requireText(AbstractButton button, String expected) {
        Assertions.assertThat((String)this.textOf(button)).as(AbstractButtonDriver.propertyName(button, TEXT_PROPERTY)).isEqualTo(expected);
    }

    @RunsInEDT
    public String textOf(AbstractButton button) {
        return AbstractButtonTextQuery.textOf(button);
    }

    @RunsInEDT
    public void select(AbstractButton button) {
        if (AbstractButtonDriver.validateAndFindIsSelected(button)) {
            return;
        }
        this.robot.click(button);
    }

    @RunsInEDT
    public void unselect(AbstractButton button) {
        if (!AbstractButtonDriver.validateAndFindIsSelected(button)) {
            return;
        }
        this.robot.click(button);
    }

    @RunsInEDT
    private static boolean validateAndFindIsSelected(final AbstractButton button) {
        return GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(button);
                return button.isSelected();
            }
        });
    }

    @RunsInEDT
    public void requireSelected(AbstractButton button) {
        this.assertThatButtonIsSelected(button, true);
    }

    @RunsInEDT
    public void requireNotSelected(AbstractButton button) {
        this.assertThatButtonIsSelected(button, false);
    }

    @RunsInEDT
    private void assertThatButtonIsSelected(AbstractButton button, boolean selected) {
        Assertions.assertThat((boolean)AbstractButtonSelectedQuery.isSelected(button)).as(AbstractButtonDriver.selectedProperty(button)).isEqualTo(selected);
    }

    @RunsInEDT
    private static Description selectedProperty(AbstractButton button) {
        return AbstractButtonDriver.propertyName(button, SELECTED_PROPERTY);
    }
}

