/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.Iterator;
import org.fest.reflect.core.Reflection;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.hierarchy.ExistingHierarchy;

public final class FocusOwnerFinder {
    @RunsInEDT
    public static Component inEdtFocusOwner() {
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            protected Component executeInEDT() {
                return FocusOwnerFinder.focusOwner();
            }
        });
    }

    @RunsInCurrentThread
    public static Component focusOwner() {
        try {
            return (Component)Reflection.staticField((String)"focusOwner").ofType(Component.class).in(KeyboardFocusManager.class).get();
        }
        catch (Exception e) {
            return FocusOwnerFinder.focusOwnerInHierarchy();
        }
    }

    @RunsInCurrentThread
    static Component focusOwnerInHierarchy() {
        Window w;
        Container c;
        Component focus = null;
        Iterator<? extends Container> i$ = new ExistingHierarchy().roots().iterator();
        while (!(!i$.hasNext() || (c = i$.next()) instanceof Window && (w = (Window)c).isShowing() && (focus = FocusOwnerFinder.focusOwner(w)) != null)) {
        }
        return focus;
    }

    @RunsInCurrentThread
    private static Component focusOwner(Window w) {
        Component focus = w.getFocusOwner();
        if (focus != null) {
            return focus;
        }
        for (Window owndedWindow : w.getOwnedWindows()) {
            focus = owndedWindow.getFocusOwner();
            if (focus == null) continue;
            return focus;
        }
        return focus;
    }

    private FocusOwnerFinder() {
    }
}

