/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.applet;

import java.applet.Applet;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.applet.BasicAppletContext;
import org.fest.swing.applet.BasicAppletStub;
import org.fest.swing.applet.StatusDisplay;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppletViewer
extends JFrame
implements StatusDisplay {
    private static final long serialVersionUID = 1L;
    private static final String APPLET_VIEWER_TITLE = "Applet Viewer: ";
    private static final String APPLET_LOADED_MESSAGE = "Applet loaded";
    private static final Dimension DEFAULT_SIZE = new Dimension(100, 100);
    private final JLabel statusLabel = new JLabel();
    private Applet applet;
    private transient AppletStub stub;
    private boolean loaded;

    @RunsInCurrentThread
    public AppletViewer(Applet applet) {
        this.load(applet, new BasicAppletStub(this, new BasicAppletContext(this)));
    }

    @RunsInCurrentThread
    public AppletViewer(Applet applet, Map<String, String> parameters) {
        this.load(applet, new BasicAppletStub(this, new BasicAppletContext(this), parameters));
    }

    @RunsInCurrentThread
    public AppletViewer(Applet applet, AppletStub stub) {
        this.load(applet, stub);
    }

    private void load(Applet newApplet, AppletStub newStub) {
        this.applet = AppletViewer.validated(newApplet);
        this.stub = AppletViewer.validated(newStub);
        this.setUpFrame();
        this.addContent();
        this.setUpApplet();
    }

    private static Applet validated(Applet applet) {
        if (applet == null) {
            throw new NullPointerException("The applet to load should not be null");
        }
        return applet;
    }

    private static AppletStub validated(AppletStub stub) {
        if (stub == null) {
            throw new NullPointerException("The AppletStub should not be null");
        }
        return stub;
    }

    private void setUpFrame() {
        this.setTitle(Strings.concat((Object[])new Object[]{APPLET_VIEWER_TITLE, this.applet.getClass().getName()}));
        this.setSize(DEFAULT_SIZE);
        this.setLayout(new BorderLayout());
    }

    private void addContent() {
        this.add((Component)this.applet, "Center");
        this.statusLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.statusLabel.setName("status");
        this.add((Component)this.statusLabel, "South");
    }

    private void setUpApplet() {
        this.applet.setStub(this.stub);
        this.reloadApplet();
        this.showStatus(APPLET_LOADED_MESSAGE);
    }

    public void reloadApplet() {
        if (this.loaded) {
            this.unloadApplet();
        }
        this.applet.init();
        this.applet.start();
        this.loaded = true;
    }

    public void unloadApplet() {
        this.applet.stop();
        this.applet.destroy();
        this.loaded = false;
    }

    public boolean appletLoaded() {
        return this.loaded;
    }

    @Override
    public void showStatus(String status) {
        this.statusLabel.setText(status);
    }

    public Applet applet() {
        return this.applet;
    }

    public AppletStub stub() {
        return this.stub;
    }
}

