/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Assert;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.assertions.Formatting;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GenericAssert<T>
extends Assert {
    final T actual;

    GenericAssert(T actual) {
        this.actual = actual;
    }

    public final void isNull() {
        Fail.failIfNotNull(this.description(), this.actual);
    }

    abstract GenericAssert<T> satisfies(Condition<T> var1);

    abstract GenericAssert<T> doesNotSatisfy(Condition<T> var1);

    abstract GenericAssert<T> as(String var1);

    abstract GenericAssert<T> describedAs(String var1);

    abstract GenericAssert<T> as(Description var1);

    abstract GenericAssert<T> describedAs(Description var1);

    abstract GenericAssert<T> isEqualTo(T var1);

    abstract GenericAssert<T> isNotEqualTo(T var1);

    abstract GenericAssert<T> isNotNull();

    abstract GenericAssert<T> isSameAs(T var1);

    abstract GenericAssert<T> isNotSameAs(T var1);

    final void assertSatisfies(Condition<T> condition) {
        this.validate(condition);
        if (condition.matches(this.actual)) {
            return;
        }
        this.fail(this.errorMessageIfConditionNotSatisfied(condition));
    }

    private String errorMessageIfConditionNotSatisfied(Condition<T> condition) {
        String message = Strings.concat((Object[])new Object[]{"actual value:", Formatting.inBrackets(this.actual), " should satisfy condition"});
        return condition.addDescriptionTo(message);
    }

    final void assertDoesNotSatisfy(Condition<T> condition) {
        this.validate(condition);
        if (!condition.matches(this.actual)) {
            return;
        }
        this.fail(this.errorMessageIfConditionSatisfied(condition));
    }

    private String errorMessageIfConditionSatisfied(Condition<T> condition) {
        String message = Strings.concat((Object[])new Object[]{"actual value:", Formatting.inBrackets(this.actual), " should not satisfy condition"});
        return condition.addDescriptionTo(message);
    }

    private void validate(Condition<T> condition) {
        if (condition == null) {
            throw new IllegalArgumentException("Condition to check should be null");
        }
    }

    final void assertEqualTo(T expected) {
        Fail.failIfNotEqual(this.description(), this.actual, expected);
    }

    final void assertNotEqualTo(T obj) {
        Fail.failIfEqual(this.description(), this.actual, obj);
    }

    final void assertNotNull() {
        Fail.failIfNull(this.description(), this.actual);
    }

    final void assertSameAs(T expected) {
        Fail.failIfNotSame(this.description(), this.actual, expected);
    }

    final void assertNotSameAs(T expected) {
        Fail.failIfSame(this.description(), this.actual, expected);
    }

    final void fail(String reason) {
        Fail.fail(this.formatted(reason));
    }

    final void fail(String reason, Throwable cause) {
        Fail.fail(this.formatted(reason), cause);
    }

    private String formatted(String reason) {
        return Strings.concat((Object[])new Object[]{Formatting.format(this.description()), reason});
    }
}

