/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.type;

import org.fest.reflect.type.TypeLoader;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Type {
    private final String name;

    public Type(String name) {
        if (name == null) {
            throw new NullPointerException("The name of the class to load should not be null");
        }
        if (Strings.isEmpty((String)name)) {
            throw new IllegalArgumentException("The name of the class to load should not be empty");
        }
        this.name = name;
    }

    public Class<?> load() {
        return new TypeLoader(this.name, this.thisClassLoader()).load();
    }

    public <T> Class<? extends T> loadAs(Class<T> type) {
        return new TypeLoader(this.name, this.thisClassLoader()).loadAs(type);
    }

    private ClassLoader thisClassLoader() {
        return this.getClass().getClassLoader();
    }

    public TypeLoader withClassLoader(ClassLoader classLoader) {
        return new TypeLoader(this.name, classLoader);
    }
}

