/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import livegps.LiveGpsAcquirer;
import livegps.LiveGpsDialog;
import livegps.LiveGpsLayer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class LiveGpsPlugin
extends Plugin {
    private LiveGpsAcquirer acquirer = null;
    private Thread acquirerThread = null;
    private JMenu lgpsmenu;
    private JCheckBoxMenuItem lgpscapture;
    private JMenuItem lgpscenter;
    private JCheckBoxMenuItem lgpsautocenter;
    private LiveGpsDialog lgpsdialog;
    List<PropertyChangeListener> listenerQueue;
    private GpxData data = new GpxData();
    private LiveGpsLayer lgpslayer;

    public LiveGpsPlugin() {
        MainMenu menu = Main.main.menu;
        String string = I18n.marktr((String)"LiveGPS");
        menu.getClass();
        this.lgpsmenu = menu.addMenu(string, 71, 5);
        CaptureAction captureAction = new CaptureAction();
        this.lgpscapture = new JCheckBoxMenuItem((Action)((Object)captureAction));
        this.lgpsmenu.add(this.lgpscapture);
        this.lgpscapture.setAccelerator(captureAction.getShortcut().getKeyStroke());
        CenterAction centerAction = new CenterAction();
        JMenuItem centerMenu = new JMenuItem((Action)((Object)centerAction));
        this.lgpsmenu.add(centerMenu);
        centerMenu.setAccelerator(centerAction.getShortcut().getKeyStroke());
        AutoCenterAction autoCenterAction = new AutoCenterAction();
        this.lgpsautocenter = new JCheckBoxMenuItem((Action)((Object)autoCenterAction));
        this.lgpsmenu.add(this.lgpsautocenter);
        this.lgpsautocenter.setAccelerator(autoCenterAction.getShortcut().getKeyStroke());
    }

    public void setAutoCenter(boolean autoCenter) {
        this.lgpsautocenter.setSelected(autoCenter);
        if (this.lgpslayer != null) {
            this.lgpslayer.setAutoCenter(autoCenter);
            if (autoCenter) {
                this.lgpslayer.center();
            }
        }
    }

    public boolean isAutoCenter() {
        return this.lgpsautocenter.isSelected();
    }

    public void enableTracking(boolean enable) {
        if (this.acquirer != null && !enable) {
            this.acquirer.shutdown();
            this.acquirerThread = null;
        } else if (enable) {
            if (this.acquirer == null) {
                this.acquirer = new LiveGpsAcquirer();
                if (this.lgpslayer == null) {
                    this.lgpslayer = new LiveGpsLayer(this.data);
                    Main.main.addLayer((Layer)this.lgpslayer);
                    this.lgpslayer.setAutoCenter(this.isAutoCenter());
                }
                this.addPropertyChangeListener(this.lgpslayer);
                if (this.listenerQueue != null) {
                    for (PropertyChangeListener listener : this.listenerQueue) {
                        this.addPropertyChangeListener(listener);
                    }
                    this.listenerQueue.clear();
                }
            }
            if (this.acquirerThread == null) {
                this.acquirerThread = new Thread(this.acquirer);
                this.acquirerThread.start();
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.acquirer != null) {
            this.acquirer.addPropertyChangeListener(listener);
        } else {
            if (this.listenerQueue == null) {
                this.listenerQueue = new ArrayList<PropertyChangeListener>();
            }
            this.listenerQueue.add(listener);
        }
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            this.lgpsdialog = new LiveGpsDialog(newFrame);
            newFrame.addToggleDialog((ToggleDialog)this.lgpsdialog);
            this.addPropertyChangeListener(this.lgpsdialog);
        }
    }

    public JMenu getLgpsMenu() {
        return this.lgpsmenu;
    }

    public class AutoCenterAction
    extends JosmAction {
        public AutoCenterAction() {
            super(I18n.tr((String)"Auto-Center"), "autocentermenu", I18n.tr((String)"Continuously center the LiveGPS layer to current position."), Shortcut.registerShortcut((String)"menu:livegps:autocenter", (String)I18n.tr((String)"Menu: {0}", (Object[])new Object[]{I18n.tr((String)"Capture GPS Track")}), (int)36, (int)2), true);
        }

        public void actionPerformed(ActionEvent e) {
            if (LiveGpsPlugin.this.lgpslayer != null) {
                LiveGpsPlugin.this.setAutoCenter(LiveGpsPlugin.this.lgpsautocenter.isSelected());
            }
        }
    }

    public class CenterAction
    extends JosmAction {
        public CenterAction() {
            super(I18n.tr((String)"Center Once"), "centermenu", I18n.tr((String)"Center the LiveGPS layer to current position."), Shortcut.registerShortcut((String)"edit:centergps", (String)I18n.tr((String)"Edit: {0}", (Object[])new Object[]{I18n.tr((String)"Center Once")}), (int)36, (int)3), true);
        }

        public void actionPerformed(ActionEvent e) {
            if (LiveGpsPlugin.this.lgpslayer != null) {
                LiveGpsPlugin.this.lgpslayer.center();
            }
        }
    }

    public class CaptureAction
    extends JosmAction {
        public CaptureAction() {
            super(I18n.tr((String)"Capture GPS Track"), "capturemenu", I18n.tr((String)"Connect to gpsd server and show current position in LiveGPS layer."), Shortcut.registerShortcut((String)"menu:livegps:capture", (String)I18n.tr((String)"Menu: {0}", (Object[])new Object[]{I18n.tr((String)"Capture GPS Track")}), (int)82, (int)2), true);
        }

        public void actionPerformed(ActionEvent e) {
            LiveGpsPlugin.this.enableTracking(LiveGpsPlugin.this.lgpscapture.isSelected());
        }
    }
}

