/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.io.CacheFiles;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.tools.I18n;
import wmsplugin.GeorefImage;
import wmsplugin.Grabber;
import wmsplugin.HTMLGrabber;
import wmsplugin.Help_WMSmenuAction;
import wmsplugin.Map_Rectifier_WMSmenuAction;
import wmsplugin.WMSAdjustAction;
import wmsplugin.WMSDownloadAction;
import wmsplugin.WMSGrabber;
import wmsplugin.WMSInfo;
import wmsplugin.WMSLayer;
import wmsplugin.WMSPreferenceEditor;

public class WMSPlugin
extends Plugin {
    static CacheFiles cache = new CacheFiles("wmsplugin");
    WMSLayer wmsLayer;
    static JMenu wmsJMenu;
    static ArrayList<WMSInfo> wmsList;
    static TreeMap<String, String> wmsListDefault;
    private static boolean menuEnabled;

    public WMSPlugin() {
        WMSPlugin.refreshMenu();
        cache.setExpire(2419200, false);
        cache.setMaxSize(70, false);
    }

    public void copy(String from, String to) throws FileNotFoundException, IOException {
        File pluginDir = new File(WMSPlugin.getPrefsPath());
        if (!pluginDir.exists()) {
            pluginDir.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(WMSPlugin.getPrefsPath() + to);
        InputStream in = WMSPlugin.class.getResourceAsStream(from);
        byte[] buffer = new byte[8192];
        int len = in.read(buffer);
        while (len > 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        in.close();
        out.close();
    }

    public static void refreshMenu() {
        wmsList.clear();
        Map prefs = Main.pref.getAllPrefix("wmsplugin.url.");
        TreeSet keys = new TreeSet(prefs.keySet());
        int prefid = 0;
        String name = null;
        String url = null;
        String cookies = "";
        int lastid = -1;
        for (String key : keys) {
            String[] elements = key.split("\\.");
            if (elements.length != 4) continue;
            try {
                prefid = Integer.parseInt(elements[2]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (prefid != lastid) {
                url = null;
                name = null;
                lastid = prefid;
            }
            if (elements[3].equals("name")) {
                name = (String)prefs.get(key);
            } else if (elements[3].equals("url")) {
                if (!((String)prefs.get(key)).startsWith("yahoo:")) {
                    url = (String)prefs.get(key);
                }
            } else if (elements[3].equals("cookies")) {
                cookies = (String)prefs.get(key);
            }
            if (name == null || url == null) continue;
            wmsList.add(new WMSInfo(name, url, cookies, prefid));
        }
        String source = "http://svn.openstreetmap.org/applications/editors/josm/plugins/wmsplugin/sources.cfg";
        try {
            String line;
            InputStreamReader r;
            MirroredInputStream s = new MirroredInputStream(source, Main.pref.getPreferencesDir() + "plugins/wmsplugin/", -1L);
            try {
                r = new InputStreamReader((InputStream)s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                r = new InputStreamReader((InputStream)s);
            }
            BufferedReader reader = new BufferedReader(r);
            while ((line = reader.readLine()) != null) {
                String[] val = line.split(";");
                if (line.startsWith("#") || val.length != 3) continue;
                WMSPlugin.setDefault("true".equals(val[0]), I18n.tr((String)val[1]), val[2]);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        Collections.sort(wmsList);
        MainMenu menu = Main.main.menu;
        if (wmsJMenu == null) {
            String string = I18n.marktr((String)"WMS");
            menu.getClass();
            wmsJMenu = menu.addMenu(string, 87, 5);
        } else {
            wmsJMenu.removeAll();
        }
        for (WMSInfo u : wmsList) {
            wmsJMenu.add(new JMenuItem((Action)((Object)new WMSDownloadAction(u))));
        }
        wmsJMenu.addSeparator();
        wmsJMenu.add(new JMenuItem((Action)((Object)new Map_Rectifier_WMSmenuAction())));
        wmsJMenu.addSeparator();
        wmsJMenu.add(new JMenuItem((Action)new JosmAction(I18n.tr((String)"Blank Layer"), "blankmenu", I18n.tr((String)"Open a blank WMS layer to load data from a file"), null, false){

            public void actionPerformed(ActionEvent ev) {
                Main.main.addLayer((Layer)new WMSLayer());
            }
        }));
        wmsJMenu.addSeparator();
        wmsJMenu.add(new JMenuItem((Action)((Object)new Help_WMSmenuAction())));
        WMSPlugin.setEnabledAll(menuEnabled);
    }

    private static void setDefault(Boolean force, String name, String url) {
        String testurl = url.replaceAll("=", "_");
        wmsListDefault.put(name, url);
        if (force.booleanValue() && !Main.pref.getBoolean("wmsplugin.default." + testurl)) {
            Main.pref.put("wmsplugin.default." + testurl, true);
            int id = -1;
            for (WMSInfo i : wmsList) {
                if (url.equals(i.url)) {
                    return;
                }
                if (i.prefid <= id) continue;
                id = i.prefid;
            }
            WMSInfo newinfo = new WMSInfo(name, url, id + 1);
            newinfo.save();
            wmsList.add(newinfo);
        }
    }

    public static Grabber getGrabber(ProjectionBounds bounds, GeorefImage img, MapView mv, WMSLayer layer) {
        if (layer.baseURL.startsWith("html:")) {
            return new HTMLGrabber(bounds, img, mv, layer, cache);
        }
        return new WMSGrabber(bounds, img, mv, layer, cache);
    }

    private static void setEnabledAll(boolean isEnabled) {
        for (int i = 0; i < wmsJMenu.getItemCount(); ++i) {
            JMenuItem item = wmsJMenu.getItem(i);
            if (item == null) continue;
            item.setEnabled(isEnabled);
        }
        menuEnabled = isEnabled;
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame == null && newFrame != null) {
            WMSPlugin.setEnabledAll(true);
            Main.map.addMapMode(new IconToggleButton((Action)((Object)new WMSAdjustAction(Main.map))));
        } else if (oldFrame != null && newFrame == null) {
            WMSPlugin.setEnabledAll(false);
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new WMSPreferenceEditor();
    }

    public static String getPrefsPath() {
        return Main.pref.getPluginsDirFile().getPath() + "/wmsplugin/";
    }

    static {
        wmsList = new ArrayList();
        wmsListDefault = new TreeMap();
        menuEnabled = false;
    }
}

