/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.OptionPaneUtil;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import wmsplugin.GeorefImage;
import wmsplugin.Grabber;
import wmsplugin.WMSGrabber;
import wmsplugin.WMSPlugin;

public class WMSLayer
extends Layer {
    protected static final Icon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSPlugin.class.getResource("/images/wms_small.png")));
    public int messageNum = 5;
    protected MapView mv;
    protected String resolution;
    protected boolean stopAfterPaint = false;
    protected int ImageSize = 500;
    protected int dax = 10;
    protected int day = 10;
    protected int minZoom = 3;
    protected double dx = 0.0;
    protected double dy = 0.0;
    protected double pixelPerDegree;
    protected GeorefImage[][] images = new GeorefImage[this.dax][this.day];
    JCheckBoxMenuItem startstop = new JCheckBoxMenuItem(I18n.tr((String)"Automatic downloading"), true);
    protected JCheckBoxMenuItem alphaChannel = new JCheckBoxMenuItem(new ToggleAlphaAction());
    protected String baseURL;
    protected String cookies;
    protected final int serializeFormatVersion = 4;
    private ExecutorService executor = null;

    public WMSLayer() {
        this(I18n.tr((String)"Blank Layer"), null, null);
        this.initializeImages();
        this.mv = Main.map.mapView;
    }

    public WMSLayer(String name, String baseURL, String cookies) {
        super(name);
        this.alphaChannel.setSelected(Main.pref.getBoolean("wmsplugin.alpha_channel"));
        this.background = true;
        this.initializeImages();
        this.baseURL = baseURL;
        this.cookies = cookies;
        WMSGrabber.getProjection(baseURL, true);
        this.mv = Main.map.mapView;
        this.resolution = this.mv.getDist100PixelText();
        this.pixelPerDegree = this.getPPD();
        this.executor = Executors.newFixedThreadPool(3);
    }

    public void destroy() {
        try {
            this.executor.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public double getPPD() {
        ProjectionBounds bounds = this.mv.getProjectionBounds();
        return (double)this.mv.getWidth() / (bounds.max.east() - bounds.min.east());
    }

    public void initializeImages() {
        this.images = new GeorefImage[this.dax][this.day];
        for (int x = 0; x < this.dax; ++x) {
            for (int y = 0; y < this.day; ++y) {
                this.images[x][y] = new GeorefImage(false);
            }
        }
    }

    public Icon getIcon() {
        return icon;
    }

    public String getToolTipText() {
        if (this.startstop.isSelected()) {
            return I18n.tr((String)"WMS layer ({0}), automatically downloading in zoom {1}", (Object[])new Object[]{this.getName(), this.resolution});
        }
        return I18n.tr((String)"WMS layer ({0}), downloading in zoom {1}", (Object[])new Object[]{this.getName(), this.resolution});
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    private ProjectionBounds XYtoBounds(int x, int y) {
        return new ProjectionBounds(new EastNorth((double)(x * this.ImageSize) / this.pixelPerDegree, (double)(y * this.ImageSize) / this.pixelPerDegree), new EastNorth((double)((x + 1) * this.ImageSize) / this.pixelPerDegree, (double)((y + 1) * this.ImageSize) / this.pixelPerDegree));
    }

    private int modulo(int a, int b) {
        return a % b >= 0 ? a % b : a % b + b;
    }

    public void paint(Graphics g, MapView mv) {
        if (this.baseURL == null) {
            return;
        }
        if (!this.startstop.isSelected() || this.pixelPerDegree / this.getPPD() > (double)this.minZoom) {
            for (int x = 0; x < this.dax; ++x) {
                for (int y = 0; y < this.day; ++y) {
                    this.images[this.modulo(x, this.dax)][this.modulo(y, this.day)].paint(g, (NavigatableComponent)mv, this.dx, this.dy);
                }
            }
        } else {
            this.downloadAndPaintVisible(g, mv);
        }
    }

    public void displace(double dx, double dy) {
        this.dx += dx;
        this.dy += dy;
    }

    protected void downloadAndPaintVisible(Graphics g, MapView mv) {
        ProjectionBounds bounds = mv.getProjectionBounds();
        int bminx = (int)Math.floor(bounds.min.east() * this.pixelPerDegree / (double)this.ImageSize);
        int bminy = (int)Math.floor(bounds.min.north() * this.pixelPerDegree / (double)this.ImageSize);
        int bmaxx = (int)Math.ceil(bounds.max.east() * this.pixelPerDegree / (double)this.ImageSize);
        int bmaxy = (int)Math.ceil(bounds.max.north() * this.pixelPerDegree / (double)this.ImageSize);
        if (bmaxx - bminx > this.dax || bmaxy - bminy > this.day) {
            OptionPaneUtil.showMessageDialog((Component)Main.parent, (Object)I18n.tr((String)"The requested area is too big. Please zoom in a little, or change resolution"), (String)I18n.tr((String)"Error"), (int)0);
            return;
        }
        for (int x = bminx; x < bmaxx; ++x) {
            for (int y = bminy; y < bmaxy; ++y) {
                GeorefImage img = this.images[this.modulo(x, this.dax)][this.modulo(y, this.day)];
                g.drawRect(x, y, this.dax, bminy);
                if (img.paint(g, (NavigatableComponent)mv, this.dx, this.dy) || img.downloadingStarted) continue;
                img.downloadingStarted = true;
                img.image = null;
                img.flushedResizedCachedInstance();
                Grabber gr = WMSPlugin.getGrabber(this.XYtoBounds(x, y), img, mv, this);
                this.executor.submit(gr);
            }
        }
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
        for (int x = 0; x < this.dax; ++x) {
            for (int y = 0; y < this.day; ++y) {
                if (this.images[x][y].image == null) continue;
                v.visit(this.images[x][y].min);
                v.visit(this.images[x][y].max);
            }
        }
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Component[] getMenuEntries() {
        return new Component[]{new JMenuItem((Action)LayerListDialog.getInstance().createShowHideLayerAction((Layer)this)), new JMenuItem((Action)LayerListDialog.getInstance().createDeleteLayerAction((Layer)this)), new JSeparator(), new JMenuItem(new LoadWmsAction()), new JMenuItem(new SaveWmsAction()), new JSeparator(), this.startstop, this.alphaChannel, new JMenuItem(new changeResolutionAction()), new JMenuItem(new reloadErrorTilesAction()), new JMenuItem(new downloadAction()), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
    }

    public GeorefImage findImage(EastNorth eastNorth) {
        for (int x = 0; x < this.dax; ++x) {
            for (int y = 0; y < this.day; ++y) {
                if (this.images[x][y].image == null || this.images[x][y].min == null || this.images[x][y].max == null || !this.images[x][y].contains(eastNorth, this.dx, this.dy)) continue;
                return this.images[x][y];
            }
        }
        return null;
    }

    public class LoadWmsAction
    extends AbstractAction {
        public LoadWmsAction() {
            super(I18n.tr((String)"Load WMS layer from file"), ImageProvider.get((String)"load"));
        }

        public void actionPerformed(ActionEvent ev) {
            JFileChooser fc = DiskAccessAction.createAndOpenFileChooser((boolean)true, (boolean)false, (String)I18n.tr((String)"Load WMS layer"));
            if (fc == null) {
                return;
            }
            File f = fc.getSelectedFile();
            if (f == null) {
                return;
            }
            try {
                FileInputStream fis = new FileInputStream(f);
                ObjectInputStream ois = new ObjectInputStream(fis);
                int sfv = ois.readInt();
                if (sfv != 4) {
                    OptionPaneUtil.showMessageDialog((Component)Main.parent, (Object)I18n.tr((String)"Unsupported WMS file version; found {0}, expected {1}", (Object[])new Object[]{sfv, 4}), (String)I18n.tr((String)"File Format Error"), (int)0);
                    return;
                }
                WMSLayer.this.startstop.setSelected(false);
                WMSLayer.this.dax = ois.readInt();
                WMSLayer.this.day = ois.readInt();
                WMSLayer.this.ImageSize = ois.readInt();
                WMSLayer.this.pixelPerDegree = ois.readDouble();
                WMSLayer.this.setName((String)ois.readObject());
                WMSLayer.this.baseURL = (String)ois.readObject();
                WMSLayer.this.images = (GeorefImage[][])ois.readObject();
                ois.close();
                fis.close();
                WMSLayer.this.mv.repaint();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                OptionPaneUtil.showMessageDialog((Component)Main.parent, (Object)I18n.tr((String)"Error loading file"), (String)I18n.tr((String)"Error"), (int)0);
                return;
            }
        }
    }

    public class SaveWmsAction
    extends AbstractAction {
        public SaveWmsAction() {
            super(I18n.tr((String)"Save WMS layer to file"), ImageProvider.get((String)"save"));
        }

        public void actionPerformed(ActionEvent ev) {
            File f = DiskAccessAction.createAndOpenSaveFileChooser((String)I18n.tr((String)"Save WMS layer"), (String)".wms");
            try {
                FileOutputStream fos = new FileOutputStream(f);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeInt(4);
                oos.writeInt(WMSLayer.this.dax);
                oos.writeInt(WMSLayer.this.day);
                oos.writeInt(WMSLayer.this.ImageSize);
                oos.writeDouble(WMSLayer.this.pixelPerDegree);
                oos.writeObject(WMSLayer.this.getName());
                oos.writeObject(WMSLayer.this.baseURL);
                oos.writeObject(WMSLayer.this.images);
                oos.close();
                fos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
    }

    public class ToggleAlphaAction
    extends AbstractAction {
        public ToggleAlphaAction() {
            super(I18n.tr((String)"Alpha channel"));
        }

        public void actionPerformed(ActionEvent ev) {
            JCheckBoxMenuItem checkbox = (JCheckBoxMenuItem)ev.getSource();
            boolean alphaChannel = checkbox.isSelected();
            Main.pref.put("wmsplugin.alpha_channel", alphaChannel);
            for (int x = 0; x < WMSLayer.this.dax; ++x) {
                for (int y = 0; y < WMSLayer.this.day; ++y) {
                    GeorefImage img = WMSLayer.this.images[WMSLayer.this.modulo(x, WMSLayer.this.dax)][WMSLayer.this.modulo(y, WMSLayer.this.day)];
                    img.flushedResizedCachedInstance();
                }
            }
            WMSLayer.this.mv.repaint();
        }
    }

    public class reloadErrorTilesAction
    extends AbstractAction {
        public reloadErrorTilesAction() {
            super(I18n.tr((String)"Reload erroneous tiles"));
        }

        public void actionPerformed(ActionEvent ev) {
            WMSPlugin.cache.customCleanUp(1, 2048);
            for (int x = 0; x < WMSLayer.this.dax; ++x) {
                for (int y = 0; y < WMSLayer.this.day; ++y) {
                    GeorefImage img = WMSLayer.this.images[WMSLayer.this.modulo(x, WMSLayer.this.dax)][WMSLayer.this.modulo(y, WMSLayer.this.day)];
                    img.image = null;
                    img.flushedResizedCachedInstance();
                    img.downloadingStarted = false;
                    img.failed = false;
                    WMSLayer.this.mv.repaint();
                }
            }
        }
    }

    public class changeResolutionAction
    extends AbstractAction {
        public changeResolutionAction() {
            super(I18n.tr((String)"Change resolution"));
        }

        public void actionPerformed(ActionEvent ev) {
            WMSLayer.this.initializeImages();
            WMSLayer.this.resolution = WMSLayer.this.mv.getDist100PixelText();
            WMSLayer.this.pixelPerDegree = WMSLayer.this.getPPD();
            WMSLayer.this.mv.repaint();
        }
    }

    public class downloadAction
    extends AbstractAction {
        public downloadAction() {
            super(I18n.tr((String)"Download visible tiles"));
        }

        public void actionPerformed(ActionEvent ev) {
            WMSLayer.this.downloadAndPaintVisible(WMSLayer.this.mv.getGraphics(), WMSLayer.this.mv);
        }
    }
}

