/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.editor;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagModel {
    private String name = null;
    private ArrayList<String> values = new ArrayList();

    public TagModel() {
        this.setName("");
        this.setValue("");
    }

    public TagModel(String name) {
        this();
        this.setName(name);
    }

    public TagModel(String name, String value) {
        this();
        this.setName(name);
        this.setValue(value);
    }

    public void setName(String name) {
        this.name = name = name == null ? "" : name;
    }

    public String getName() {
        return this.name;
    }

    public void clearValues() {
        this.values.clear();
    }

    public void setValue(String value) {
        value = value == null ? "" : value;
        this.clearValues();
        this.values.add(value);
    }

    public boolean hasValue(String value) {
        value = value == null ? "" : value;
        return this.values.contains(value);
    }

    public void addValue(String value) {
        String string = value = value == null ? "" : value;
        if (this.hasValue(value)) {
            return;
        }
        this.values.add(value);
    }

    public void removeValue(String value) {
        value = value == null ? "" : value;
        this.values.remove(value);
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getValue() {
        if (this.getValueCount() == 0) {
            return "";
        }
        if (this.getValueCount() == 1) {
            return this.values.get(0);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.values.size(); ++i) {
            sb.append(this.values.get(i));
            if (i + 1 >= this.values.size()) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    public int getValueCount() {
        return this.values.size();
    }
}

