/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastreGrabber;
import cadastre_fr.DuplicateLayerException;
import cadastre_fr.EastNorthBound;
import cadastre_fr.WMSLayer;
import java.awt.GridBagLayout;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class CadastreInterface {
    public boolean downloadCancelled = false;
    public HttpURLConnection urlConn = null;
    private CadastreGrabber cadastreGrabber;
    private String cookie;
    private String interfaceRef = null;
    private URL searchFormURL;
    private Vector<String> listOfCommunes = new Vector();
    private Vector<String> listOfTA = new Vector();
    final String baseURL = "http://www.cadastre.gouv.fr";
    final String cImageFormat = "Cette commune est au format ";
    final String cCommuneListStart = "<select name=\"codeCommune\"";
    final String cCommuneListEnd = "</select>";
    final String c0ptionListStart = "<option value=\"";
    final String cOptionListEnd = "</option>";
    final String cBBoxCommunStart = "new GeoBox(";
    final String cBBoxCommunEnd = ")";
    final String cInterfaceVector = "afficherCarteCommune.do";
    final String cInterfaceRaster = "afficherCarteTa.do";

    CadastreInterface(CadastreGrabber cadastreGrabber) {
        this.cadastreGrabber = cadastreGrabber;
    }

    public boolean retrieveInterface(WMSLayer wmsLayer) throws DuplicateLayerException {
        if (wmsLayer.getName().equals("")) {
            return false;
        }
        this.downloadCancelled = false;
        try {
            if (this.cookie == null || !wmsLayer.getName().equals(this.cadastreGrabber.getLastWMSLayerName())) {
                this.getCookie();
                this.getInterface(wmsLayer);
                this.cadastreGrabber.setLastWMSLayerName(wmsLayer.getName());
            }
            this.openInterface();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Town/city {0} not found or not available in WMS.\nPlease check its availibility on www.cadastre.gouv.fr", (Object[])new Object[]{wmsLayer.getLocation()}));
            return false;
        }
        return true;
    }

    private void getCookie() throws IOException {
        try {
            this.searchFormURL = new URL("http://www.cadastre.gouv.fr/scpc/rechercherPlan.do");
            this.urlConn = (HttpURLConnection)this.searchFormURL.openConnection();
            this.urlConn.setRequestMethod("GET");
            this.urlConn.connect();
            if (this.urlConn.getResponseCode() != 200) {
                throw new IOException("Cannot get Cadastre cookie.");
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(this.urlConn.getInputStream()));
            while (in.readLine() != null) {
            }
            String headerName = null;
            int i = 1;
            while ((headerName = this.urlConn.getHeaderFieldKey(i)) != null) {
                if (headerName.equals("Set-Cookie")) {
                    this.cookie = this.urlConn.getHeaderField(i);
                    this.cookie = this.cookie.substring(0, this.cookie.indexOf(";"));
                    System.out.println("Cookie=" + this.cookie);
                }
                ++i;
            }
        }
        catch (MalformedURLException e) {
            throw (IOException)new IOException("Illegal url.").initCause(e);
        }
    }

    public void resetCookie() {
        this.cadastreGrabber.setLastWMSLayerName(null);
    }

    public void resetCookieIfNewLayer(String newWMSLayerName) {
        if (!newWMSLayerName.equals(this.cadastreGrabber.getLastWMSLayerName())) {
            this.resetCookie();
        }
    }

    public void setCookie() {
        this.urlConn.setRequestProperty("Cookie", this.cookie);
    }

    private void getInterface(WMSLayer wmsLayer) throws IOException, DuplicateLayerException {
        this.interfaceRef = this.postForm(wmsLayer, "");
        if (this.interfaceRef == null) {
            if (!wmsLayer.getCodeCommune().equals("")) {
                this.interfaceRef = this.postForm(wmsLayer, wmsLayer.getCodeCommune());
            } else {
                if (this.listOfCommunes.size() > 1) {
                    wmsLayer.setCodeCommune(this.selectCommuneDialog());
                    this.checkLayerDuplicates(wmsLayer);
                    this.interfaceRef = this.postForm(wmsLayer, wmsLayer.getCodeCommune());
                }
                if (wmsLayer.isRaster() && this.listOfTA.size() > 1) {
                    wmsLayer.setCodeCommune(this.selectTADialog());
                    this.checkLayerDuplicates(wmsLayer);
                    this.interfaceRef = this.buildRasterInterfaceRef(wmsLayer.getCodeCommune());
                }
            }
        }
        if (this.interfaceRef == null) {
            throw new IOException("Town/city " + wmsLayer.getLocation() + " not found.");
        }
    }

    private void openInterface() throws IOException {
        try {
            URL interfaceURL = new URL("http://www.cadastre.gouv.fr/scpc/" + this.interfaceRef);
            this.urlConn = (HttpURLConnection)interfaceURL.openConnection();
            this.urlConn.setRequestMethod("GET");
            this.setCookie();
            this.urlConn.connect();
            if (this.urlConn.getResponseCode() != 200) {
                throw new IOException("Cannot open Cadastre interface. GET response:" + this.urlConn.getResponseCode());
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(this.urlConn.getInputStream()));
            while (in.readLine() != null) {
            }
            System.out.println("GET to open interface sent");
        }
        catch (MalformedURLException e) {
            throw (IOException)new IOException("CadastreGrabber: Illegal url.").initCause(e);
        }
    }

    private String postForm(WMSLayer wmsLayer, String codeCommune) throws IOException {
        try {
            int j;
            int i;
            String ln = null;
            String line = null;
            this.listOfCommunes.clear();
            this.listOfTA.clear();
            String content = "numerovoie=";
            content = content + "&indiceRepetition=";
            content = content + "&nomvoie=";
            content = content + "&lieuDit=";
            if (codeCommune == "") {
                content = content + "&ville=" + new String(URLEncoder.encode(wmsLayer.getLocation(), "UTF-8"));
                content = content + "&codePostal=";
            } else {
                content = content + "&codeCommune=" + codeCommune;
            }
            content = content + "&codeDepartement=";
            content = content + "&nbResultatParPage=10";
            this.urlConn = (HttpURLConnection)this.searchFormURL.openConnection();
            this.urlConn.setRequestMethod("POST");
            this.urlConn.setDoOutput(true);
            this.urlConn.setDoInput(true);
            this.setCookie();
            OutputStream wr = this.urlConn.getOutputStream();
            wr.write(content.getBytes());
            wr.flush();
            wr.close();
            BufferedReader rd = new BufferedReader(new InputStreamReader(this.urlConn.getInputStream()));
            while ((ln = rd.readLine()) != null) {
                line = line + ln;
            }
            rd.close();
            this.urlConn.disconnect();
            System.out.println("POST=" + line);
            if (line.indexOf("Cette commune est au format ") != -1) {
                i = line.indexOf("Cette commune est au format ");
                j = line.indexOf(".", i);
                wmsLayer.setRaster(line.substring(i + "Cette commune est au format ".length(), j).equals("image"));
            }
            if (!wmsLayer.isRaster() && line.indexOf("afficherCarteCommune.do") != -1) {
                line = line.substring(line.indexOf("afficherCarteCommune.do"), line.length());
                line = line.substring(0, line.indexOf("'"));
                System.out.println("interface ref.:" + line);
                return line;
            }
            if (wmsLayer.isRaster() && line.indexOf("afficherCarteTa.do") != -1) {
                this.parseTAList(line.substring(line.indexOf("afficherCarteTa.do")));
                if (this.listOfTA.size() == 1) {
                    wmsLayer.setCodeCommune(this.listOfTA.firstElement());
                    return this.buildRasterInterfaceRef(this.listOfTA.firstElement());
                }
                return null;
            }
            if (line.indexOf("<select name=\"codeCommune\"") != -1 && line.indexOf("</select>") != -1) {
                i = line.indexOf("<select name=\"codeCommune\"");
                j = line.indexOf("</select>", i);
                this.parseCommuneList(line.substring(i, j));
            }
        }
        catch (MalformedURLException e) {
            throw (IOException)new IOException("Illegal url.").initCause(e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void parseCommuneList(String input) {
        if (input.indexOf("<option value=\"") != -1) {
            while (input.indexOf("<option value=\"") != -1) {
                int i = input.indexOf("<option value=\"");
                int j = input.indexOf("</option>", i + "<option value=\"".length());
                int k = input.indexOf("\"", i + "<option value=\"".length());
                if (j != -1 && k > i + "<option value=\"".length()) {
                    String lov = new String(input.substring(i + "<option value=\"".length() - 1, j));
                    if (lov.indexOf(">") != -1) {
                        System.out.println("parse " + lov);
                        this.listOfCommunes.add(lov);
                    } else {
                        System.err.println("unable to parse commune string:" + lov);
                    }
                }
                input = input.substring(j + "</option>".length());
            }
        }
    }

    private void parseTAList(String input) {
        while (input.indexOf("afficherCarteTa.do") != -1) {
            input = input.substring(input.indexOf("afficherCarteTa.do"));
            String codeTA = input.substring(0, input.indexOf("'"));
            if (!this.listOfTA.contains(codeTA = codeTA.substring(codeTA.indexOf("=") + 1))) {
                System.out.println("parse " + codeTA);
                this.listOfTA.add(codeTA);
            }
            input = input.substring("afficherCarteTa.do".length());
        }
    }

    private String selectCommuneDialog() {
        JPanel p = new JPanel(new GridBagLayout());
        String[] communeList = new String[this.listOfCommunes.size() + 1];
        communeList[0] = I18n.tr((String)"Choose from...");
        for (int i = 0; i < this.listOfCommunes.size(); ++i) {
            communeList[i + 1] = this.listOfCommunes.elementAt(i).substring(this.listOfCommunes.elementAt(i).indexOf(">") + 1);
        }
        JComboBox<String> inputCommuneList = new JComboBox<String>(communeList);
        p.add(inputCommuneList, GBC.eol().fill(2).insets(10, 0, 0, 0));
        JOptionPane pane = new JOptionPane(p, 1, 2, null){
            private static final long serialVersionUID = 1L;
        };
        pane.createDialog(Main.parent, I18n.tr((String)"Select commune")).setVisible(true);
        if (!Integer.valueOf(0).equals(pane.getValue())) {
            return null;
        }
        String result = this.listOfCommunes.elementAt(inputCommuneList.getSelectedIndex() - 1);
        return result.substring(1, result.indexOf(">") - 2);
    }

    private String selectTADialog() {
        JPanel p = new JPanel(new GridBagLayout());
        JComboBox<String> inputTAList = new JComboBox<String>(this.listOfTA);
        p.add(inputTAList, GBC.eol().fill(2).insets(10, 0, 0, 0));
        JOptionPane pane = new JOptionPane(p, 1, 2, null){
            private static final long serialVersionUID = 1L;
        };
        pane.createDialog(Main.parent, I18n.tr((String)"Select Tableau d'Assemblage")).setVisible(true);
        if (!Integer.valueOf(0).equals(pane.getValue())) {
            return null;
        }
        String result = this.listOfTA.elementAt(inputTAList.getSelectedIndex());
        return result;
    }

    private String buildRasterInterfaceRef(String codeCommune) {
        return "afficherCarteTa.do?f=" + codeCommune;
    }

    public EastNorthBound retrieveCommuneBBox() throws IOException {
        if (this.interfaceRef == null) {
            return null;
        }
        String ln = null;
        String line = null;
        String content = "http://www.cadastre.gouv.fr/scpc/" + this.interfaceRef;
        content = content + "&dontSaveLastForward&keepVolatileSession=";
        this.searchFormURL = new URL(content);
        System.out.println("HEAD:" + content);
        this.urlConn = (HttpURLConnection)this.searchFormURL.openConnection();
        this.urlConn.setRequestMethod("GET");
        this.setCookie();
        this.urlConn.connect();
        if (this.urlConn.getResponseCode() != 200) {
            throw new IOException("Cannot get Cadastre response.");
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(this.urlConn.getInputStream()));
        while ((ln = in.readLine()) != null) {
            line = line + ln;
        }
        in.close();
        this.urlConn.disconnect();
        return this.parseBBoxCommune(line);
    }

    private EastNorthBound parseBBoxCommune(String input) {
        if (input.indexOf("new GeoBox(") != -1) {
            input = input.substring(input.indexOf("new GeoBox("));
            int i = input.indexOf(",");
            double minx = Double.parseDouble(input.substring("new GeoBox(".length(), i));
            int j = input.indexOf(",", i + 1);
            double miny = Double.parseDouble(input.substring(i + 1, j));
            int k = input.indexOf(",", j + 1);
            double maxx = Double.parseDouble(input.substring(j + 1, k));
            int l = input.indexOf(")", k + 1);
            double maxy = Double.parseDouble(input.substring(k + 1, l));
            return new EastNorthBound(new EastNorth(minx, miny), new EastNorth(maxx, maxy));
        }
        return null;
    }

    private void checkLayerDuplicates(WMSLayer wmsLayer) throws DuplicateLayerException {
        if (Main.map != null) {
            for (Layer l : Main.map.mapView.getAllLayers()) {
                if (!(l instanceof WMSLayer) || !l.getName().equals(wmsLayer.getName()) || l == wmsLayer) continue;
                System.out.println("Try to grab into a new layer when " + wmsLayer.getName() + " is already opened.");
                Main.map.mapView.removeLayer((Layer)wmsLayer);
                throw new DuplicateLayerException();
            }
        }
    }

    public void cancel() {
        if (this.urlConn != null) {
            this.urlConn.setConnectTimeout(1);
            this.urlConn.setReadTimeout(1);
        }
        this.downloadCancelled = true;
        this.cadastreGrabber.setLastWMSLayerName(null);
    }
}

