/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.openLayers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.openLayers.Browser;
import org.openstreetmap.josm.plugins.openLayers.MyHtmlBlockPanel;
import org.openstreetmap.josm.plugins.openLayers.OpenLayersPlugin;
import org.openstreetmap.josm.plugins.openLayers.StorageManager;
import org.openstreetmap.josm.tools.ImageProvider;

public class OpenLayersLayer
extends Layer
implements Preferences.PreferenceChangedListener,
PropertyChangeListener,
MyHtmlBlockPanel.ViewUpdateListener {
    private Browser browser = new Browser(OpenLayersPlugin.pluginDir + "yahoo.html", this);

    public OpenLayersLayer() {
        super("OpenLayers");
        if (Main.map != null) {
            LatLon bottomLeft = Main.map.mapView.getLatLon(0, Main.map.mapView.getHeight());
            LatLon topRight = Main.map.mapView.getLatLon(Main.map.mapView.getWidth(), 0);
            this.browser.executeAsyncScript("zoomMapToExtent(" + bottomLeft.lon() + "," + bottomLeft.lat() + "," + topRight.lon() + "," + topRight.lat() + ")");
        }
    }

    public void paint(Graphics g, MapView mv) {
        this.setSize(Main.map.mapView.getSize());
        this.browser.paint(g);
    }

    public void setSize(Dimension dim) {
        this.browser.setSize(dim);
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"OpenLayers");
    }

    public Object getInfoComponent() {
        return null;
    }

    public Component[] getMenuEntries() {
        return new Component[]{new JMenuItem((Action)LayerListDialog.getInstance().createShowHideLayerAction((Layer)this)), new JMenuItem((Action)LayerListDialog.getInstance().createDeleteLayerAction((Layer)this)), new JSeparator(), new JMenuItem((Action)new RenameLayerAction(this.getAssociatedFile(), (Layer)this)), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
    }

    public String getToolTipText() {
        return null;
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public void destroy() {
        Main.pref.listener.remove(this);
        if (Main.map != null) {
            Main.map.mapView.removePropertyChangeListener((PropertyChangeListener)this);
        }
        OpenLayersPlugin.layer = null;
        StorageManager.flush();
    }

    public void preferenceChanged(String key, String newValue) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.isVisible()) {
            return;
        }
        String prop = evt.getPropertyName();
        if ("center".equals(prop) || "scale".equals(prop)) {
            this.zoomToMapView();
        }
    }

    public void zoomToMapView() {
        LatLon bottomLeft = Main.map.mapView.getLatLon(0, Main.map.mapView.getHeight());
        LatLon topRight = Main.map.mapView.getLatLon(Main.map.mapView.getWidth(), 0);
        Object value = this.browser.executeScript("zoomMapToExtent(" + bottomLeft.lon() + "," + bottomLeft.lat() + "," + topRight.lon() + "," + topRight.lat() + ")");
        if (value != null) {
            // empty if block
        }
    }

    public void region_update(int x, int y, int w, int h) {
        String status = this.browser.getStatus();
        Main.map.mapView.repaint(x, y, w, h);
        Main.map.statusLine.setHelpText(status);
    }
}

