/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DiskStoreConfiguration {
    private static final Log LOG = LogFactory.getLog(DiskStoreConfiguration.class.getName());
    private String path;

    public final String getPath() {
        return this.path;
    }

    public final void setPath(String path) {
        String translatedPath = DiskStoreConfiguration.replaceToken("user.home", System.getProperty("user.home"), path);
        translatedPath = DiskStoreConfiguration.replaceToken("user.dir", System.getProperty("user.dir"), translatedPath);
        translatedPath = DiskStoreConfiguration.replaceToken("java.io.tmpdir", System.getProperty("java.io.tmpdir"), translatedPath);
        String separator = File.separator;
        translatedPath = DiskStoreConfiguration.replaceToken(File.separator + File.separator, File.separator, translatedPath);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Disk Store Path: " + translatedPath);
        }
        this.path = translatedPath;
    }

    public static String replaceToken(String token, String replacement, String source) {
        int foundIndex = source.indexOf(token);
        if (foundIndex == -1) {
            return source;
        }
        String firstFragment = source.substring(0, foundIndex);
        String lastFragment = source.substring(foundIndex + token.length(), source.length());
        return firstFragment + replacement + lastFragment;
    }
}

