/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.editgpx;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MapFrame;

public class EditGpxMode
extends MapMode {
    private static final long serialVersionUID = 7940589057093872411L;
    Point pointPressed;
    DataSet dataSet;
    MapFrame mapFrame;
    Rectangle oldRect;
    MapFrame frame;

    public EditGpxMode(MapFrame mapFrame, String name, String desc, DataSet ds) {
        super(name, "editgpx_mode.png", desc, mapFrame, Cursor.getPredefinedCursor(1));
        this.dataSet = ds;
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public void mousePressed(MouseEvent e) {
        this.pointPressed = new Point(e.getPoint());
    }

    public void mouseDragged(MouseEvent e) {
        if ((e.getModifiersEx() & 0x400) == 1024) {
            this.paintRect(this.pointPressed, e.getPoint());
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        Point pointReleased = e.getPoint();
        Rectangle r = this.createRect(pointReleased, this.pointPressed);
        for (Node n : this.dataSet.nodes) {
            Point p = Main.map.mapView.getPoint(n);
            if (!r.contains(p)) continue;
            n.deleted = true;
        }
        this.oldRect = null;
        Main.map.mapView.repaint();
    }

    public Rectangle createRect(Point p1, Point p2) {
        int h;
        int w;
        int y;
        int x;
        if (p1.x == p2.x && p1.y == p2.y) {
            x = p1.x - 1;
            y = p1.y - 1;
            w = 3;
            h = 3;
        } else {
            if (p1.x < p2.x) {
                x = p1.x;
                w = p2.x - p1.x;
            } else {
                x = p2.x;
                w = p1.x - p2.x;
            }
            if (p1.y < p2.y) {
                y = p1.y;
                h = p2.y - p1.y;
            } else {
                y = p2.y;
                h = p1.y - p2.y;
            }
        }
        return new Rectangle(x, y, w, h);
    }

    private void paintRect(Point p1, Point p2) {
        Graphics g = this.frame.getGraphics();
        Rectangle r = this.oldRect;
        if (r != null) {
            g.setXORMode(Color.BLACK);
            g.setColor(Color.WHITE);
            g.drawRect(r.x, r.y, r.width, r.height);
        }
        g.setXORMode(Color.BLACK);
        g.setColor(Color.WHITE);
        r = this.createRect(p1, p2);
        g.drawRect(r.x, r.y, r.width, r.height);
        this.oldRect = r;
    }

    public void setFrame(MapFrame mapFrame) {
        this.frame = mapFrame;
    }
}

