/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.NavigatableComponent;

public class GeorefImage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public EastNorth min;
    public EastNorth max;
    public EastNorth org_min;
    public EastNorth org_max;
    public BufferedImage image;
    private double angle = 0.0;
    private BufferedImage rotated_image;
    double pixelPerEast;
    double pixelPerNorth;

    public GeorefImage(BufferedImage img, EastNorth min, EastNorth max) {
        this.image = img;
        this.min = min;
        this.max = max;
        this.updatePixelPer();
    }

    public void displace(double dx, double dy) {
        this.min = new EastNorth(this.min.east() + dx, this.min.north() + dy);
        this.max = new EastNorth(this.max.east() + dx, this.max.north() + dy);
    }

    public void resize(EastNorth rasterCenter, double proportion) {
        this.min = this.min.interpolate(rasterCenter, proportion);
        this.max = this.max.interpolate(rasterCenter, proportion);
        this.updatePixelPer();
    }

    public void rotate(EastNorth pivot, double delta) {
        if (this.angle == 0.0) {
            this.org_min = this.min;
            this.org_max = this.max;
        }
        this.angle += delta;
        EastNorth imageCenter = this.org_min.interpolate(this.org_max, 0.5);
        EastNorth newimageCenter = imageCenter.rotate(pivot, this.angle);
        this.min.setLocation(this.org_min.east() + newimageCenter.east() - imageCenter.east(), this.org_min.north() + newimageCenter.north() - imageCenter.north());
        this.max.setLocation(this.org_max.east() + newimageCenter.east() - imageCenter.east(), this.org_max.north() + newimageCenter.north() - imageCenter.north());
        EastNorth min2 = new EastNorth(this.min.east(), this.max.north());
        EastNorth max2 = new EastNorth(this.max.east(), this.min.north());
        this.min = this.org_min.rotate(newimageCenter, this.angle);
        this.max = this.org_max.rotate(newimageCenter, this.angle);
        min2 = min2.rotate(newimageCenter, this.angle);
        max2 = max2.rotate(newimageCenter, this.angle);
        this.getNewBounding(this.min, this.max, min2, max2);
        this.rotated_image = GeorefImage.tilt(this.image, this.angle);
    }

    public static BufferedImage tilt(BufferedImage image, double angle) {
        double sin = Math.abs(Math.sin(angle));
        double cos = Math.abs(Math.cos(angle));
        int w = image.getWidth();
        int h = image.getHeight();
        int neww = (int)Math.floor((double)w * cos + (double)h * sin);
        int newh = (int)Math.floor((double)h * cos + (double)w * sin);
        GraphicsConfiguration gc = GeorefImage.getDefaultConfiguration();
        BufferedImage result = gc.createCompatibleImage(neww, newh, 3);
        Graphics2D g = result.createGraphics();
        g.translate((neww - w) / 2, (newh - h) / 2);
        g.rotate(angle, w / 2, h / 2);
        g.drawRenderedImage(image, null);
        g.dispose();
        return result;
    }

    public static GraphicsConfiguration getDefaultConfiguration() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.getDefaultConfiguration();
    }

    private void getNewBounding(EastNorth min, EastNorth max, EastNorth c, EastNorth d) {
        EastNorth[] pt = new EastNorth[]{min, max, c, d};
        double smallestEast = Double.MAX_VALUE;
        double smallestNorth = Double.MAX_VALUE;
        double highestEast = Double.MIN_VALUE;
        double highestNorth = Double.MIN_VALUE;
        for (int i = 0; i <= 3; ++i) {
            smallestEast = Math.min(pt[i].east(), smallestEast);
            smallestNorth = Math.min(pt[i].north(), smallestNorth);
            highestEast = Math.max(pt[i].east(), highestEast);
            highestNorth = Math.max(pt[i].north(), highestNorth);
        }
        min.setLocation(smallestEast, smallestNorth);
        max.setLocation(highestEast, highestNorth);
    }

    public boolean contains(EastNorth en) {
        return this.min.east() <= en.east() && en.east() <= this.max.east() && this.min.north() <= en.north() && en.north() <= this.max.north();
    }

    public void paint(Graphics2D g, NavigatableComponent nc, boolean backgroundTransparent, float transparency, boolean drawBoundaries) {
        if (this.image == null || this.min == null || this.max == null) {
            return;
        }
        BufferedImage toDisplay = this.angle != 0.0 ? this.rotated_image : this.image;
        Point minPt = nc.getPoint(this.min);
        Point maxPt = nc.getPoint(this.max);
        if (!g.hitClip(minPt.x, maxPt.y, maxPt.x - minPt.x, minPt.y - maxPt.y)) {
            return;
        }
        if (backgroundTransparent && transparency < 1.0f) {
            g.setComposite(AlphaComposite.getInstance(3, transparency));
        }
        if (drawBoundaries) {
            g.setColor(Color.green);
            g.drawRect(minPt.x, maxPt.y, maxPt.x - minPt.x, minPt.y - maxPt.y);
        }
        g.drawImage(toDisplay, minPt.x, maxPt.y, maxPt.x, minPt.y, 0, 0, toDisplay.getWidth(), toDisplay.getHeight(), null);
        if (backgroundTransparent && transparency < 1.0f) {
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
    }

    public boolean overlap(GeorefImage georefImage) {
        if (this.contains(georefImage.min) || this.contains(georefImage.max)) {
            return true;
        }
        return this.contains(new EastNorth(georefImage.min.east(), georefImage.max.north())) || this.contains(new EastNorth(georefImage.max.east(), georefImage.min.north()));
    }

    public void withdraw(GeorefImage georefImage) {
        double maxMaskNorth;
        double minMaskEast = georefImage.min.east() > this.min.east() ? georefImage.min.east() : this.min.east();
        double maxMaskEast = georefImage.max.east() < this.max.east() ? georefImage.max.east() : this.max.east();
        double minMaskNorth = georefImage.min.north() > this.min.north() ? georefImage.min.north() : this.min.north();
        double d = maxMaskNorth = georefImage.max.north() < this.max.north() ? georefImage.max.north() : this.max.north();
        if (maxMaskNorth - minMaskNorth > 0.0 && maxMaskEast - minMaskEast > 0.0) {
            double pixelPerEast = (this.max.east() - this.min.east()) / (double)this.image.getWidth();
            double pixelPerNorth = (this.max.north() - this.min.north()) / (double)this.image.getHeight();
            int minXMaskPixel = (int)((minMaskEast - this.min.east()) / pixelPerEast);
            int minYMaskPixel = (int)((this.max.north() - maxMaskNorth) / pixelPerNorth);
            int widthXMaskPixel = Math.abs((int)((maxMaskEast - minMaskEast) / pixelPerEast));
            int heightYMaskPixel = Math.abs((int)((maxMaskNorth - minMaskNorth) / pixelPerNorth));
            Graphics g = this.image.getGraphics();
            for (int x = minXMaskPixel; x < minXMaskPixel + widthXMaskPixel; ++x) {
                for (int y = minYMaskPixel; y < minYMaskPixel + heightYMaskPixel; ++y) {
                    this.image.setRGB(x, y, 1);
                }
            }
            g.dispose();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.max = (EastNorth)in.readObject();
        this.min = (EastNorth)in.readObject();
        this.image = ImageIO.read(ImageIO.createImageInputStream(in));
        this.updatePixelPer();
    }

    private void updatePixelPer() {
        this.pixelPerEast = (double)this.image.getWidth() / (this.max.east() - this.min.east());
        this.pixelPerNorth = (double)this.image.getHeight() / (this.max.north() - this.min.north());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.max);
        out.writeObject(this.min);
        ImageIO.write((RenderedImage)this.image, "png", ImageIO.createImageOutputStream(out));
    }

    public String toString() {
        return "GeorefImage[min=" + this.min + ", max=" + this.max + ", image" + this.image + "]";
    }
}

