/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.globalsat;

import gnu.io.CommPortIdentifier;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.globalsat.GlobalsatConfigDialog;
import org.openstreetmap.josm.plugins.globalsat.GlobalsatDg100;
import org.openstreetmap.josm.plugins.globalsat.GlobalsatPlugin;
import org.openstreetmap.josm.tools.I18n;

public class GlobalsatImportDialog
extends JPanel {
    private JOptionPane optionPane;
    private JCheckBox delete;
    private JComboBox portCombo;
    private List<CommPortIdentifier> ports = new LinkedList<CommPortIdentifier>();

    public GlobalsatImportDialog() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.portCombo = new JComboBox();
        this.portCombo.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object o, int x, boolean a, boolean b) {
                String value = ((CommPortIdentifier)o).getName();
                if (value == null) {
                    value = "null";
                }
                return new JLabel(value);
            }
        });
        this.portCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object i = GlobalsatImportDialog.this.portCombo.getSelectedItem();
                if (i instanceof CommPortIdentifier) {
                    GlobalsatPlugin.setPortIdent((CommPortIdentifier)i);
                    Main.pref.put("globalsat.portIdentifier", ((CommPortIdentifier)i).getName());
                }
            }
        });
        this.refreshPorts();
        c.insets = new Insets(4, 4, 4, 4);
        c.gridwidth = 1;
        c.weightx = 0.8;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)new JLabel(I18n.tr((String)"Port:")), c);
        c.gridwidth = 1;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.5;
        this.add((Component)this.portCombo, c);
        JButton refreshBtn = new JButton(I18n.tr((String)"Refresh"));
        refreshBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GlobalsatImportDialog.this.refreshPorts();
            }
        });
        refreshBtn.setToolTipText(I18n.tr((String)"refresh the port list"));
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 0;
        this.add((Component)refreshBtn, c);
        JButton configBtn = new JButton(I18n.tr((String)"Configure"));
        configBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("configureing the device");
                try {
                    GlobalsatConfigDialog dialog = new GlobalsatConfigDialog(GlobalsatPlugin.dg100().getConfig());
                    JOptionPane pane = new JOptionPane(dialog, -1, 2);
                    JDialog dlg = pane.createDialog(Main.parent, I18n.tr((String)"Configure Device"));
                    dialog.setOptionPane(pane);
                    dlg.setVisible(true);
                    if ((Integer)pane.getValue() == 0) {
                        GlobalsatPlugin.dg100().setConfig(dialog.getConfig());
                    }
                    dlg.dispose();
                }
                catch (GlobalsatDg100.ConnectionException ex) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Connection Error.") + " " + ex.toString());
                }
                System.out.println("configureing the device finised");
            }
        });
        configBtn.setToolTipText(I18n.tr((String)"configure the connected DG100"));
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 1;
        this.add((Component)configBtn, c);
        this.delete = new JCheckBox(I18n.tr((String)"delete data after import"));
        this.delete.setSelected(Main.pref.getBoolean("globalsat.deleteAfterDownload", false));
        c.gridwidth = 3;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 2;
        this.add((Component)this.delete, c);
    }

    public void refreshPorts() {
        String sel = Main.pref.get("globalsat.portIdentifier");
        this.portCombo.setVisible(false);
        this.portCombo.removeAllItems();
        Enumeration e = CommPortIdentifier.getPortIdentifiers();
        e = CommPortIdentifier.getPortIdentifiers();
        while (e.hasMoreElements()) {
            CommPortIdentifier port = (CommPortIdentifier)e.nextElement();
            if (port.getPortType() != 1) continue;
            this.portCombo.addItem(port);
            if (sel == null || port.getName() != sel) continue;
            this.portCombo.setSelectedItem(port);
            GlobalsatPlugin.setPortIdent(port);
        }
        this.portCombo.setVisible(true);
        GlobalsatPlugin.setPortIdent(this.getPort());
    }

    public boolean deleteFilesAfterDownload() {
        return this.delete.isSelected();
    }

    public CommPortIdentifier getPort() {
        return (CommPortIdentifier)this.portCombo.getSelectedItem();
    }

    public void setOptionPane(JOptionPane optionPane) {
        this.optionPane = optionPane;
    }
}

