/*
 * Decompiled with CFR 0.152.
 */
package terracer;

import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.AutoCompleteComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TerracerAction
extends JosmAction {
    public TerracerAction() {
        super(I18n.tr((String)"Terrace a building"), "terrace", I18n.tr((String)"Creates individual buildings from a long building."), Shortcut.registerShortcut((String)"tools:Terracer", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Terrace a building")}), (int)84, (int)3, (int)1), true);
    }

    public void actionPerformed(ActionEvent e) {
        Collection sel = Main.main.getCurrentDataSet().getSelected();
        boolean badSelect = false;
        if (sel.size() == 1) {
            OsmPrimitive prim = (OsmPrimitive)sel.iterator().next();
            if (prim instanceof Way) {
                Way way = (Way)prim;
                if (way.nodes.size() >= 5 && way.isClosed()) {
                    HouseNumberDialog dialog = new HouseNumberDialog();
                    JOptionPane optionPane = new JOptionPane(dialog, -1, 2);
                    String title = I18n.trn((String)"Change {0} object", (String)"Change {0} objects", (long)sel.size(), (Object[])new Object[]{sel.size()});
                    if (sel.size() == 0) {
                        title = I18n.tr((String)"Nothing selected!");
                    }
                    optionPane.createDialog(Main.parent, title).setVisible(true);
                    Object answerObj = optionPane.getValue();
                    if (answerObj != null && answerObj != JOptionPane.UNINITIALIZED_VALUE && answerObj instanceof Integer && (Integer)answerObj == 0) {
                        this.terraceBuilding(way, dialog.numberFrom(), dialog.numberTo(), dialog.stepSize(), dialog.streetName());
                    }
                } else {
                    badSelect = true;
                }
            } else {
                badSelect = true;
            }
        } else {
            badSelect = true;
        }
        if (badSelect) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Select a single, closed way of at least four nodes."));
        }
    }

    private void terraceBuilding(Way w, int from, int to, int step, String streetName) {
        int nb = 1 + (to - from) / step;
        Pair<Way, Way> interp = this.findFrontAndBack(w);
        double frontLength = this.wayLength((Way)interp.a);
        double backLength = this.wayLength((Way)interp.b);
        Node[][] new_nodes = new Node[2][nb + 1];
        LinkedList<AddCommand> commands = new LinkedList<AddCommand>();
        LinkedList<Way> ways = new LinkedList<Way>();
        for (int i = 0; i <= nb; ++i) {
            new_nodes[0][i] = this.interpolateAlong((Way)interp.a, frontLength * (double)i / (double)nb);
            new_nodes[1][i] = this.interpolateAlong((Way)interp.b, backLength * (double)i / (double)nb);
            commands.add(new AddCommand((OsmPrimitive)new_nodes[0][i]));
            commands.add(new AddCommand((OsmPrimitive)new_nodes[1][i]));
        }
        Relation relatedStreet = new Relation();
        relatedStreet.put("type", "relatedStreet");
        if (streetName != null) {
            relatedStreet.put("name", streetName);
        }
        for (int i = 0; i < nb; ++i) {
            Way terr = new Way();
            terr.nodes.add(new_nodes[0][i]);
            terr.nodes.add(new_nodes[0][i + 1]);
            terr.nodes.add(new_nodes[1][i + 1]);
            terr.nodes.add(new_nodes[1][i]);
            terr.nodes.add(new_nodes[0][i]);
            terr.put("addr:housenumber", "" + (from + i * step));
            terr.put("building", "yes");
            if (streetName != null) {
                terr.put("addr:street", streetName);
            }
            relatedStreet.members.add(new RelationMember("house", (OsmPrimitive)terr));
            ways.add(terr);
            commands.add(new AddCommand((OsmPrimitive)terr));
        }
        commands.add(new AddCommand((OsmPrimitive)relatedStreet));
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Terrace"), commands));
        Main.main.getCurrentDataSet().setSelected(ways);
    }

    private Node interpolateAlong(Way w, double l) {
        Node n = null;
        for (Pair p : w.getNodePairs(false)) {
            double seg_length = ((Node)p.a).getCoor().greatCircleDistance(((Node)p.b).getCoor());
            if (l <= seg_length) {
                n = this.interpolateNode((Node)p.a, (Node)p.b, l / seg_length);
                break;
            }
            l -= seg_length;
        }
        if (n == null) {
            n = (Node)w.nodes.get(w.nodes.size() - 1);
        }
        return n;
    }

    private double wayLength(Way w) {
        double length = 0.0;
        for (Pair p : w.getNodePairs(false)) {
            length += ((Node)p.a).getCoor().greatCircleDistance(((Node)p.b).getCoor());
        }
        return length;
    }

    private Pair<Way, Way> findFrontAndBack(Way w) {
        int i;
        int side2;
        double[] sideness = this.calculateSideness(w);
        int[] indexes = this.sortedIndexes(sideness);
        int side1 = indexes[0];
        if (Math.abs(side1 - (side2 = indexes[1])) < 2) {
            side2 = indexes[2];
        }
        if (Math.abs(side1 - side2) < 2) {
            side2 = indexes[3];
        }
        if (this.sideLength(w, side1) > this.sideLength(w, side1 + 1) && Math.abs(sideness[side1] - sideness[side1 + 1]) < 0.001) {
            ++side1;
            side2 = (side2 + 1) % (w.nodes.size() - 1);
        }
        if (side1 > side2) {
            int tmp = side2;
            side2 = side1;
            side1 = tmp;
        }
        Way front = new Way();
        Way back = new Way();
        for (i = side2 + 1; i < w.nodes.size() - 1; ++i) {
            front.nodes.add(w.nodes.get(i));
        }
        for (i = 0; i <= side1; ++i) {
            front.nodes.add(w.nodes.get(i));
        }
        for (i = side2; i > side1; --i) {
            back.nodes.add(w.nodes.get(i));
        }
        return new Pair((Object)front, (Object)back);
    }

    private double sideLength(Way w, int i) {
        Node a = (Node)w.nodes.get(i);
        Node b = (Node)w.nodes.get((i + 1) % (w.nodes.size() - 1));
        return a.getCoor().greatCircleDistance(b.getCoor());
    }

    private int[] sortedIndexes(double[] a) {
        int length = a.length;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SortWithIndex
        implements Comparable<SortWithIndex> {
            public double x;
            public int i;

            public SortWithIndex(double a, int b) {
                this.x = a;
                this.i = b;
            }

            @Override
            public int compareTo(SortWithIndex o) {
                return Double.compare(this.x, o.x);
            }
        }
        ArrayList<SortWithIndex> sortable = new ArrayList<SortWithIndex>(length);
        for (int i = 0; i < length; ++i) {
            sortable.add(new SortWithIndex(a[i], i));
        }
        Collections.sort(sortable);
        int[] indexes = new int[length];
        for (int i = 0; i < length; ++i) {
            indexes[i] = ((SortWithIndex)sortable.get((int)i)).i;
        }
        return indexes;
    }

    private double[] calculateSideness(Way w) {
        int length = w.nodes.size() - 1;
        double[] sideness = new double[length];
        sideness[0] = this.calculateSideness((Node)w.nodes.get(length - 1), (Node)w.nodes.get(0), (Node)w.nodes.get(1), (Node)w.nodes.get(2));
        for (int i = 1; i < length - 1; ++i) {
            sideness[i] = this.calculateSideness((Node)w.nodes.get(i - 1), (Node)w.nodes.get(i), (Node)w.nodes.get(i + 1), (Node)w.nodes.get(i + 2));
        }
        sideness[length - 1] = this.calculateSideness((Node)w.nodes.get(length - 2), (Node)w.nodes.get(length - 1), (Node)w.nodes.get(length), (Node)w.nodes.get(1));
        return sideness;
    }

    private double calculateSideness(Node a, Node b, Node c, Node d) {
        double ndx = b.getCoor().getX() - a.getCoor().getX();
        double pdx = d.getCoor().getX() - c.getCoor().getX();
        double ndy = b.getCoor().getY() - a.getCoor().getY();
        double pdy = d.getCoor().getY() - c.getCoor().getY();
        return (ndx * pdx + ndy * pdy) / Math.sqrt((ndx * ndx + ndy * ndy) * (pdx * pdx + pdy * pdy));
    }

    private TreeSet<String> createAutoCompletionInfo() {
        TreeSet<String> names = new TreeSet<String>();
        for (OsmPrimitive osm : Main.main.getCurrentDataSet().allNonDeletedPrimitives()) {
            if (osm.keys == null || !osm.keys.containsKey("highway") || !osm.keys.containsKey("name")) continue;
            names.add((String)osm.keys.get("name"));
        }
        return names;
    }

    private Node interpolateNode(Node a, Node b, double f) {
        Node n = new Node(this.interpolateLatLon(a, b, f));
        return n;
    }

    private LatLon interpolateLatLon(Node a, Node b, double f) {
        return new LatLon(a.getCoor().lat() * (1.0 - f) + b.getCoor().lat() * f, a.getCoor().lon() * (1.0 - f) + b.getCoor().lon() * f);
    }

    class HouseNumberDialog
    extends JPanel {
        private SpinnerNumberModel lo;
        private SpinnerNumberModel hi;
        private JSpinner clo;
        private JSpinner chi;
        private Choice step;
        private AutoCompleteComboBox street;

        public HouseNumberDialog() {
            super(new GridBagLayout());
            this.lo = new SpinnerNumberModel(1, 1, 1, 1);
            this.hi = new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1);
            this.step = new Choice();
            this.step.add(I18n.tr((String)"All"));
            this.step.add(I18n.tr((String)"Even"));
            this.step.add(I18n.tr((String)"Odd"));
            this.clo = new JSpinner(this.lo);
            this.chi = new JSpinner(this.hi);
            this.lo.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    HouseNumberDialog.this.hi.setMinimum((Integer)HouseNumberDialog.this.lo.getNumber());
                }
            });
            this.hi.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    HouseNumberDialog.this.lo.setMaximum((Integer)HouseNumberDialog.this.hi.getNumber());
                }
            });
            this.step.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (HouseNumberDialog.this.step.getSelectedItem() == I18n.tr((String)"All")) {
                        HouseNumberDialog.this.hi.setStepSize(1);
                        HouseNumberDialog.this.lo.setStepSize(1);
                    } else {
                        int nextval;
                        int odd_or_even = 0;
                        int min = 0;
                        if (HouseNumberDialog.this.step.getSelectedItem() == I18n.tr((String)"Even")) {
                            odd_or_even = 0;
                            min = 2;
                        } else {
                            odd_or_even = 1;
                            min = 1;
                        }
                        if ((HouseNumberDialog.this.lo.getNumber().intValue() & 1) != odd_or_even) {
                            nextval = HouseNumberDialog.this.lo.getNumber().intValue() - 1;
                            HouseNumberDialog.this.lo.setValue(nextval > min ? nextval : min);
                        }
                        if ((HouseNumberDialog.this.hi.getNumber().intValue() & 1) != odd_or_even) {
                            nextval = HouseNumberDialog.this.hi.getNumber().intValue() - 1;
                            HouseNumberDialog.this.hi.setValue(nextval > min ? nextval : min);
                        }
                        HouseNumberDialog.this.lo.setMinimum(Integer.valueOf(min));
                        HouseNumberDialog.this.hi.setStepSize(2);
                        HouseNumberDialog.this.lo.setStepSize(2);
                    }
                }
            });
            TreeSet names = TerracerAction.this.createAutoCompletionInfo();
            this.street = new AutoCompleteComboBox();
            this.street.setPossibleItems((Collection)names);
            this.street.setEditable(true);
            this.street.setSelectedItem(null);
            JFormattedTextField x = ((JSpinner.DefaultEditor)this.clo.getEditor()).getTextField();
            x.setColumns(5);
            x = ((JSpinner.DefaultEditor)this.chi.getEditor()).getTextField();
            x.setColumns(5);
            this.addLabelled(I18n.tr((String)"Highest number") + ": ", this.chi);
            this.addLabelled(I18n.tr((String)"Lowest number") + ": ", this.clo);
            this.addLabelled(I18n.tr((String)"Interpolation") + ": ", this.step);
            this.addLabelled(I18n.tr((String)"Street name") + " (" + I18n.tr((String)"Optional") + "): ", (Component)this.street);
        }

        private void addLabelled(String str, Component c) {
            JLabel label = new JLabel(str);
            this.add((Component)label, GBC.std());
            label.setLabelFor(c);
            this.add(c, GBC.eol());
        }

        public int numberFrom() {
            return this.lo.getNumber().intValue();
        }

        public int numberTo() {
            return this.hi.getNumber().intValue();
        }

        public int stepSize() {
            return this.step.getSelectedItem() == I18n.tr((String)"All") ? 1 : 2;
        }

        public String streetName() {
            Object selected = this.street.getSelectedItem();
            if (selected == null) {
                return null;
            }
            String name = selected.toString();
            if (name.length() == 0) {
                return null;
            }
            return name;
        }
    }
}

